/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.convert;

import com.intellij.conversion.CannotConvertException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.JDOMUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class JDomConvertingUtil {
    private JDomConvertingUtil() {
    }

    public static Element load(Path file2) throws CannotConvertException {
        try {
            return JDOMUtil.load(file2);
        }
        catch (IOException | JDOMException e) {
            throw new CannotConvertException(file2 + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static String getOptionValue(Element element2, String optionName) {
        return JDOMExternalizerUtil.readField(element2, optionName);
    }

    public static Condition<Element> createAttributeValueFilter(@NonNls String name2, @NonNls String value) {
        return JDomConvertingUtil.createAttributeValueFilter(name2, Collections.singleton(value));
    }

    public static Condition<Element> createAttributeValueFilter(@NonNls String name2, @NonNls Collection<String> value) {
        return element2 -> value.contains(element2.getAttributeValue(name2));
    }

    public static Condition<Element> createElementWithAttributeFilter(String elementName, String attributeName, String attributeValue) {
        return Conditions.and(JDomConvertingUtil.createElementNameFilter(elementName), JDomConvertingUtil.createAttributeValueFilter(attributeName, attributeValue));
    }

    public static Condition<Element> createElementNameFilter(@NonNls String elementName) {
        return element2 -> elementName.equals(element2.getName());
    }

    public static List<Element> removeChildren(Element element2, Condition<? super Element> filter2) {
        ArrayList<Element> toRemove2 = new ArrayList<Element>();
        List<Element> list2 = element2.getChildren();
        for (Element e : list2) {
            if (!filter2.value(e)) continue;
            toRemove2.add(e);
        }
        for (Element e : toRemove2) {
            element2.removeContent(e);
        }
        return toRemove2;
    }

    @Nullable
    public static Element findChild(Element parent, Condition<? super Element> filter2) {
        List<Element> list2 = parent.getChildren();
        for (Element e : list2) {
            if (!filter2.value(e)) continue;
            return e;
        }
        return null;
    }

    public static void removeDuplicatedOptions(Element element2) {
        ArrayList<Element> children2 = new ArrayList<Element>(element2.getChildren("option"));
        HashSet<String> names = new HashSet<String>();
        for (Element child : children2) {
            if (names.add(child.getAttributeValue("name"))) continue;
            element2.removeContent(child);
        }
    }
}

