/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.ui.NavBarLocation;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class NavBarBorder
implements Border {
    private static final Color BORDER_COLOR = JBColor.namedColor("NavBar.borderColor", new JBColor(Gray.xCD, (Color)Gray.x51));
    private static final Insets NO_RUN_INSETS = JBUI.insets("NavBar.Breadcrumbs.itemInsets", JBUI.insets(4, 2));
    private static final JBValue BW = new JBValue.Float(1.0f);

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (UISettings.getInstance().getShowMainToolbar()) {
            g.setColor(BORDER_COLOR);
            g.fillRect(x, y, width, BW.get());
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        UISettings settings = UISettings.getInstance();
        if (ExperimentalUI.isNewUI() && settings.getShowNavigationBar()) {
            if (settings.getNavBarLocation() == NavBarLocation.TOP) {
                return NO_RUN_INSETS;
            }
            return JBUI.insets(3, 0, 4, 4);
        }
        if (!settings.getShowMainToolbar()) {
            return JBUI.insets(1, 0, 1, 4);
        }
        return JBUI.insets(1, 0, 0, 4);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

