/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.navigationToolbar.NavBarIdeView;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarListener;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.navigationToolbar.NavBarPopup;
import com.intellij.ide.navigationToolbar.NavBarPresentation;
import com.intellij.ide.navigationToolbar.NavBarRootPaneExtension;
import com.intellij.ide.navigationToolbar.NavBarUpdateQueue;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PanelUI;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarPanel
extends JPanel
implements DataProvider,
PopupOwner,
Disposable,
Queryable {
    private final NavBarModel myModel;
    private final NavBarPresentation myPresentation;
    protected final Project myProject;
    private final ArrayList<NavBarItem> myList;
    private final IdeView myIdeView;
    private FocusListener myNavBarItemFocusListener;
    private LightweightHint myHint;
    private NavBarPopup myNodePopup;
    private JComponent myHintContainer;
    private Component myContextComponent;
    private final NavBarUpdateQueue myUpdateQueue;
    private final Set<PsiFile> myForcedFileUpdateQueue;
    private NavBarItem myContextObject;
    private boolean myDisposed;
    private RelativePoint myLocationCache;

    public NavBarPanel(@NotNull Project project2, boolean docked) {
        if (project2 == null) {
            NavBarPanel.$$$reportNull$$$0(0);
        }
        super(new FlowLayout(0, 0, 0));
        this.myList = new ArrayList();
        this.myHint = null;
        this.myNodePopup = null;
        this.myForcedFileUpdateQueue = new HashSet<PsiFile>();
        this.myDisposed = false;
        this.myProject = project2;
        this.myModel = this.createModel();
        this.myIdeView = new NavBarIdeView(this);
        this.myPresentation = new NavBarPresentation(this.myProject);
        this.myUpdateQueue = new NavBarUpdateQueue(this);
        this.installPopupHandler(this, -1);
        this.setOpaque(false);
        if (!ExperimentalUI.isNewUI() && !docked && StartupUiUtil.isUnderDarcula()) {
            this.setBorder(new LineBorder(Gray._120, 1));
        }
        this.myUpdateQueue.queueModelUpdateFromFocus();
        this.myUpdateQueue.queueRebuildUi();
        Disposer.register(project2, this);
        AccessibleContextUtil.setName((Component)this, IdeBundle.message((String)"navigation.bar", (Object[])new Object[0]));
    }

    protected boolean allowNavItemsFocus() {
        return ScreenReader.isActive();
    }

    public boolean isFocused() {
        if (this.allowNavItemsFocus()) {
            return UIUtil.isFocusAncestor(this);
        }
        return this.hasFocus();
    }

    public void addNavBarItemFocusListener(@Nullable FocusListener l) {
        if (l == null) {
            return;
        }
        this.myNavBarItemFocusListener = AWTEventMulticaster.add(this.myNavBarItemFocusListener, l);
    }

    public void removeNavBarItemFocusListener(@Nullable FocusListener l) {
        if (l == null) {
            return;
        }
        this.myNavBarItemFocusListener = AWTEventMulticaster.remove(this.myNavBarItemFocusListener, l);
    }

    protected void fireNavBarItemFocusGained(FocusEvent e) {
        FocusListener listener2 = this.myNavBarItemFocusListener;
        if (listener2 != null) {
            listener2.focusGained(e);
        }
    }

    protected void fireNavBarItemFocusLost(FocusEvent e) {
        FocusListener listener2 = this.myNavBarItemFocusListener;
        if (listener2 != null) {
            listener2.focusLost(e);
        }
    }

    protected NavBarModel createModel() {
        return new NavBarModel(this.myProject);
    }

    @Nullable
    public NavBarPopup getNodePopup() {
        return this.myNodePopup;
    }

    public boolean isNodePopupActive() {
        return this.myNodePopup != null && this.myNodePopup.isVisible();
    }

    public LightweightHint getHint() {
        return this.myHint;
    }

    public NavBarPresentation getPresentation() {
        return this.myPresentation;
    }

    public void setContextComponent(@Nullable Component contextComponent) {
        this.myContextComponent = contextComponent;
    }

    public NavBarItem getContextObject() {
        return this.myContextObject;
    }

    public List<NavBarItem> getItems() {
        return Collections.unmodifiableList(this.myList);
    }

    public void addItem(NavBarItem item) {
        this.myList.add(item);
    }

    public void clearItems() {
        NavBarItem[] toDispose = this.myList.toArray(new NavBarItem[0]);
        this.myList.clear();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (NavBarItem item : toDispose) {
                Disposer.dispose(item);
            }
        });
        this.getNavBarUI().clearItems();
    }

    @Override
    public void setUI(PanelUI ui2) {
        this.getNavBarUI().clearItems();
        super.setUI(ui2);
    }

    public NavBarUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    public void escape() {
        this.myModel.setSelectedIndex(-1);
        this.hideHint();
        ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
    }

    public void enter() {
        int index = this.myModel.getSelectedIndex();
        if (index != -1) {
            this.ctrlClick(index);
        }
    }

    public void moveHome() {
        this.shiftFocus(-this.myModel.getSelectedIndex());
    }

    public void navigate() {
        if (this.myModel.getSelectedIndex() != -1) {
            this.doubleClick(this.myModel.getSelectedIndex());
        }
    }

    public void moveDown() {
        int index = this.myModel.getSelectedIndex();
        if (index != -1) {
            if (this.myModel.size() - 1 == index) {
                this.shiftFocus(-1);
                this.ctrlClick(index - 1);
            } else {
                this.ctrlClick(index);
            }
        }
    }

    public void moveEnd() {
        this.shiftFocus(this.myModel.size() - 1 - this.myModel.getSelectedIndex());
    }

    public Project getProject() {
        return this.myProject;
    }

    public NavBarModel getModel() {
        return this.myModel;
    }

    @Override
    public void dispose() {
        this.cancelPopup();
        this.getNavBarUI().clearItems();
        this.myDisposed = true;
        NavBarListener.unsubscribeFrom(this);
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    boolean isSelectedInPopup(Object object) {
        return this.isNodePopupActive() && this.myNodePopup.getList().getSelectedValuesList().contains(object);
    }

    static Object expandDirsWithJustOneSubdir(Object target2) {
        if (target2 instanceof PsiElement && !((PsiElement)target2).isValid()) {
            return target2;
        }
        if (target2 instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)target2;
            VirtualFile file2 = directory.getVirtualFile();
            while (true) {
                VirtualFile next;
                VirtualFile[] children2;
                VirtualFile child = (children2 = file2.getChildren()).length == 1 ? children2[0] : null;
                VirtualFile virtualFile2 = next = child != null && child.isDirectory() && !child.is(VFileProperty.SYMLINK) ? child : null;
                if (next == null) {
                    return ObjectUtils.notNull(directory.getManager().findDirectory(file2), directory);
                }
                file2 = next;
            }
        }
        return target2;
    }

    protected void updateItems() {
        NavBarRootPaneExtension.NavBarWrapperPanel wrapperPanel;
        for (NavBarItem item : new ArrayList<NavBarItem>(this.myList)) {
            item.update();
        }
        if (UISettings.getInstance().getShowNavigationBar() && (wrapperPanel = ComponentUtil.getParentOfType(NavBarRootPaneExtension.NavBarWrapperPanel.class, this)) != null) {
            wrapperPanel.revalidate();
            wrapperPanel.repaint();
        }
    }

    public void rebuildAndSelectItem(Function<? super List<NavBarItem>, Integer> indexToSelectCallback, boolean showPopup2) {
        this.myUpdateQueue.queueModelUpdateFromFocus();
        this.myUpdateQueue.queueRebuildUi();
        this.myUpdateQueue.queueSelect(() -> {
            if (!this.myList.isEmpty()) {
                int index = (Integer)indexToSelectCallback.apply(this.myList);
                this.myModel.setSelectedIndex(index);
                this.requestSelectedItemFocus();
                if (showPopup2) {
                    this.ctrlClick(index);
                }
            }
        });
        this.myUpdateQueue.flush();
    }

    public void rebuildAndSelectTail(boolean requestFocus) {
        this.rebuildAndSelectItem(list2 -> list2.size() - 1, false);
    }

    public void requestSelectedItemFocus() {
        int index = this.myModel.getSelectedIndex();
        if (index >= 0 && index < this.myModel.size() && this.allowNavItemsFocus()) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)this.getItem(index)), true);
        } else {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this, true);
        }
    }

    public void moveLeft() {
        this.shiftFocus(-1);
    }

    public void moveRight() {
        this.shiftFocus(1);
    }

    void shiftFocus(int direction) {
        int selectedIndex = this.myModel.getSelectedIndex();
        int index = this.myModel.getIndexByModel(selectedIndex + direction);
        this.myModel.setSelectedIndex(index);
        if (this.allowNavItemsFocus()) {
            this.requestSelectedItemFocus();
        }
    }

    protected void scrollSelectionToVisible() {
        int selectedIndex = this.myModel.getSelectedIndex();
        if (selectedIndex == -1 || selectedIndex >= this.myList.size()) {
            return;
        }
        this.scrollRectToVisible(this.myList.get(selectedIndex).getBounds());
    }

    @Nullable
    private NavBarItem getItem(int index) {
        if (index != -1 && index < this.myList.size()) {
            return this.myList.get(index);
        }
        return null;
    }

    public boolean isInFloatingMode() {
        return this.myHint != null && this.myHint.isVisible();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myDisposed || !this.myList.isEmpty()) {
            return super.getPreferredSize();
        }
        NavBarItem item = new NavBarItem(this, null, 0, null);
        Dimension size = item.getPreferredSize();
        ApplicationManager.getApplication().executeOnPooledThread(() -> Disposer.dispose(item));
        return size;
    }

    public boolean isRebuildUiNeeded() {
        this.myModel.revalidate();
        if (this.myList.size() == this.myModel.size()) {
            int index = 0;
            for (NavBarItem eachLabel : this.myList) {
                Object eachElement = this.myModel.get(index);
                if (eachLabel.getObject() == null || !eachLabel.getObject().equals(eachElement)) {
                    return true;
                }
                if (eachLabel.getObject() instanceof PsiFile && this.myForcedFileUpdateQueue.remove(eachLabel.getObject())) {
                    return true;
                }
                if (!StringUtil.equals(eachLabel.getText(), this.getPresentation().getPresentableText(eachElement, false))) {
                    return true;
                }
                if (!Objects.equals(eachLabel.getIcon(), this.getPresentation().getIcon(eachElement))) {
                    return true;
                }
                SimpleTextAttributes modelAttributes1 = this.myPresentation.getTextAttributes(eachElement, true);
                SimpleTextAttributes modelAttributes2 = this.myPresentation.getTextAttributes(eachElement, false);
                SimpleTextAttributes labelAttributes = eachLabel.getAttributes();
                if (!modelAttributes1.toTextAttributes().equals(labelAttributes.toTextAttributes()) && !modelAttributes2.toTextAttributes().equals(labelAttributes.toTextAttributes())) {
                    return true;
                }
                ++index;
            }
            return false;
        }
        return true;
    }

    void installPopupHandler(final @NotNull JComponent component2, final int index) {
        if (component2 == null) {
            NavBarPanel.$$$reportNull$$$0(1);
        }
        component2.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup actionGroup = new ActionGroup(){

                    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                        ActionGroup group;
                        NavBarModelExtension modelExtension;
                        if (e == null) {
                            if (EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return EMPTY_ARRAY;
                        }
                        String popupGroupId = null;
                        Iterator<NavBarModelExtension> iterator = NavBarModelExtension.EP_NAME.getExtensionList().iterator();
                        while (iterator.hasNext() && (popupGroupId = (modelExtension = iterator.next()).getPopupMenuGroup(NavBarPanel.this)) == null) {
                        }
                        if (popupGroupId == null) {
                            popupGroupId = "NavbarPopupMenu";
                        }
                        AnAction[] anActionArray = (group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(popupGroupId)) == null ? EMPTY_ARRAY : group.getChildren(e);
                        if (anActionArray == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return anActionArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarPanel$1$1", "getChildren"));
                    }
                };
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("NavBar", actionGroup);
                popupMenu.setTargetComponent(component2);
                JPopupMenu menu = popupMenu.getComponent();
                menu.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        if (index != -1) {
                            NavBarPanel.this.myModel.setSelectedIndex(index);
                        }
                    }
                });
                menu.show(comp, x, y);
            }
        });
    }

    public void installActions(final int index, NavBarItem component2) {
        this.installPopupHandler((JComponent)((Object)component2), index);
        ListenerUtil.addMouseListener((Component)((Object)component2), (MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.isConsumed() || !ExperimentalUI.isNewUI()) {
                    return;
                }
                NavBarItem item = NavBarPanel.this.getItem(index);
                if (item != null) {
                    item.setMouseHover(true);
                    NavBarPanel.this.repaint();
                }
                e.consume();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.isConsumed() || !ExperimentalUI.isNewUI()) {
                    return;
                }
                NavBarItem item = NavBarPanel.this.getItem(index);
                if (item != null) {
                    item.setMouseHover(false);
                    NavBarPanel.this.repaint();
                }
                e.consume();
            }

            private void click(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    return;
                }
                if (e.getClickCount() == 1) {
                    NavBarPanel.this.ctrlClick(index);
                    e.consume();
                } else if (e.getClickCount() == 2 && e.getButton() == 1) {
                    NavBarPanel.this.requestSelectedItemFocus();
                    NavBarPanel.this.doubleClick(index);
                    e.consume();
                }
            }
        });
        ListenerUtil.addKeyListener((Component)((Object)component2), (KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                    NavBarPanel.this.ctrlClick(index);
                    NavBarPanel.this.myModel.setSelectedIndex(index);
                    e.consume();
                }
            }
        });
    }

    private void installDnD(final int index, NavBarItem component2) {
        DnDSupport.createBuilder((JComponent)((Object)component2)).setBeanProvider(dnDActionInfo -> new DnDDragStartBean((Object)new TransferableWrapper(){

            public List<File> asFileList() {
                Object o = NavBarPanel.this.myModel.get(index);
                if (o instanceof PsiElement) {
                    VirtualFile vf;
                    VirtualFile virtualFile2 = vf = o instanceof PsiDirectory ? ((PsiDirectory)o).getVirtualFile() : ((PsiElement)o).getContainingFile().getVirtualFile();
                    if (vf != null) {
                        return Collections.singletonList(new File(vf.getPath()).getAbsoluteFile());
                    }
                }
                return Collections.emptyList();
            }

            public TreeNode[] getTreeNodes() {
                return null;
            }

            public PsiElement[] getPsiElements() {
                return null;
            }
        })).setDisposableParent((Disposable)component2).install();
    }

    private void doubleClick(int index) {
        this.doubleClick(this.myModel.getElement(index));
    }

    protected void doubleClick(Object object) {
        Object target2 = ObjectUtils.chooseNotNull(this.getNavigatable(object), object);
        if (target2 instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)target2;
            if (navigatable.canNavigate()) {
                navigatable.navigate(true);
            }
        } else if (target2 instanceof Module) {
            ProjectView projectView = ProjectView.getInstance(this.myProject);
            AbstractProjectViewPane projectViewPane = projectView.getProjectViewPaneById(projectView.getCurrentViewId());
            if (projectViewPane != null) {
                projectViewPane.selectModule((Module)target2, true);
            }
        } else if (target2 instanceof Project) {
            return;
        }
        this.hideHint(true);
    }

    @Nullable
    private Navigatable getNavigatable(Object object) {
        return (Navigatable)NavBarPanel.getSlowData(CommonDataKeys.NAVIGATABLE.getName(), this.myProject, JBIterable.of(object));
    }

    private void ctrlClick(int index) {
        Object object;
        List<Object> objects;
        if (this.isNodePopupActive()) {
            this.cancelPopup();
            if (this.myModel.getSelectedIndex() == index) {
                return;
            }
        }
        if (!(objects = this.myModel.getChildren(object = this.myModel.getElement(index))).isEmpty()) {
            Object[] siblings2 = new Object[objects.size()];
            for (int i = 0; i < objects.size(); ++i) {
                siblings2[i] = objects.get(i);
            }
            NavBarItem item = this.getItem(index);
            int selectedIndex = index < this.myModel.size() - 1 ? objects.indexOf(this.myModel.getElement(index + 1)) : 0;
            this.myNodePopup = new NavBarPopup(this, index, siblings2, index, selectedIndex);
            this.myNodePopup.show(item);
            item.update();
        }
    }

    protected void navigateInsideBar(int sourceItemIndex, Object object, boolean forceNavigate) {
        UIEventLogger.NavBarNavigate.log(this.myProject);
        boolean restorePopup = !forceNavigate && this.shouldRestorePopupOnSelect(object, sourceItemIndex);
        Object obj = NavBarPanel.expandDirsWithJustOneSubdir(object);
        this.myContextObject = null;
        this.myUpdateQueue.cancelAllUpdates();
        if (this.myNodePopup != null && this.myNodePopup.isVisible()) {
            this.myUpdateQueue.queueModelUpdateForObject(obj);
        }
        this.myUpdateQueue.queueRebuildUi();
        this.myUpdateQueue.queueAfterAll(() -> {
            int index = this.myModel.indexOf(obj);
            if (index >= 0) {
                this.myModel.setSelectedIndex(index);
            }
            if (this.myModel.hasChildren(obj) && restorePopup) {
                this.restorePopup();
            } else {
                this.doubleClick(obj);
            }
        }, NavBarUpdateQueue.ID.NAVIGATE_INSIDE);
    }

    private boolean shouldRestorePopupOnSelect(Object obj, int sourceItemIndex) {
        if (sourceItemIndex < this.myModel.size() - 1 && this.myModel.get(sourceItemIndex + 1) == obj) {
            return true;
        }
        return NavBarPanel.isExpandable(obj);
    }

    public static boolean isExpandable(Object obj) {
        if (!(obj instanceof PsiElement)) {
            return true;
        }
        PsiElement psiElement = (PsiElement)obj;
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Boolean expand = modelExtension.shouldExpandOnClick(psiElement);
            if (expand == null) continue;
            return expand;
        }
        return psiElement instanceof PsiDirectory || psiElement instanceof PsiDirectoryContainer;
    }

    void restorePopup() {
        this.cancelPopup();
        this.ctrlClick(this.myModel.getSelectedIndex());
    }

    void cancelPopup() {
        this.cancelPopup(false);
    }

    void cancelPopup(boolean ok2) {
        if (this.myNodePopup != null) {
            this.myNodePopup.hide(ok2);
            this.myNodePopup = null;
            if (this.allowNavItemsFocus()) {
                this.requestSelectedItemFocus();
            }
        }
    }

    void hideHint() {
        this.hideHint(false);
    }

    protected void hideHint(boolean ok2) {
        this.cancelPopup(ok2);
        if (this.myHint != null) {
            this.myHint.hide(ok2);
            this.myHint = null;
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            NavBarPanel.$$$reportNull$$$0(2);
        }
        return this.getDataImpl(dataId, this, () -> this.getSelection());
    }

    @NotNull
    JBIterable<?> getSelection() {
        int size = this.myModel.size();
        if (size == 0) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                NavBarPanel.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        int index = this.myModel.getSelectedIndex();
        int adjusted = index >= 0 && index < size ? index : size - 1;
        JBIterable<Object> jBIterable = JBIterable.of(this.myModel.getRaw(adjusted)).filterMap(this.myModel::unwrapRaw);
        if (jBIterable == null) {
            NavBarPanel.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @Nullable
    Object getDataImpl(@NotNull String dataId, @NotNull JComponent source, @NotNull Supplier<? extends JBIterable<?>> selection) {
        if (dataId == null) {
            NavBarPanel.$$$reportNull$$$0(5);
        }
        if (source == null) {
            NavBarPanel.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            NavBarPanel.$$$reportNull$$$0(7);
        }
        if (PlatformCoreDataKeys.CONTEXT_COMPONENT.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return !this.myProject.isDisposed() ? this.myProject : null;
        }
        if (PlatformCoreDataKeys.SLOW_DATA_PROVIDERS.is(dataId)) {
            JBIterable<?> finalSelection = selection.get();
            return Collections.singletonList(o -> NavBarPanel.getSlowData(o, this.myProject, finalSelection));
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Object data2 = modelExtension.getData(dataId, o -> null);
            if (data2 == null) continue;
            return data2;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.getCopyPasteDelegator(source).getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.getCopyPasteDelegator(source).getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.getCopyPasteDelegator(source).getPasteProvider();
        }
        return null;
    }

    @Nullable
    private static Object getSlowData(@NotNull String dataId, @NotNull Project project2, @NotNull JBIterable<?> selection) {
        if (dataId == null) {
            NavBarPanel.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            NavBarPanel.$$$reportNull$$$0(9);
        }
        if (selection == null) {
            NavBarPanel.$$$reportNull$$$0(10);
        }
        DataProvider provider2 = o -> NavBarPanel.getSlowDataImpl(o, project2, selection);
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Object data2 = modelExtension.getData(dataId, provider2);
            if (data2 == null) continue;
            return data2;
        }
        return provider2.getData(dataId);
    }

    @Nullable
    private static Object getSlowDataImpl(@NotNull String dataId, @NotNull Project project2, @NotNull JBIterable<?> selection) {
        if (dataId == null) {
            NavBarPanel.$$$reportNull$$$0(11);
        }
        if (project2 == null) {
            NavBarPanel.$$$reportNull$$$0(12);
        }
        if (selection == null) {
            NavBarPanel.$$$reportNull$$$0(13);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return !project2.isDisposed() ? project2 : null;
        }
        if (PlatformCoreDataKeys.MODULE.is(dataId)) {
            Module module = selection.filter(Module.class).first();
            if (module != null && !module.isDisposed()) {
                return module;
            }
            PsiElement element2 = selection.filter(PsiElement.class).first();
            if (element2 != null) {
                return ModuleUtilCore.findModuleForPsiElement(element2);
            }
            return null;
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            VirtualFile dir;
            PsiDirectory directory = selection.filter(PsiDirectory.class).first();
            if (directory != null && ProjectRootsUtil.isModuleContentRoot(dir = directory.getVirtualFile(), project2)) {
                return ModuleUtilCore.findModuleForPsiElement(directory);
            }
            return null;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement element3 = selection.filter(PsiElement.class).first();
            return element3 != null && element3.isValid() ? element3 : null;
        }
        if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            List<PsiElement> result2 = selection.filter(PsiElement.class).filter(e -> e != null && e.isValid()).toList();
            return result2.isEmpty() ? null : result2.toArray(PsiElement.EMPTY_ARRAY);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            Set<VirtualFile> files2 = selection.filter(PsiElement.class).filter(e -> e != null && e.isValid()).filterMap(e -> PsiUtilCore.getVirtualFile(e)).toSet();
            return !files2.isEmpty() ? VfsUtilCore.toVirtualFileArray(files2) : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List<Navigatable> elements = selection.filter(Navigatable.class).toList();
            return elements.isEmpty() ? null : elements.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return selection.filter(Module.class).isNotEmpty() ? ModuleDeleteProvider.getInstance() : new DeleteHandler.DefaultDeleteProvider();
        }
        return null;
    }

    @NotNull
    private CopyPasteSupport getCopyPasteDelegator(@NotNull JComponent source) {
        String key;
        Object result2;
        if (source == null) {
            NavBarPanel.$$$reportNull$$$0(14);
        }
        if (!((result2 = source.getClientProperty(key = "NavBarPanel.copyPasteDelegator")) instanceof CopyPasteSupport)) {
            result2 = new CopyPasteDelegator(this.myProject, source);
            source.putClientProperty(key, result2);
        }
        CopyPasteSupport copyPasteSupport = (CopyPasteSupport)result2;
        if (copyPasteSupport == null) {
            NavBarPanel.$$$reportNull$$$0(15);
        }
        return copyPasteSupport;
    }

    public Point getBestPopupPosition() {
        NavBarItem item;
        int index = this.myModel.getSelectedIndex();
        int modelSize = this.myModel.size();
        if (index == -1) {
            index = modelSize - 1;
        }
        if (index > -1 && index < modelSize && (item = this.getItem(index)) != null) {
            return new Point(item.getX(), item.getY() + item.getHeight());
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        NavBarListener.subscribeTo(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.isDisposeOnRemove() && ScreenUtil.isStandardAddRemoveNotify(this)) {
            Disposer.dispose(this);
        }
    }

    protected boolean isDisposeOnRemove() {
        return true;
    }

    public void updateState(boolean show2) {
        if (show2) {
            this.myUpdateQueue.queueModelUpdateFromFocus();
            this.myUpdateQueue.queueRebuildUi();
        }
    }

    public void showHint(@Nullable Editor editor2, DataContext dataContext) {
        this.myModel.updateModelAsync(dataContext, () -> {
            if (this.myModel.isEmpty()) {
                return;
            }
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add(this);
            panel2.setOpaque(true);
            if (ExperimentalUI.isNewUI()) {
                panel2.setBorder(new JBEmptyBorder(JBUI.CurrentTheme.StatusBar.Breadcrumbs.floatingBorderInsets()));
                panel2.setBackground(JBUI.CurrentTheme.StatusBar.Breadcrumbs.FLOATING_BACKGROUND);
            } else {
                panel2.setBackground(UIUtil.getListBackground());
            }
            this.myHint = new LightweightHint(panel2){

                public void hide() {
                    super.hide();
                    NavBarPanel.this.cancelPopup();
                    Disposer.dispose(NavBarPanel.this);
                }
            };
            this.myHint.setForceShowAsPopup(true);
            this.myHint.setFocusRequestor((JComponent)this);
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.myUpdateQueue.rebuildUi();
            if (editor2 == null) {
                this.myContextComponent = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext);
                this.getHintContainerShowPoint().doWhenDone(relativePoint -> {
                    Component owner = focusManager.getFocusOwner();
                    Component cmp = relativePoint.getComponent();
                    if (cmp instanceof JComponent && cmp.isShowing()) {
                        this.myHint.show((JComponent)cmp, relativePoint.getPoint().x, relativePoint.getPoint().y, owner instanceof JComponent ? (JComponent)owner : null, new HintHint(relativePoint.getComponent(), relativePoint.getPoint()));
                    }
                });
            } else {
                this.myHintContainer = editor2.getContentComponent();
                this.getHintContainerShowPoint().doWhenDone(rp -> {
                    Point p = rp.getPointOn(this.myHintContainer).getPoint();
                    HintHint hintInfo = new HintHint(editor2, p);
                    HintManagerImpl.getInstanceImpl().showEditorHint(this.myHint, editor2, p, 1, 0, true, hintInfo);
                });
            }
            this.rebuildAndSelectTail(true);
        });
    }

    AsyncResult<RelativePoint> getHintContainerShowPoint() {
        Component c;
        AsyncResult result2 = new AsyncResult();
        if (this.myLocationCache == null) {
            if (this.myHintContainer != null) {
                Point p = AbstractPopup.getCenterOf((Component)this.myHintContainer, (JComponent)this);
                p.y -= this.myHintContainer.getVisibleRect().height / 4;
                this.myLocationCache = RelativePoint.fromScreen(p);
            } else {
                DataManager dataManager = DataManager.getInstance();
                if (this.myContextComponent != null) {
                    DataContext ctx = dataManager.getDataContext(this.myContextComponent);
                    this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation(ctx);
                } else {
                    dataManager.getDataContextFromFocus().doWhenDone(dataContext -> {
                        this.myContextComponent = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext);
                        DataContext ctx = dataManager.getDataContext(this.myContextComponent);
                        this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation(ctx);
                    });
                }
            }
        }
        if (!((c = this.myLocationCache.getComponent()) instanceof JComponent) || !c.isShowing()) {
            JComponent ideFrame = WindowManager.getInstance().getIdeFrame(this.getProject()).getComponent();
            JRootPane rootPane = UIUtil.getRootPane(ideFrame);
            this.myLocationCache = JBPopupFactory.getInstance().guessBestPopupLocation((JComponent)rootPane);
        }
        result2.setDone((Object)this.myLocationCache);
        return result2;
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            NavBarPanel.$$$reportNull$$$0(16);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < this.myList.size(); ++i) {
            NavBarItem each = this.myList.get(i);
            if (each.isSelected()) {
                result2.append("[").append(each.getText()).append("]");
            } else {
                result2.append(each.getText());
            }
            if (i >= this.myList.size() - 1) continue;
            result2.append(">");
        }
        info.put("navBar", result2.toString());
        if (this.isNodePopupActive()) {
            StringBuilder popupText = new StringBuilder();
            JBList<?> list2 = this.myNodePopup.getList();
            for (int i = 0; i < list2.getModel().getSize(); ++i) {
                Object eachElement = list2.getModel().getElementAt(i);
                String text2 = new NavBarItem(this, eachElement, this.myNodePopup, true).getText();
                int selectedIndex = list2.getSelectedIndex();
                if (selectedIndex != -1 && eachElement.equals(list2.getSelectedValue())) {
                    popupText.append("[").append(text2).append("]");
                } else {
                    popupText.append(text2);
                }
                if (i >= list2.getModel().getSize() - 1) continue;
                popupText.append(">");
            }
            info.put("navBarPopup", popupText.toString());
        }
    }

    @NotNull
    public NavBarUI getNavBarUI() {
        NavBarUI navBarUI = NavBarUIManager.getUI();
        if (navBarUI == null) {
            NavBarPanel.$$$reportNull$$$0(17);
        }
        return navBarUI;
    }

    boolean isUpdating() {
        return this.myUpdateQueue.isUpdating();
    }

    void queueFileUpdate(PsiFile psiFile) {
        this.myForcedFileUpdateQueue.add(psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarPanel";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyPasteDelegator";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavBarUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 17: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDataImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSlowDataImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCopyPasteDelegator";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

