/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarBorder;
import com.intellij.ide.navigationToolbar.NavBarLeftSideExtension;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.ReusableNavBarPanel;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.ide.ui.NavBarLocation;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarCentralWidget;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBThinOverlappingScrollBar;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavBarRootPaneExtension
extends IdeRootPaneNorthExtension
implements StatusBarCentralWidget {
    private static final Logger LOG = Logger.getInstance(NavBarRootPaneExtension.class);
    static final String PANEL_KEY = "NavBarPanel";
    private final Project myProject;
    private JComponent myWrapperPanel;
    private NavBarPanel myNavigationBar;
    private JComponent myNavBarPanel;
    private JPanel myRunPanel;
    private Boolean myNavToolbarGroupExist;
    private JScrollPane myScrollPane;

    public NavBarRootPaneExtension(@NotNull Project project2) {
        if (project2 == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myProject.getMessageBus().connect().subscribe(UISettingsListener.TOPIC, uiSettings -> {
            this.toggleRunPanel(NavBarRootPaneExtension.isShowToolPanel(uiSettings));
            this.toggleNavPanel(uiSettings);
        });
    }

    public void revalidate() {
        boolean showToolPanel = NavBarRootPaneExtension.isShowToolPanel(UISettings.getInstance());
        LOG.debug("Revalidate in the navbarRootPane, toolbar visible: " + showToolPanel);
        if (showToolPanel) {
            this.toggleRunPanel(true);
        }
    }

    public IdeRootPaneNorthExtension copy() {
        return new NavBarRootPaneExtension(this.myProject);
    }

    private boolean runToolbarExists() {
        if (this.myNavToolbarGroupExist == null) {
            AnAction correctedAction = CustomActionsSchema.getInstance().getCorrectedAction("NavBarToolBar");
            this.myNavToolbarGroupExist = correctedAction instanceof DefaultActionGroup && ((DefaultActionGroup)correctedAction).getChildrenCount() > 0 || correctedAction instanceof CustomisedActionGroup && ((CustomisedActionGroup)correctedAction).getFirstAction() != null;
        }
        return this.myNavToolbarGroupExist;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myWrapperPanel == null) {
            this.myWrapperPanel = new NavBarWrapperPanel(new BorderLayout()){

                @Override
                public Insets getInsets() {
                    return NavBarUIManager.getUI().getWrapperPanelInsets(super.getInsets());
                }
            };
            UISettings settings = UISettings.getInstance();
            if (!ExperimentalUI.isNewUI() || settings.getShowNavigationBar() && settings.getNavBarLocation() == NavBarLocation.TOP) {
                this.myWrapperPanel.add((Component)this.getNavBarPanel(), "Center");
            } else {
                this.myWrapperPanel.setVisible(false);
            }
            this.getNavBarPanel();
            this.myWrapperPanel.putClientProperty(PANEL_KEY, this.myNavigationBar);
            this.revalidate();
        }
        JComponent jComponent = this.myWrapperPanel;
        if (jComponent == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    private void toggleNavPanel(UISettings settings) {
        boolean show2;
        boolean bl = ExperimentalUI.isNewUI() ? settings.getShowNavigationBar() && settings.getNavBarLocation() == NavBarLocation.TOP : (show2 = settings.getShowNavigationBar() && !settings.getPresentationMode());
        if (show2) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myWrapperPanel.add((Component)this.getNavBarPanel(), "Center");
                this.myNavBarPanel.updateUI();
            });
        } else {
            Component c = ((BorderLayout)this.myWrapperPanel.getLayout()).getLayoutComponent("Center");
            if (c != null) {
                this.myWrapperPanel.remove(c);
            }
        }
        this.updateScrollBarFlippedState(settings.getNavBarLocation());
        this.myWrapperPanel.setVisible(show2);
    }

    private void toggleRunPanel(boolean show2) {
        CompletableFuture.supplyAsync(() -> CustomActionsSchema.getInstance().getCorrectedAction("NavBarToolBar"), AppExecutorUtil.getAppExecutorService()).thenAcceptAsync(action2 -> {
            if (show2 && this.myRunPanel == null && this.runToolbarExists()) {
                if (this.myWrapperPanel != null && this.myRunPanel != null) {
                    this.myWrapperPanel.remove(this.myRunPanel);
                    this.myRunPanel = null;
                }
                ActionManager manager = ActionManager.getInstance();
                if (action2 instanceof ActionGroup && this.myWrapperPanel != null) {
                    ActionToolbar actionToolbar = manager.createActionToolbar("NavBarToolbar", (ActionGroup)action2, true);
                    actionToolbar.setTargetComponent(null);
                    this.myRunPanel = new JPanel(new BorderLayout()){

                        @Override
                        public void doLayout() {
                            NavBarRootPaneExtension.alignVertically(this);
                        }
                    };
                    this.myRunPanel.setOpaque(false);
                    this.myRunPanel.add((Component)actionToolbar.getComponent(), "Center");
                    boolean needGap = NavBarRootPaneExtension.isNeedGap(action2);
                    this.myRunPanel.setBorder(JBUI.Borders.emptyLeft(needGap ? 5 : 1));
                    NavBarLeftSideExtension.EP_NAME.forEachExtensionSafe(extension2 -> extension2.process(this.myWrapperPanel, this.myProject));
                    this.myWrapperPanel.add((Component)this.myRunPanel, "East");
                }
            } else if (!show2 && this.myRunPanel != null) {
                this.myWrapperPanel.remove(this.myRunPanel);
                this.myRunPanel = null;
            }
        }, command2 -> ApplicationManager.getApplication().invokeLater(command2, this.myProject.getDisposed()));
    }

    private JComponent getNavBarPanel() {
        if (this.myNavBarPanel != null) {
            return this.myNavBarPanel;
        }
        this.myNavigationBar = new ReusableNavBarPanel(this.myProject, true);
        this.myNavigationBar.getModel().setFixedComponent(true);
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myNavigationBar);
        this.updateScrollBarFlippedState(null);
        this.myNavBarPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                JScrollPane navBar = NavBarRootPaneExtension.this.myScrollPane;
                Rectangle r = navBar.getBounds();
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.translate(r.x, r.y);
                g2d.dispose();
            }

            @Override
            public void doLayout() {
                int preferredHeight;
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                int x = insets.left;
                if (NavBarRootPaneExtension.this.myScrollPane == null || !NavBarRootPaneExtension.this.myScrollPane.isVisible()) {
                    return;
                }
                JScrollPane navBar = NavBarRootPaneExtension.this.myScrollPane;
                int navBarHeight = preferredHeight = ((Component)navBar).getPreferredSize().height;
                if (ExperimentalUI.isNewNavbar()) {
                    navBarHeight = r.height;
                }
                navBar.setBounds(x, (r.height - navBarHeight) / 2, r.width - insets.left - insets.right, navBarHeight);
            }

            @Override
            public void updateUI() {
                Border border;
                super.updateUI();
                if (NavBarRootPaneExtension.this.myScrollPane == null || NavBarRootPaneExtension.this.myNavigationBar == null) {
                    return;
                }
                UISettings settings = UISettings.getInstance();
                Border border2 = border = !ExperimentalUI.isNewUI() || settings.getShowNavigationBar() ? new NavBarBorder() : JBUI.Borders.empty();
                if (ExperimentalUI.isNewNavbar()) {
                    NavBarRootPaneExtension.this.myScrollPane.setHorizontalScrollBar((JScrollBar)new JBThinOverlappingScrollBar(0));
                    if (NavBarRootPaneExtension.this.myScrollPane instanceof JBScrollPane) {
                        ((JBScrollPane)NavBarRootPaneExtension.this.myScrollPane).setOverlappingScrollBar(true);
                    }
                    NavBarRootPaneExtension.this.myScrollPane.setHorizontalScrollBarPolicy(30);
                } else {
                    NavBarRootPaneExtension.this.myScrollPane.setHorizontalScrollBar(null);
                }
                NavBarRootPaneExtension.this.myScrollPane.setVerticalScrollBarPolicy(21);
                NavBarRootPaneExtension.this.myScrollPane.setBorder(border);
                NavBarRootPaneExtension.this.myScrollPane.setOpaque(false);
                NavBarRootPaneExtension.this.myScrollPane.getViewport().setOpaque(false);
                NavBarRootPaneExtension.this.myScrollPane.setViewportBorder(null);
                if (ExperimentalUI.isNewUI()) {
                    boolean visible = settings.getShowNavigationBar() && !settings.getPresentationMode();
                    NavBarRootPaneExtension.this.myScrollPane.setVisible(visible);
                    NavBarRootPaneExtension.this.myNavigationBar.updateState(visible);
                }
                NavBarRootPaneExtension.this.myNavigationBar.setBorder(null);
            }
        };
        this.myNavBarPanel.add((Component)this.myScrollPane, "Center");
        this.myNavBarPanel.setOpaque(!ExperimentalUI.isNewUI());
        this.myNavBarPanel.updateUI();
        return this.myNavBarPanel;
    }

    public void uiSettingsChanged(@NotNull UISettings settings) {
        boolean visible;
        if (settings == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(2);
        }
        if (this.myNavigationBar == null) {
            return;
        }
        this.myNavigationBar.updateState(settings.getShowNavigationBar());
        boolean bl = visible = settings.getShowNavigationBar() && !settings.getPresentationMode();
        if (ExperimentalUI.isNewUI()) {
            this.myScrollPane.setVisible(visible);
        }
        this.myNavigationBar.revalidate();
        if (this.myWrapperPanel != null) {
            Component c;
            this.myWrapperPanel.setVisible(visible);
            this.myWrapperPanel.revalidate();
            this.myWrapperPanel.repaint();
            if (this.myWrapperPanel.getComponentCount() > 0 && (c = this.myWrapperPanel.getComponent(0)) instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
        }
    }

    private void updateScrollBarFlippedState(@Nullable NavBarLocation location) {
        if (ExperimentalUI.isNewNavbar() && this.myScrollPane != null) {
            if (location == null) {
                location = UISettings.getInstance().getNavBarLocation();
            }
            JBScrollPane.Flip flipState = location == NavBarLocation.BOTTOM ? JBScrollPane.Flip.VERTICAL : JBScrollPane.Flip.NONE;
            this.myScrollPane.putClientProperty(JBScrollPane.Flip.class, flipState);
        }
    }

    @NotNull
    public String getKey() {
        return "NavBar";
    }

    @NotNull
    public JComponent getCentralStatusBarComponent() {
        JComponent jComponent = this.getNavBarPanel();
        if (jComponent == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    public String ID() {
        String string2 = this.getKey();
        if (string2 == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(5);
        }
    }

    public void dispose() {
    }

    private static boolean isShowToolPanel(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(6);
        }
        if (!ExperimentalUI.isNewUI() && uiSettings.getShowNavigationBar() && !uiSettings.getShowMainToolbar() && !uiSettings.getPresentationMode()) {
            ToolbarSettings toolbarSettings = ToolbarSettings.getInstance();
            return !toolbarSettings.isVisible() || !toolbarSettings.isEnabled();
        }
        return false;
    }

    private static void alignVertically(Container container) {
        if (container.getComponentCount() == 1) {
            Component c = container.getComponent(0);
            Insets insets = container.getInsets();
            Dimension d = c.getPreferredSize();
            Rectangle r = container.getBounds();
            c.setBounds(insets.left, (r.height - d.height - insets.top - insets.bottom) / 2 + insets.top, r.width - insets.left - insets.right, d.height);
        }
    }

    private static boolean isNeedGap(AnAction group) {
        AnAction firstAction = NavBarRootPaneExtension.getFirstAction(group);
        return firstAction instanceof ComboBoxAction;
    }

    @Nullable
    private static AnAction getFirstAction(AnAction group) {
        if (group instanceof DefaultActionGroup) {
            AnAction firstAction = null;
            for (AnAction action2 : ((DefaultActionGroup)group).getChildActionsOrStubs()) {
                if (!(action2 instanceof DefaultActionGroup)) {
                    if (action2 instanceof Separator || action2 instanceof ActionGroup) continue;
                    firstAction = action2;
                    break;
                }
                firstAction = NavBarRootPaneExtension.getFirstAction(action2);
                if (firstAction != null) break;
            }
            return firstAction;
        }
        if (group instanceof CustomisedActionGroup) {
            return ((CustomisedActionGroup)group).getFirstAction();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarRootPaneExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarRootPaneExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCentralStatusBarComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isShowToolPanel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NavBarWrapperPanel
    extends JPanel {
        public NavBarWrapperPanel(LayoutManager layout) {
            super(layout);
            this.setName("navbar");
        }

        @Override
        protected Graphics getComponentGraphics(Graphics graphics) {
            return JBSwingUtilities.runGlobalCGTransform(this, super.getComponentGraphics(graphics));
        }
    }
}

