/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarPopup;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNavBarUI
implements NavBarUI {
    private static final Map<NavBarItem, Map<ImageType, ScaleContext.Cache<BufferedImage>>> cache = new HashMap<NavBarItem, Map<ImageType, ScaleContext.Cache<BufferedImage>>>();

    @Override
    public Insets getElementIpad(boolean isPopupElement) {
        return isPopupElement ? JBInsets.create(1, 2) : (ExperimentalUI.isNewUI() ? JBUI.insets("StatusBar.Breadcrumbs.itemBackgroundInsets", JBUI.insets(1)) : JBInsets.emptyInsets());
    }

    @Override
    @Deprecated
    public JBInsets getElementPadding() {
        return this.getElementPadding(null);
    }

    @Override
    public JBInsets getElementPadding(NavBarItem item) {
        return ExperimentalUI.isNewUI() ? (item != null && item.isInFloatingMode() ? JBUI.insets("StatusBar.Breadcrumbs.floatingItemInsets", JBUI.insets(1)) : JBUI.insets("StatusBar.Breadcrumbs.itemInsets", JBUI.insets(2, 0))) : JBUI.insets(3);
    }

    @Override
    public Font getElementFont(NavBarItem navBarItem) {
        Font font = StartupUiUtil.getLabelFont();
        return !ExperimentalUI.isNewUI() && UISettings.getInstance().getUseSmallLabelsOnTabs() ? RelativeFont.SMALL.derive(font) : font;
    }

    @Override
    public Color getBackground(boolean selected, boolean focused) {
        return selected && focused ? UIUtil.getListSelectionBackground(true) : UIUtil.getListBackground();
    }

    @Override
    @Nullable
    public Color getForeground(boolean selected, boolean focused, boolean inactive) {
        return selected && focused ? UIUtil.getListSelectionForeground(true) : (inactive ? UIUtil.getInactiveTextColor() : null);
    }

    @Override
    public short getSelectionAlpha() {
        return 150;
    }

    @Override
    public void doPaintNavBarItem(Graphics2D g, NavBarItem item, NavBarPanel navbar) {
        JBInsets paddings = this.getElementPadding(item);
        if (ExperimentalUI.isNewUI()) {
            Icon icon2;
            Rectangle rect2 = new Rectangle(item.getSize());
            JBInsets.removeFrom(rect2, (Insets)paddings);
            int offset = rect2.x;
            if (!item.isFirstElement()) {
                NavBarItem.CHEVRON_ICON.paintIcon((Component)((Object)item), g, offset, rect2.y + (rect2.height - NavBarItem.CHEVRON_ICON.getIconHeight()) / 2);
                int delta = NavBarItem.CHEVRON_ICON.getIconWidth() + JBUI.CurrentTheme.StatusBar.Breadcrumbs.CHEVRON_INSET.get();
                offset += delta;
                rect2.width -= delta;
            }
            AbstractNavBarUI.paintHighlight(g, navbar, item, new Rectangle(offset, rect2.y, rect2.width, rect2.height));
            boolean paintIcon = false;
            if (item.needPaintIcon() && (icon2 = item.getIcon()) != null) {
                paintIcon = true;
                icon2.paintIcon((Component)((Object)item), g, offset += item.getIpad().left, rect2.y + (rect2.height - icon2.getIconHeight()) / 2 + item.getVerticalIconOffset());
                offset += icon2.getIconWidth();
            }
            item.doPaintText(g, offset += paintIcon ? item.getIconTextGap() : item.getIpad().left);
        } else {
            Icon icon3;
            boolean nextSelected;
            boolean floating = navbar.isInFloatingMode();
            boolean toolbarVisible = UISettings.getInstance().getShowMainToolbar();
            boolean selected = item.isSelected() && item.isFocused();
            boolean bl = nextSelected = item.isNextSelected() && navbar.isFocused();
            ImageType type = floating ? (selected ? ImageType.ACTIVE_FLOATING : (nextSelected ? ImageType.NEXT_ACTIVE_FLOATING : ImageType.INACTIVE_FLOATING)) : (toolbarVisible ? (selected ? ImageType.ACTIVE : (nextSelected ? ImageType.NEXT_ACTIVE : ImageType.INACTIVE)) : (selected ? ImageType.ACTIVE_NO_TOOLBAR : (nextSelected ? ImageType.NEXT_ACTIVE_NO_TOOLBAR : ImageType.INACTIVE_NO_TOOLBAR)));
            Map cache2 = cache.computeIfAbsent(item, k -> new HashMap());
            ScaleContext.Cache imageCache = cache2.computeIfAbsent(type, k -> new ScaleContext.Cache<BufferedImage>(ctx -> AbstractNavBarUI.drawToBuffer(item, ctx, floating, toolbarVisible, selected, navbar)));
            BufferedImage image = (BufferedImage)imageCache.getOrProvide(ScaleContext.create(g));
            if (image == null) {
                return;
            }
            StartupUiUtil.drawImage((Graphics)g, (Image)image, 0, 0, null);
            int offset = item.isFirstElement() ? AbstractNavBarUI.getFirstElementLeftOffset() : 0;
            int textOffset = paddings.width() + offset;
            if (item.needPaintIcon() && (icon3 = item.getIcon()) != null) {
                int iconOffset = paddings.left + offset;
                icon3.paintIcon((Component)((Object)item), g, iconOffset, (item.getHeight() - icon3.getIconHeight()) / 2);
                textOffset += icon3.getIconWidth();
            }
            item.doPaintText(g, textOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintHighlight(Graphics2D g, NavBarPanel panel2, NavBarItem item, Rectangle rectangle) {
        Color color;
        NavBarModel model2 = panel2.getModel();
        NavBarPopup popup2 = panel2.getNodePopup();
        if (item.isMouseHover()) {
            color = JBUI.CurrentTheme.StatusBar.Breadcrumbs.HOVER_BACKGROUND;
        } else if (model2.getSelectedIndex() == item.getIndex() && item.isFocused()) {
            color = JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_BACKGROUND;
        } else if (model2.getSelectedIndex() == item.getIndex() && popup2 != null && popup2.isVisible() && popup2.getItemIndex() == item.getIndex()) {
            color = JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_INACTIVE_BACKGROUND;
        } else {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.setColor(color);
            float arc = JBUIScale.scale(4);
            RoundRectangle2D.Float shape = new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, arc, arc);
            g2.fill(shape);
        }
        finally {
            g2.dispose();
        }
    }

    private static BufferedImage drawToBuffer(NavBarItem item, ScaleContext ctx, boolean floating, boolean toolbarVisible, boolean selected, NavBarPanel navbar) {
        int w = item.getWidth();
        int h = item.getHeight();
        int offset = w - AbstractNavBarUI.getDecorationOffset();
        int h2 = h / 2;
        BufferedImage result2 = ImageUtil.createImage(ctx, (double)w, (double)h, 2, PaintUtil.RoundingMode.FLOOR);
        Color defaultBg = StartupUiUtil.isUnderDarcula() ? Gray._100 : JBColor.WHITE;
        Color bg = floating ? defaultBg : null;
        Color selection = UIUtil.getListSelectionBackground(true);
        Graphics2D g2 = result2.createGraphics();
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Path2D.Double shape = new Path2D.Double();
        shape.moveTo(0.0, 0.0);
        shape.lineTo(offset, 0.0);
        shape.lineTo(w, h2);
        shape.lineTo(offset, h);
        shape.lineTo(0.0, h);
        shape.closePath();
        Path2D.Double endShape = new Path2D.Double();
        endShape.moveTo(offset, 0.0);
        endShape.lineTo(w, 0.0);
        endShape.lineTo(w, h);
        endShape.lineTo(offset, h);
        endShape.lineTo(w, h2);
        endShape.closePath();
        if (bg != null && toolbarVisible) {
            g2.setPaint(bg);
            g2.fill(shape);
            g2.fill(endShape);
        }
        if (selected) {
            Path2D.Double focusShape = new Path2D.Double();
            if (toolbarVisible || floating) {
                focusShape.moveTo(offset, 0.0);
            } else {
                focusShape.moveTo(0.0, 0.0);
                focusShape.lineTo(offset, 0.0);
            }
            focusShape.lineTo(w - 1, h2);
            focusShape.lineTo(offset, h - 1);
            if (!toolbarVisible && !floating) {
                focusShape.lineTo(0.0, h - 1);
            }
            g2.setColor(selection);
            if (floating && item.isLastElement()) {
                g2.fillRect(0, 0, w, h);
            } else {
                g2.fill(shape);
            }
        }
        if (item.isNextSelected() && navbar.isFocused()) {
            g2.setColor(selection);
            g2.fill(endShape);
        }
        if (!(item.isLastElement() || selected || navbar.isFocused() && item.isNextSelected())) {
            Icon icon2 = AllIcons.Ide.NavBarSeparator;
            icon2.paintIcon((Component)((Object)item), g2, w - icon2.getIconWidth() - JBUIScale.scale(1), h2 - icon2.getIconHeight() / 2);
        }
        g2.dispose();
        return result2;
    }

    private static int getDecorationOffset() {
        return JBUIScale.scale(8);
    }

    private static int getFirstElementLeftOffset() {
        return JBUIScale.scale(6);
    }

    @Override
    public Dimension getOffsets(NavBarItem item) {
        Dimension size = new Dimension();
        if (!item.isPopupElement()) {
            JBInsets.addTo(size, (Insets)this.getElementPadding(item));
            if (!ExperimentalUI.isNewUI()) {
                size.width = size.width + (AbstractNavBarUI.getDecorationOffset() + (item.isFirstElement() ? AbstractNavBarUI.getFirstElementLeftOffset() : 0));
            }
        }
        return size;
    }

    @Override
    public Insets getWrapperPanelInsets(Insets insets) {
        JBInsets result2 = JBInsets.create(insets);
        if (AbstractNavBarUI.shouldPaintWrapperPanel()) {
            result2.top += JBUIScale.scale(1);
        }
        return result2;
    }

    private static boolean shouldPaintWrapperPanel() {
        return false;
    }

    protected Color getBackgroundColor() {
        return ColorUtil.darker(UIUtil.getPanelBackground(), 1);
    }

    @Override
    public void clearItems() {
        if (!ExperimentalUI.isNewUI()) {
            cache.clear();
        }
    }

    @Override
    public int getPopupOffset(@NotNull NavBarItem item) {
        if (item == null) {
            AbstractNavBarUI.$$$reportNull$$$0(0);
        }
        return item.isFirstElement() ? 0 : JBUIScale.scale(5);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/navigationToolbar/ui/AbstractNavBarUI", "getPopupOffset"));
    }

    private static enum ImageType {
        INACTIVE,
        NEXT_ACTIVE,
        ACTIVE,
        INACTIVE_FLOATING,
        NEXT_ACTIVE_FLOATING,
        ACTIVE_FLOATING,
        INACTIVE_NO_TOOLBAR,
        NEXT_ACTIVE_NO_TOOLBAR,
        ACTIVE_NO_TOOLBAR;

    }
}

