/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.ClassPathXmlPathResolver;
import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ImmutableZipFileDataLoader;
import com.intellij.ide.plugins.JavaZipFileDataLoader;
import com.intellij.ide.plugins.LoadDescriptorsFromClassPathAction;
import com.intellij.ide.plugins.LocalFsDataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.RawPluginDescriptor;
import com.intellij.ide.plugins.ReadModuleContext;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.lang.ZipFilePool;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RecursiveTask;
import java.util.function.BiConsumer;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/plugins/LoadDescriptorsFromClassPathAction;", "Ljava/util/concurrent/RecursiveAction;", "urlToFilename", "", "Ljava/net/URL;", "", "context", "Lcom/intellij/ide/plugins/DescriptorListLoadingContext;", "pathResolver", "Lcom/intellij/ide/plugins/ClassPathXmlPathResolver;", "useCoreClassLoader", "", "(Ljava/util/Map;Lcom/intellij/ide/plugins/DescriptorListLoadingContext;Lcom/intellij/ide/plugins/ClassPathXmlPathResolver;Z)V", "compute", "", "loadDescriptorFromResource", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "resource", "filename", "intellij.platform.core.impl"})
final class LoadDescriptorsFromClassPathAction
extends RecursiveAction {
    private final Map<URL, String> urlToFilename;
    private final DescriptorListLoadingContext context;
    private final ClassPathXmlPathResolver pathResolver;
    private final boolean useCoreClassLoader;

    @Override
    public void compute() {
        ArrayList tasks = new ArrayList(this.urlToFilename.size());
        this.urlToFilename.forEach(new BiConsumer(this, tasks){
            final /* synthetic */ LoadDescriptorsFromClassPathAction this$0;
            final /* synthetic */ ArrayList $tasks;

            public final void accept(@NotNull URL url, @NotNull String filename) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                this.$tasks.add(new RecursiveTask<IdeaPluginDescriptorImpl>(this, url, filename){
                    final /* synthetic */ compute.1 this$0;
                    final /* synthetic */ URL $url;
                    final /* synthetic */ String $filename;

                    @Nullable
                    protected IdeaPluginDescriptorImpl compute() {
                        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
                        try {
                            LoadDescriptorsFromClassPathAction loadDescriptorsFromClassPathAction = this.this$0.this$0;
                            URL uRL = this.$url;
                            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"url");
                            String string2 = this.$filename;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"filename");
                            ideaPluginDescriptorImpl = LoadDescriptorsFromClassPathAction.access$loadDescriptorFromResource(loadDescriptorsFromClassPathAction, uRL, string2);
                        }
                        catch (Throwable e) {
                            PluginDescriptorLoader.access$getLOG$p().info("Cannot load " + this.$url, e);
                            ideaPluginDescriptorImpl = null;
                        }
                        return ideaPluginDescriptorImpl;
                    }
                    {
                        this.this$0 = this$0;
                        this.$url = $captured_local_variable$1;
                        this.$filename = $captured_local_variable$2;
                    }
                });
            }
            {
                this.this$0 = loadDescriptorsFromClassPathAction;
                this.$tasks = arrayList;
            }
        });
        PluginLoadingResult result2 = this.context.result;
        ForkJoinTask.invokeAll(tasks);
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            ForkJoinTask task2;
            ForkJoinTask forkJoinTask = task2 = (ForkJoinTask)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)forkJoinTask, (String)"task");
            if ((IdeaPluginDescriptorImpl)forkJoinTask.getRawResult() == null) continue;
            IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl;
            boolean bl = false;
            result2.add(it, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IdeaPluginDescriptorImpl loadDescriptorFromResource(URL resource, String filename) {
        Path file2 = Paths.get(UrlClassLoader.urlToFilePath(resource.getPath()), new String[0]);
        Closeable closeable = null;
        DataLoader dataLoader2 = null;
        Path basePath = null;
        try {
            InputStream input;
            block12: {
                block13: {
                    InputStream inputStream;
                    ZipFile zipFile;
                    ZipFilePool pool;
                    Path path2;
                    block15: {
                        block14: {
                            Path path3;
                            block11: {
                                input = null;
                                if (!Intrinsics.areEqual((Object)"file", (Object)resource.getProtocol())) break block11;
                                Path path4 = file2;
                                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"file");
                                Path path5 = path4.getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"file.parent");
                                Path path6 = path5.getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"file.parent.parent");
                                basePath = path6;
                                dataLoader2 = new LocalFsDataLoader(basePath);
                                InputStream inputStream2 = Files.newInputStream(file2, new OpenOption[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"Files.newInputStream(file)");
                                input = inputStream2;
                                break block12;
                            }
                            if (!Intrinsics.areEqual((Object)"jar", (Object)resource.getProtocol())) break block13;
                            Path path7 = file2;
                            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"file");
                            path2 = path7.getParent();
                            if (path2 == null) break block14;
                            Path it = path3 = path2;
                            boolean bl = false;
                            path2 = !it.endsWith("lib") ? path3 : null;
                            if (path2 != null && (path2 = path2.getParent()) != null) break block15;
                        }
                        path2 = file2;
                    }
                    basePath = path2;
                    ZipFilePool zipFilePool = pool = this.context.transient ? null : ZipFilePool.POOL;
                    if (pool == null) {
                        zipFile = new ZipFile(file2.toFile(), StandardCharsets.UTF_8);
                        closeable = zipFile;
                        dataLoader2 = new JavaZipFileDataLoader(zipFile);
                    } else {
                        ZipFilePool.EntryResolver entryResolver = pool.load(file2);
                        Intrinsics.checkNotNullExpressionValue((Object)entryResolver, (String)"pool.load(file)");
                        dataLoader2 = new ImmutableZipFileDataLoader(entryResolver, file2, pool);
                    }
                    if (dataLoader2.load("META-INF/" + filename) == null) {
                        zipFile = null;
                        return zipFile;
                    }
                    input = inputStream;
                    break block12;
                }
                IdeaPluginDescriptorImpl pool = null;
                return pool;
            }
            RawPluginDescriptor raw = XmlReader.readModuleDescriptor(input, (ReadModuleContext)this.context, (PathResolver)this.pathResolver, dataLoader2, null, null, ((Object)file2).toString());
            IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(raw, basePath, true, null, null, this.useCoreClassLoader);
            descriptor.readExternal(raw, this.pathResolver, this.context, false, dataLoader2);
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor;
            return ideaPluginDescriptorImpl;
        }
        finally {
            block16: {
                Closeable closeable2 = closeable;
                if (closeable2 == null) break block16;
                closeable2.close();
            }
        }
    }

    public LoadDescriptorsFromClassPathAction(@NotNull Map<URL, String> urlToFilename, @NotNull DescriptorListLoadingContext context2, @NotNull ClassPathXmlPathResolver pathResolver, boolean useCoreClassLoader) {
        Intrinsics.checkNotNullParameter(urlToFilename, (String)"urlToFilename");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        this.urlToFilename = urlToFilename;
        this.context = context2;
        this.pathResolver = pathResolver;
        this.useCoreClassLoader = useCoreClassLoader;
    }

    public static final /* synthetic */ IdeaPluginDescriptorImpl access$loadDescriptorFromResource(LoadDescriptorsFromClassPathAction $this, URL resource, String filename) {
        return $this.loadDescriptorFromResource(resource, filename);
    }
}

