/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.cl;

import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.ui.EDT;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class PluginClassLoader
extends UrlClassLoader
implements PluginAwareClassLoader {
    private static final ClassLoader[] EMPTY_CLASS_LOADER_ARRAY = new ClassLoader[0];
    @Nullable
    private static final Writer logStream;
    private static final AtomicInteger instanceIdProducer;
    private static final AtomicInteger parentListCacheIdCounter;
    private static final Set<String> KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES;
    private final IdeaPluginDescriptorImpl[] parents;
    private volatile ClassLoader[] allParents;
    private volatile int allParentsLastCacheId;
    private final PluginDescriptor pluginDescriptor;
    private final PluginId pluginId;
    private final String packagePrefix;
    private final List<String> libDirectories;
    private final AtomicLong edtTime;
    private final AtomicLong backgroundTime;
    private final AtomicInteger loadedClassCounter;
    @NotNull
    private final ClassLoader coreLoader;
    private final int instanceId;
    private volatile int state;
    private final ResolveScopeManager resolveScopeManager;

    public PluginClassLoader(@NotNull List<Path> files2, @NotNull ClassPath classPath, @NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] dependencies, @NotNull PluginDescriptor pluginDescriptor, @NotNull ClassLoader coreLoader, @Nullable ResolveScopeManager resolveScopeManager, @Nullable String packagePrefix, @NotNull List<String> libDirectories) {
        if (files2 == null) {
            PluginClassLoader.$$$reportNull$$$0(0);
        }
        if (classPath == null) {
            PluginClassLoader.$$$reportNull$$$0(1);
        }
        if (dependencies == null) {
            PluginClassLoader.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            PluginClassLoader.$$$reportNull$$$0(3);
        }
        if (coreLoader == null) {
            PluginClassLoader.$$$reportNull$$$0(4);
        }
        if (libDirectories == null) {
            PluginClassLoader.$$$reportNull$$$0(5);
        }
        super(files2, classPath);
        this.edtTime = new AtomicLong();
        this.backgroundTime = new AtomicLong();
        this.loadedClassCounter = new AtomicInteger();
        this.state = 1;
        this.instanceId = instanceIdProducer.incrementAndGet();
        this.resolveScopeManager = resolveScopeManager == null ? (p1, p2, p3) -> null : resolveScopeManager;
        this.parents = dependencies;
        this.pluginDescriptor = pluginDescriptor;
        this.pluginId = pluginDescriptor.getPluginId();
        this.packagePrefix = packagePrefix == null || packagePrefix.endsWith(".") ? packagePrefix : packagePrefix + '.';
        this.coreLoader = coreLoader;
        this.libDirectories = libDirectories;
    }

    @NotNull
    public List<String> getLibDirectories() {
        List<String> list2 = this.libDirectories;
        if (list2 == null) {
            PluginClassLoader.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @Nullable
    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    @Override
    @ApiStatus.Internal
    public int getState() {
        return this.state;
    }

    @ApiStatus.Internal
    public void setState(int state) {
        this.state = state;
    }

    @Override
    public int getInstanceId() {
        return this.instanceId;
    }

    @Override
    public long getEdtTime() {
        return this.edtTime.get();
    }

    @Override
    public long getBackgroundTime() {
        return this.backgroundTime.get();
    }

    @Override
    public long getLoadedClassCount() {
        return this.loadedClassCounter.get();
    }

    @Override
    public Class<?> loadClass(@NotNull String name2, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(7);
        }
        if ((c = this.tryLoadingClass(name2, false)) == null) {
            PluginClassLoader.flushDebugLog();
            throw new ClassNotFoundException(name2 + " " + this);
        }
        return c;
    }

    @Override
    @Nullable
    public Class<?> tryLoadingClass(@NotNull String name2, boolean forceLoadFromSubPluginClassloader) throws ClassNotFoundException {
        Class<?> c;
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(8);
        }
        if (PluginClassLoader.mustBeLoadedByPlatform(name2)) {
            return this.coreLoader.loadClass(name2);
        }
        String fileNameWithoutExtension = name2.replace('.', '/');
        String fileName = fileNameWithoutExtension + ".class";
        long packageNameHash = ClasspathCache.getPackageNameHash(fileNameWithoutExtension, fileNameWithoutExtension.lastIndexOf(47));
        long startTime = StartUpMeasurer.measuringPluginStartupCosts ? StartUpMeasurer.getCurrentTime() : -1L;
        PluginException error = null;
        try {
            String consistencyError = this.resolveScopeManager.isDefinitelyAlienClass(name2, this.packagePrefix, forceLoadFromSubPluginClassloader);
            if (consistencyError == null) {
                c = this.loadClassInsideSelf(name2, fileName, packageNameHash, forceLoadFromSubPluginClassloader);
            } else {
                if (!consistencyError.isEmpty()) {
                    error = new PluginException(consistencyError, this.pluginId);
                }
                c = null;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name2, e);
        }
        if (c == null) {
            for (ClassLoader classloader : this.getAllParents()) {
                if (classloader instanceof PluginClassLoader) {
                    try {
                        PluginClassLoader pluginClassLoader = (PluginClassLoader)classloader;
                        String consistencyError = pluginClassLoader.resolveScopeManager.isDefinitelyAlienClass(name2, pluginClassLoader.packagePrefix, forceLoadFromSubPluginClassloader);
                        if (consistencyError != null) {
                            if (consistencyError.isEmpty() || error != null) continue;
                            error = new PluginException(consistencyError, this.pluginId);
                            continue;
                        }
                        c = pluginClassLoader.loadClassInsideSelf(name2, fileName, packageNameHash, false);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name2, e);
                    }
                    if (c == null) continue;
                    break;
                }
                if (classloader instanceof UrlClassLoader) {
                    try {
                        String consistencyError;
                        UrlClassLoader urlClassLoader = (UrlClassLoader)classloader;
                        BiFunction<String, Boolean, String> resolveScopeManager = urlClassLoader.resolveScopeManager;
                        String string2 = consistencyError = resolveScopeManager == null ? null : resolveScopeManager.apply(name2, forceLoadFromSubPluginClassloader);
                        if (consistencyError != null) {
                            if (consistencyError.isEmpty() || error != null) continue;
                            error = new PluginException(consistencyError, this.pluginId);
                            continue;
                        }
                        c = urlClassLoader.loadClassInsideSelf(name2, fileName, packageNameHash, false);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name2, e);
                    }
                    if (c == null) continue;
                    break;
                }
                try {
                    c = classloader.loadClass(name2);
                    if (c == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (error != null) {
                throw error;
            }
        }
        if (startTime != -1L) {
            (EDT.isCurrentThreadEdt() ? this.edtTime : this.backgroundTime).addAndGet(StartUpMeasurer.getCurrentTime() - startTime);
        }
        return c;
    }

    @NotNull
    private @NotNull ClassLoader @NotNull [] getAllParents() {
        ClassLoader classLoader;
        ClassLoader[] result2 = this.allParents;
        if (result2 != null && this.allParentsLastCacheId == parentListCacheIdCounter.get()) {
            if (result2 == null) {
                PluginClassLoader.$$$reportNull$$$0(9);
            }
            return result2;
        }
        if (this.parents.length == 0) {
            result2 = new ClassLoader[]{this.coreLoader};
            this.allParents = result2;
            if (result2 == null) {
                PluginClassLoader.$$$reportNull$$$0(10);
            }
            return result2;
        }
        LinkedHashSet<ClassLoader> parentSet = new LinkedHashSet<ClassLoader>();
        ArrayDeque queue2 = new ArrayDeque();
        this.collectClassLoaders(queue2);
        while ((classLoader = (ClassLoader)queue2.pollFirst()) != null) {
            if (!parentSet.add(classLoader) || !(classLoader instanceof PluginClassLoader)) continue;
            ((PluginClassLoader)classLoader).collectClassLoaders(queue2);
        }
        parentSet.add(this.coreLoader);
        result2 = parentSet.toArray(EMPTY_CLASS_LOADER_ARRAY);
        this.allParents = result2;
        this.allParentsLastCacheId = parentListCacheIdCounter.get();
        if (result2 == null) {
            PluginClassLoader.$$$reportNull$$$0(11);
        }
        return result2;
    }

    private void collectClassLoaders(@NotNull Deque<? super ClassLoader> queue2) {
        if (queue2 == null) {
            PluginClassLoader.$$$reportNull$$$0(12);
        }
        for (IdeaPluginDescriptorImpl parent : this.parents) {
            ClassLoader classLoader = parent.getPluginClassLoader();
            if (classLoader == null || classLoader == this.coreLoader) continue;
            queue2.add(classLoader);
        }
    }

    public void clearParentListCache() {
        this.allParents = null;
    }

    private static boolean mustBeLoadedByPlatform(@NonNls String className) {
        if (className.startsWith("java.")) {
            return true;
        }
        return className.startsWith("kotlin.") && (className.startsWith("kotlin.jvm.functions.") || className.startsWith("kotlin.reflect.") && className.indexOf(46, 15) < 0 || KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES.contains(className));
    }

    @Override
    public boolean hasLoadedClass(String name2) {
        String consistencyError = this.resolveScopeManager.isDefinitelyAlienClass(name2, this.packagePrefix, false);
        return consistencyError == null && super.hasLoadedClass(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Class<?> loadClassInsideSelf(String name2, String fileName, long packageNameHash, boolean forceLoadFromSubPluginClassloader) throws IOException {
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name2);
            if (c != null && c.getClassLoader() == this) {
                return c;
            }
            Writer logStream = PluginClassLoader.logStream;
            try {
                c = this.classPath.findClass(name2, fileName, packageNameHash, this.classDataConsumer);
            }
            catch (LinkageError e) {
                if (logStream != null) {
                    this.logClass(name2, logStream, e);
                }
                PluginClassLoader.flushDebugLog();
                throw new PluginException("Cannot load class " + name2 + " (\n  error: " + e.getMessage() + ",\n  classLoader=" + this + "\n)", e, this.pluginId);
            }
            if (c == null) {
                return null;
            }
            this.loadedClassCounter.incrementAndGet();
            if (logStream != null) {
                this.logClass(name2, logStream, null);
            }
            return c;
        }
    }

    private void logClass(@NotNull String name2, @NotNull Writer logStream, @Nullable LinkageError exception) {
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(13);
        }
        if (logStream == null) {
            PluginClassLoader.$$$reportNull$$$0(14);
        }
        try {
            String descriptorPath = ((IdeaPluginDescriptor)this.pluginDescriptor).getDescriptorPath();
            String specifier = descriptorPath == null ? "m" : "sub = " + descriptorPath;
            logStream.write(name2 + " [" + specifier + "] " + this.pluginId.getIdString() + (this.packagePrefix == null ? "" : ':' + this.packagePrefix) + '\n' + (exception == null ? "" : exception.getMessage()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @Nullable
    public URL findResource(@NotNull String name2) {
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(15);
        }
        return this.doFindResource(name2, Resource::getURL, ClassLoader::getResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @Nullable [] getResourceAsBytes(@NotNull String name2, boolean checkParents) throws IOException {
        byte[] result2;
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(16);
        }
        if ((result2 = super.getResourceAsBytes(name2, checkParents)) != null) {
            return result2;
        }
        if (!checkParents) {
            return null;
        }
        for (ClassLoader classloader : this.getAllParents()) {
            if (classloader instanceof UrlClassLoader) {
                Resource resource = ((UrlClassLoader)classloader).getClassPath().findResource(name2);
                if (resource == null) continue;
                return resource.getBytes();
            }
            InputStream input = classloader.getResourceAsStream(name2);
            if (input == null) continue;
            try {
                int read;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data2 = new byte[16384];
                while ((read = input.read(data2, 0, data2.length)) != -1) {
                    buffer.write(data2, 0, read);
                }
                byte[] byArray = buffer.toByteArray();
                return byArray;
            }
            finally {
                input.close();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(@NotNull String name2) {
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(17);
        }
        Function<Resource, InputStream> f1 = resource -> {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                Logger.getInstance(PluginClassLoader.class).error(e);
                return null;
            }
        };
        BiFunction<ClassLoader, String, InputStream> f2 = (cl, path2) -> {
            try {
                return cl.getResourceAsStream((String)path2);
            }
            catch (Exception e) {
                Logger.getInstance(PluginClassLoader.class).error(e);
                return null;
            }
        };
        return this.doFindResource(name2, f1, f2);
    }

    @Nullable
    private <T> T doFindResource(String name2, Function<? super Resource, ? extends T> f1, BiFunction<? super ClassLoader, ? super String, ? extends T> f2) {
        String canonicalPath = PluginClassLoader.toCanonicalPath(name2);
        Resource resource = this.classPath.findResource(canonicalPath);
        if (resource != null) {
            return f1.apply(resource);
        }
        for (ClassLoader classloader : this.getAllParents()) {
            if (classloader instanceof PluginClassLoader) {
                resource = ((PluginClassLoader)classloader).classPath.findResource(canonicalPath);
                if (resource == null) continue;
                return f1.apply(resource);
            }
            T t = f2.apply(classloader, canonicalPath);
            if (t == null) continue;
            return t;
        }
        if (canonicalPath.startsWith("/") && this.classPath.findResource(canonicalPath.substring(1)) != null) {
            String message2 = "Calling `ClassLoader#getResource` with leading slash doesn't work; strip";
            Logger.getInstance(PluginClassLoader.class).error(message2, new PluginException(name2, this.pluginId));
        }
        return null;
    }

    @Override
    @NotNull
    public Enumeration<URL> findResources(@NotNull String name2) throws IOException {
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(18);
        }
        ArrayList<Enumeration<URL>> resources = new ArrayList<Enumeration<URL>>();
        resources.add(this.classPath.getResources(name2));
        for (ClassLoader classloader : this.getAllParents()) {
            if (classloader instanceof PluginClassLoader) {
                resources.add(((PluginClassLoader)classloader).classPath.getResources(name2));
                continue;
            }
            try {
                resources.add(classloader.getResources(name2));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new DeepEnumeration(resources);
    }

    public void addLibDirectories(@NotNull Collection<String> libDirectories) {
        if (libDirectories == null) {
            PluginClassLoader.$$$reportNull$$$0(19);
        }
        this.libDirectories.addAll(libDirectories);
    }

    @Override
    protected String findLibrary(String libName) {
        if (!this.libDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i = this.libDirectories.listIterator(this.libDirectories.size());
            while (i.hasPrevious()) {
                File libFile = new File(i.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public PluginId getPluginId() {
        PluginId pluginId = this.pluginId;
        if (pluginId == null) {
            PluginClassLoader.$$$reportNull$$$0(20);
        }
        return pluginId;
    }

    @Override
    @NotNull
    public PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.pluginDescriptor;
        if (pluginDescriptor == null) {
            PluginClassLoader.$$$reportNull$$$0(21);
        }
        return pluginDescriptor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(plugin=" + this.pluginDescriptor + ", packagePrefix=" + this.packagePrefix + ", instanceId=" + this.instanceId + ", state=" + (this.state == 1 ? "active" : "unload in progress") + ")";
    }

    @TestOnly
    @NotNull
    public List<IdeaPluginDescriptorImpl> _getParents() {
        List<IdeaPluginDescriptorImpl> list2 = Collections.unmodifiableList(Arrays.asList(this.parents));
        if (list2 == null) {
            PluginClassLoader.$$$reportNull$$$0(22);
        }
        return list2;
    }

    private static void flushDebugLog() {
        if (logStream != null) {
            try {
                logStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        boolean parallelCapable = PluginClassLoader.registerAsParallelCapable();
        assert (parallelCapable);
        instanceIdProducer = new AtomicInteger();
        parentListCacheIdCounter = new AtomicInteger();
        HashSet<String> kotlinStdlibClassesUsedInSignatures = new HashSet<String>(Arrays.asList("kotlin.Function", "kotlin.sequences.Sequence", "kotlin.ranges.IntRange", "kotlin.ranges.IntRange$Companion", "kotlin.ranges.IntProgression", "kotlin.ranges.ClosedRange", "kotlin.ranges.IntProgressionIterator", "kotlin.ranges.IntProgression$Companion", "kotlin.ranges.IntProgression", "kotlin.collections.IntIterator", "kotlin.Lazy", "kotlin.Unit", "kotlin.Pair", "kotlin.Triple", "kotlin.jvm.internal.DefaultConstructorMarker", "kotlin.jvm.internal.ClassBasedDeclarationContainer", "kotlin.properties.ReadWriteProperty", "kotlin.properties.ReadOnlyProperty", "kotlin.coroutines.ContinuationInterceptor", "kotlinx.coroutines.CoroutineDispatcher", "kotlin.coroutines.Continuation", "kotlin.coroutines.CoroutineContext", "kotlin.coroutines.CoroutineContext$Element", "kotlin.coroutines.CoroutineContext$Key", "kotlin.Result", "kotlin.Result$Failure", "kotlin.coroutines.intrinsics.CoroutineSingletons", "kotlin.coroutines.AbstractCoroutineContextElement", "kotlin.coroutines.AbstractCoroutineContextKey", "kotlin.coroutines.jvm.internal.ContinuationImpl", "kotlin.coroutines.jvm.internal.BaseContinuationImpl", "kotlin.coroutines.jvm.internal.CoroutineStackFrame"));
        String classes = System.getProperty("idea.kotlin.classes.used.in.signatures");
        if (classes != null) {
            StringTokenizer t = new StringTokenizer(classes, ",");
            while (t.hasMoreTokens()) {
                kotlinStdlibClassesUsedInSignatures.add(t.nextToken());
            }
        }
        KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES = kotlinStdlibClassesUsedInSignatures;
        BufferedWriter logStreamCandidate = null;
        String debugFilePath = System.getProperty("plugin.classloader.debug", "");
        if (!debugFilePath.isEmpty()) {
            try {
                if (debugFilePath.startsWith("~/") || debugFilePath.startsWith("~\\")) {
                    debugFilePath = System.getProperty("user.home") + debugFilePath.substring(1);
                }
                logStreamCandidate = Files.newBufferedWriter(Paths.get(debugFilePath, new String[0]), new OpenOption[0]);
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (logStream != null) {
                                logStream.close();
                            }
                        }
                        catch (IOException e) {
                            Logger.getInstance(PluginClassLoader.class).error(e);
                        }
                    }
                });
            }
            catch (IOException e) {
                Logger.getInstance(PluginClassLoader.class).error(e);
            }
        }
        logStream = logStreamCandidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirectories";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/cl/PluginClassLoader";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/cl/PluginClassLoader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibDirectories";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllParents";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "_getParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadingClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectClassLoaders";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logClass";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsBytes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findResources";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addLibDirectories";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DeepEnumeration
    implements Enumeration<URL> {
        @NotNull
        private final List<? extends Enumeration<URL>> list;
        private int myIndex;

        private DeepEnumeration(@NotNull List<? extends Enumeration<URL>> enumerations) {
            if (enumerations == null) {
                DeepEnumeration.$$$reportNull$$$0(0);
            }
            this.list = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.list.size()) {
                Enumeration<URL> e = this.list.get(this.myIndex);
                if (e != null && e.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.myIndex).nextElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumerations", "com/intellij/ide/plugins/cl/PluginClassLoader$DeepEnumeration", "<init>"));
        }
    }

    public static interface ResolveScopeManager {
        public String isDefinitelyAlienClass(String var1, String var2, boolean var3);
    }
}

