/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.NlsActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveModulesToGroupAction
extends AnAction {
    protected final ModuleGroup myModuleGroup;

    public MoveModulesToGroupAction(ModuleGroup moduleGroup, @NlsActions.ActionText String title) {
        super(title);
        this.myModuleGroup = moduleGroup;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveModulesToGroupAction.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Module[] modules2 = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        e.getPresentation().setEnabledAndVisible(modules2 != null);
        if (modules2 != null) {
            String description = IdeBundle.message((String)"message.move.modules.to.group", (Object[])new Object[]{MoveModulesToGroupAction.whatToMove(modules2), this.myModuleGroup.presentableText()});
            presentation2.setDescription(description);
        }
    }

    protected static String whatToMove(Module @NotNull [] modules2) {
        if (modules2 == null) {
            MoveModulesToGroupAction.$$$reportNull$$$0(1);
        }
        return modules2.length == 1 ? IdeBundle.message((String)"message.module", (Object[])new Object[]{modules2[0].getName()}) : IdeBundle.message((String)"message.modules", (Object[])new Object[0]);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveModulesToGroupAction.$$$reportNull$$$0(2);
        }
        Module[] modules2 = (Module[])e.getRequiredData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        MoveModulesToGroupAction.doMove(modules2, this.myModuleGroup, e.getDataContext());
    }

    public static void doMove(Module @NotNull [] modules2, ModuleGroup group, @Nullable DataContext dataContext) {
        AbstractProjectViewPane pane;
        if (modules2 == null) {
            MoveModulesToGroupAction.$$$reportNull$$$0(3);
        }
        Project project2 = modules2[0].getProject();
        ModifiableModuleModel modifiableModuleModel = dataContext != null ? (ModifiableModuleModel)LangDataKeys.MODIFIABLE_MODULE_MODEL.getData(dataContext) : null;
        ModifiableModuleModel model2 = modifiableModuleModel != null ? modifiableModuleModel : ModuleManager.getInstance(project2).getModifiableModel();
        for (Module module : modules2) {
            model2.setModuleGroupPath(module, group == null ? null : group.getGroupPath());
        }
        if (modifiableModuleModel == null) {
            WriteAction.run(model2::commit);
        }
        if ((pane = ProjectView.getInstance(project2).getCurrentProjectViewPane()) != null) {
            pane.updateFromRoot(true);
        }
        if (!ProjectSettingsService.getInstance(project2).processModulesMoved(modules2, group) && pane != null) {
            if (group != null) {
                pane.selectModuleGroup(group, true);
            } else {
                pane.selectModule(modules2[0], true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/actions/MoveModulesToGroupAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "whatToMove";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

