/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class DetachLibraryDeleteProvider
implements DeleteProvider {
    private final Project myProject;
    private final LibraryOrderEntry myOrderEntry;

    DetachLibraryDeleteProvider(@NotNull Project project2, @NotNull LibraryOrderEntry orderEntry) {
        if (project2 == null) {
            DetachLibraryDeleteProvider.$$$reportNull$$$0(0);
        }
        if (orderEntry == null) {
            DetachLibraryDeleteProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myOrderEntry = orderEntry;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DetachLibraryDeleteProvider.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DetachLibraryDeleteProvider.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        String title;
        if (dataContext == null) {
            DetachLibraryDeleteProvider.$$$reportNull$$$0(4);
        }
        Module module = this.myOrderEntry.getOwnerModule();
        String message2 = IdeBundle.message((String)"detach.library.from.module", (Object[])new Object[]{this.myOrderEntry.getPresentableName(), module.getName()});
        int ret = Messages.showOkCancelDialog((Project)this.myProject, (String)message2, (String)(title = IdeBundle.message((String)"detach.library", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon());
        if (ret != 0) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(module.getProject(), () -> {
            Runnable action2 = () -> {
                ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
                OrderEntry[] orderEntries = rootManager.getOrderEntries();
                ModifiableRootModel model2 = rootManager.getModifiableModel();
                OrderEntry[] modifiableEntries = model2.getOrderEntries();
                for (int i = 0; i < orderEntries.length; ++i) {
                    OrderEntry entry = orderEntries[i];
                    if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() != this.myOrderEntry.getLibrary()) continue;
                    model2.removeOrderEntry(modifiableEntries[i]);
                }
                model2.commit();
            };
            ApplicationManager.getApplication().runWriteAction(action2);
        }, title, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/DetachLibraryDeleteProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/DetachLibraryDeleteProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

