/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class ModuleGroupUrl
extends AbstractUrl {
    @NonNls
    private static final String ELEMENT_TYPE = "module_group";

    public ModuleGroupUrl(String url) {
        super(url, null, ELEMENT_TYPE);
    }

    @Override
    public Object[] createPath(Project project2) {
        List<String> groupPath = StringUtil.split(this.url, ";");
        return new Object[]{new ModuleGroup(groupPath)};
    }

    @Override
    protected AbstractUrl createUrl(String moduleName, String url) {
        return new ModuleGroupUrl(url);
    }

    @Override
    public AbstractUrl createUrlByElement(Object element2) {
        if (element2 instanceof ModuleGroup) {
            ModuleGroup group = (ModuleGroup)element2;
            String[] groupPath = group.getGroupPath();
            return new ModuleGroupUrl(StringUtil.join(groupPath, ";"));
        }
        return null;
    }
}

