/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0000\u001a!\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0002\u001a+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0016\u001a+\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006H\u0000\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"getNodeElement", "", "userObject", "getSelectedLibrary", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "userObjectsPath", "", "([Ljava/lang/Object;)Lcom/intellij/openapi/roots/LibraryOrderEntry;", "getUnloadedModuleByContentRoot", "Lcom/intellij/openapi/module/UnloadedModuleDescription;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleBySingleContentRoot", "Lcom/intellij/openapi/module/Module;", "moduleContext", "element", "moduleContexts", "", "", "elements", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/Object;)Ljava/util/List;", "unloadedModules", "intellij.platform.lang.impl"})
public final class ProjectViewUtilKt {
    @Nullable
    public static final Object getNodeElement(@Nullable Object userObject) {
        Object object = userObject;
        return object instanceof AbstractTreeNode ? ((AbstractTreeNode)userObject).getValue() : (object instanceof NodeDescriptor ? ((NodeDescriptor)userObject).getElement() : null);
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<Module> moduleContexts(@NotNull Project project2, @NotNull Object[] elements) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        ArrayList result2 = new ArrayList();
        for (Object selectedValue : elements) {
            Collection collection = result2;
            Collection<Module> collection2 = ProjectViewUtilKt.moduleContexts(project2, selectedValue);
            if (collection2 == null) {
                continue;
            }
            Iterable iterable = collection2;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
        return result2;
    }

    private static final Collection<Module> moduleContexts(Project project2, Object element2) {
        List list2;
        if (element2 instanceof ModuleGroup) {
            return ((ModuleGroup)element2).modulesInGroup(project2, true);
        }
        Module module = ProjectViewUtilKt.moduleContext(project2, element2);
        if (module != null) {
            Module module2;
            Module p1 = module2 = module;
            boolean bl = false;
            list2 = CollectionsKt.listOf((Object)p1);
        } else {
            list2 = null;
        }
        return list2;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Module moduleContext(@NotNull Project project2, @Nullable Object element2) {
        Module module;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = element2;
        if (object instanceof Module) {
            module = ((Module)element2).isDisposed() ? null : (Module)element2;
        } else if (object instanceof PsiDirectory) {
            VirtualFile virtualFile2 = ((PsiDirectory)element2).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"element.virtualFile");
            module = ProjectViewUtilKt.moduleBySingleContentRoot(project2, virtualFile2);
        } else {
            module = object instanceof VirtualFile ? ProjectViewUtilKt.moduleBySingleContentRoot(project2, (VirtualFile)element2) : null;
        }
        return module;
    }

    private static final Module moduleBySingleContentRoot(Project project2, VirtualFile file2) {
        Module module;
        block5: {
            block4: {
                if (!ProjectRootsUtil.isModuleContentRoot(file2, project2)) {
                    return null;
                }
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance(project2);
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                module = projectRootManager.getFileIndex().getModuleForFile(file2);
                if (module == null || module.isDisposed()) break block4;
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
                Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                if (moduleRootManager.getContentRoots().length == 1) break block5;
            }
            return null;
        }
        return module;
    }

    @NotNull
    public static final List<UnloadedModuleDescription> unloadedModules(@NotNull Project project2, @NotNull Object[] elements) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        SmartList result2 = new SmartList();
        for (Object element2 : elements) {
            UnloadedModuleDescription unloadedModuleDescription;
            VirtualFile virtualFile2;
            Object object = element2;
            if (object instanceof PsiDirectory) {
                virtualFile2 = ((PsiDirectory)element2).getVirtualFile();
            } else {
                if (!(object instanceof VirtualFile)) continue;
                virtualFile2 = (VirtualFile)element2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"when (element) {\n      i\u2026   else -> continue\n    }");
            VirtualFile file2 = virtualFile2;
            object = result2;
            if (ProjectViewUtilKt.getUnloadedModuleByContentRoot(project2, file2) == null) {
                continue;
            }
            object.add(unloadedModuleDescription);
        }
        return result2;
    }

    private static final UnloadedModuleDescription getUnloadedModuleByContentRoot(Project project2, VirtualFile file2) {
        String string2 = ProjectRootsUtil.findUnloadedModuleByContentRoot(file2, project2);
        if (string2 == null) {
            return null;
        }
        String moduleName = string2;
        return ModuleManager.getInstance(project2).getUnloadedModuleDescription(moduleName);
    }

    @Nullable
    public static final LibraryOrderEntry getSelectedLibrary(@Nullable Object[] userObjectsPath) {
        AbstractTreeNode grandParentObject;
        if (userObjectsPath == null) {
            return null;
        }
        Object parentObject = ArraysKt.getOrNull((Object[])userObjectsPath, (int)(userObjectsPath.length - 2));
        if (!(parentObject instanceof LibraryGroupNode)) {
            return null;
        }
        Object userObject = ArraysKt.last((Object[])userObjectsPath);
        if (userObject instanceof NamedLibraryElementNode) {
            NamedLibraryElement namedLibraryElement = (NamedLibraryElement)((NamedLibraryElementNode)((Object)userObject)).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)namedLibraryElement, (String)"userObject.value");
            LibraryOrSdkOrderEntry libraryOrSdkOrderEntry = namedLibraryElement.getOrderEntry();
            if (!(libraryOrSdkOrderEntry instanceof LibraryOrderEntry)) {
                libraryOrSdkOrderEntry = null;
            }
            return (LibraryOrderEntry)libraryOrSdkOrderEntry;
        }
        Object object = userObject;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode");
        }
        PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)object).getValue();
        Object object2 = ArraysKt.getOrNull((Object[])userObjectsPath, (int)(userObjectsPath.length - 3));
        if (!(object2 instanceof AbstractTreeNode)) {
            object2 = null;
        }
        AbstractTreeNode abstractTreeNode = grandParentObject = (AbstractTreeNode)object2;
        Intrinsics.checkNotNull((Object)abstractTreeNode);
        Module module = (Module)abstractTreeNode.getValue();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        ModuleFileIndex moduleFileIndex = moduleRootManager.getFileIndex();
        PsiDirectory psiDirectory = directory;
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"directory");
        OrderEntry orderEntry = moduleFileIndex.getOrderEntryForFile(psiDirectory.getVirtualFile());
        if (!(orderEntry instanceof LibraryOrderEntry)) {
            orderEntry = null;
        }
        return (LibraryOrderEntry)orderEntry;
    }
}

