/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NamedLibraryElementNode
extends ProjectViewNode<NamedLibraryElement>
implements NavigatableWithText {
    public NamedLibraryElementNode(Project project2, @NotNull NamedLibraryElement value, ViewSettings viewSettings) {
        if (value == null) {
            NamedLibraryElementNode.$$$reportNull$$$0(0);
        }
        super(project2, value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        ArrayList children2 = new ArrayList();
        NamedLibraryElement libraryElement = (NamedLibraryElement)this.getValue();
        if (libraryElement != null) {
            LibraryGroupNode.addLibraryChildren(libraryElement.getOrderEntry(), children2, this.getProject(), this);
        }
        ArrayList arrayList = children2;
        if (arrayList == null) {
            NamedLibraryElementNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static Icon getJdkIcon(JdkOrderEntry entry) {
        Sdk sdk2 = entry.getJdk();
        if (sdk2 == null) {
            return AllIcons.Nodes.UnknownJdk;
        }
        SdkType sdkType = (SdkType)sdk2.getSdkType();
        return sdkType.getIcon();
    }

    public String getName() {
        NamedLibraryElement library2 = (NamedLibraryElement)this.getValue();
        return library2 != null ? library2.getName() : "";
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        NamedLibraryElement library2;
        if (file2 == null) {
            NamedLibraryElementNode.$$$reportNull$$$0(2);
        }
        if ((library2 = (NamedLibraryElement)this.getValue()) == null) {
            return false;
        }
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            LibraryOrSdkOrderEntry orderEntry = library2.getOrderEntry();
            if (!orderEntry.isValid()) continue;
            for (VirtualFile virtualFile2 : orderEntry.getRootFiles(rootType)) {
                if (!VfsUtilCore.isAncestor(virtualFile2, file2, false)) continue;
                return true;
            }
        }
        return false;
    }

    public void update(@NotNull PresentationData presentation2) {
        NamedLibraryElement library2;
        if (presentation2 == null) {
            NamedLibraryElementNode.$$$reportNull$$$0(3);
        }
        if ((library2 = (NamedLibraryElement)this.getValue()) == null) {
            return;
        }
        LibraryOrSdkOrderEntry orderEntry = library2.getOrderEntry();
        presentation2.setPresentableText(library2.getName());
        Icon icon2 = AllIcons.Nodes.PpLibFolder;
        String tooltip = null;
        String location = null;
        if (orderEntry instanceof JdkOrderEntry) {
            String path2;
            JdkOrderEntry jdkOrderEntry = (JdkOrderEntry)orderEntry;
            icon2 = NamedLibraryElementNode.getJdkIcon(jdkOrderEntry);
            Sdk projectJdk = jdkOrderEntry.getJdk();
            if (projectJdk != null && (path2 = projectJdk.getHomePath()) != null) {
                String string2 = path2 = projectJdk.getSdkType().isLocalSdk(projectJdk) ? FileUtil.toSystemDependentName(path2) : FileUtil.toSystemIndependentName(path2);
                if (this.getSettings().isShowURL()) {
                    location = path2;
                } else {
                    tooltip = path2;
                }
            }
        } else if (orderEntry instanceof LibraryOrderEntry) {
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
            tooltip = StringUtil.capitalize(IdeBundle.message((String)"node.projectview.library", (Object[])new Object[]{libraryOrderEntry.getLibraryLevel()}));
        }
        presentation2.setIcon(icon2);
        presentation2.setTooltip(tooltip);
        presentation2.setLocationString(location);
    }

    public void navigate(boolean requestFocus) {
        NamedLibraryElement library2 = (NamedLibraryElement)this.getValue();
        if (library2 != null) {
            ProjectSettingsService.getInstance(this.myProject).openLibraryOrSdkSettings(library2.getOrderEntry());
        }
    }

    public boolean canNavigate() {
        NamedLibraryElement library2 = (NamedLibraryElement)this.getValue();
        return library2 != null && ProjectSettingsService.getInstance(this.myProject).canOpenLibraryOrSdkSettings(library2.getOrderEntry());
    }

    public String getNavigateActionText(boolean focusEditor) {
        return ActionsBundle.message((String)"action.LibrarySettings.navigate", (Object[])new Object[0]);
    }

    public String getTestPresentation() {
        NamedLibraryElement library2 = (NamedLibraryElement)this.getValue();
        return "Library: " + (library2 != null ? library2.getName() : "(null)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/NamedLibraryElementNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/NamedLibraryElementNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

