/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class NamedScopeFilter
implements VirtualFileFilter {
    private static final Logger LOG = Logger.getInstance(NamedScopeFilter.class);
    private final NamedScopesHolder holder;
    private final NamedScope scope;
    private final String string;

    public NamedScopeFilter(@NotNull NamedScopesHolder holder, @NotNull NamedScope scope) {
        if (holder == null) {
            NamedScopeFilter.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            NamedScopeFilter.$$$reportNull$$$0(1);
        }
        this.holder = holder;
        this.scope = scope;
        this.string = scope + "; " + scope.getClass();
    }

    @NotNull
    public NamedScopesHolder getHolder() {
        NamedScopesHolder namedScopesHolder = this.holder;
        if (namedScopesHolder == null) {
            NamedScopeFilter.$$$reportNull$$$0(2);
        }
        return namedScopesHolder;
    }

    @NotNull
    public NamedScope getScope() {
        NamedScope namedScope = this.scope;
        if (namedScope == null) {
            NamedScopeFilter.$$$reportNull$$$0(3);
        }
        return namedScope;
    }

    @NotNull
    public String toString() {
        String string2 = this.string;
        if (string2 == null) {
            NamedScopeFilter.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    public boolean accept(@NotNull VirtualFile file2) {
        PackageSet set2;
        if (file2 == null) {
            NamedScopeFilter.$$$reportNull$$$0(5);
        }
        if ((set2 = this.scope.getValue()) == null) {
            return false;
        }
        Project project2 = this.holder.getProject();
        if (set2 instanceof PackageSetBase) {
            PackageSetBase base = (PackageSetBase)set2;
            return base.contains(file2, project2, this.holder);
        }
        PsiFile psiFile = PackageSetBase.getPsiFile(file2, project2);
        return psiFile != null && set2.contains(psiFile, this.holder);
    }

    static boolean isVisible(@NotNull NamedScope scope) {
        if (scope == null) {
            NamedScopeFilter.$$$reportNull$$$0(6);
        }
        return !(scope instanceof NonProjectFilesScope) && scope != CustomScopesProviderEx.getAllScope();
    }

    @NotNull
    static List<NamedScopeFilter> list(NamedScopesHolder ... holders) {
        ArrayList<NamedScopeFilter> list2 = new ArrayList<NamedScopeFilter>();
        NamedScope scratchesScope = null;
        for (NamedScopesHolder holder : holders) {
            for (NamedScope scope : holder.getScopes()) {
                String name2 = scope.getScopeId();
                if (null == scope.getValue()) {
                    LOG.debug("ignore scope without package set: ", name2, "; holder: ", holder);
                    continue;
                }
                if (scope instanceof ScratchesNamedScope) {
                    scratchesScope = scope;
                    continue;
                }
                if (!NamedScopeFilter.isVisible(scope)) {
                    LOG.debug("ignore hidden scope: ", name2, "; holder: ", holder);
                    continue;
                }
                list2.add(new NamedScopeFilter(holder, scope));
            }
            if (scratchesScope == null) continue;
            list2.add(new NamedScopeFilter(holder, scratchesScope));
            scratchesScope = null;
        }
        ArrayList<NamedScopeFilter> arrayList = list2;
        if (arrayList == null) {
            NamedScopeFilter.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scopeView/NamedScopeFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scopeView/NamedScopeFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

