/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.CompoundProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.CompoundTreeStructureProvider;
import com.intellij.ide.projectView.impl.IdeViewForProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.scopeView.NamedScopeFilter;
import com.intellij.ide.scopeView.ScopePaneSelectInTarget;
import com.intellij.ide.scopeView.ScopeViewTreeModel;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.stripe.ErrorStripePainter;
import com.intellij.ui.stripe.TreeUpdater;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeViewPane
extends AbstractProjectViewPane {
    @NonNls
    public static final String ID = "Scope";
    private static final Logger LOG = Logger.getInstance(ScopeViewPane.class);
    private final IdeView myIdeView;
    private final NamedScopesHolder myDependencyValidationManager;
    private final NamedScopesHolder myNamedScopeManager;
    private ScopeViewTreeModel myTreeModel;
    private LinkedHashMap<String, NamedScopeFilter> myFilters;
    private JScrollPane myScrollPane;

    private static Project checkApplicability(@NotNull Project project2) {
        if (project2 == null) {
            ScopeViewPane.$$$reportNull$$$0(0);
        }
        if (PlatformUtils.isPyCharmEducational() || PlatformUtils.isRider()) {
            throw ExtensionNotApplicableException.create();
        }
        return project2;
    }

    public ScopeViewPane(@NotNull Project project2) {
        if (project2 == null) {
            ScopeViewPane.$$$reportNull$$$0(1);
        }
        super(ScopeViewPane.checkApplicability(project2));
        this.myIdeView = new IdeViewForProjectViewPane(() -> this);
        this.myDependencyValidationManager = DependencyValidationManager.getInstance(project2);
        this.myNamedScopeManager = NamedScopeManager.getInstance(project2);
        this.myFilters = ScopeViewPane.map(this.myDependencyValidationManager, this.myNamedScopeManager);
        NamedScopesHolder.ScopeListener scopeListener = new NamedScopesHolder.ScopeListener(){
            private final AtomicLong counter = new AtomicLong();

            @Override
            public void scopesChanged() {
                if (ScopeViewPane.this.myProject.isDisposed()) {
                    return;
                }
                long count2 = this.counter.incrementAndGet();
                EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
                    ProjectView view;
                    if (count2 != this.counter.get()) {
                        return;
                    }
                    ProjectView projectView = view = ScopeViewPane.this.myProject.isDisposed() ? null : ProjectView.getInstance(ScopeViewPane.this.myProject);
                    if (view == null) {
                        return;
                    }
                    ScopeViewPane.this.myFilters = ScopeViewPane.map(ScopeViewPane.this.myDependencyValidationManager, ScopeViewPane.this.myNamedScopeManager);
                    String currentId = view.getCurrentViewId();
                    String currentSubId = ScopeViewPane.this.getSubId();
                    view.removeProjectPane(ScopeViewPane.this);
                    view.addProjectPane(ScopeViewPane.this);
                    if (currentId == null) {
                        return;
                    }
                    if (currentId.equals(ScopeViewPane.this.getId())) {
                        view.changeView(currentId, currentSubId);
                    } else {
                        view.changeView(currentId);
                    }
                }, 10L, TimeUnit.MILLISECONDS);
            }
        };
        this.myDependencyValidationManager.addScopeListener(scopeListener, this);
        this.myNamedScopeManager.addScopeListener(scopeListener, this);
    }

    @Override
    public void dispose() {
        DnDAwareTree tree = this.myTree;
        if (tree != null) {
            tree.setModel(null);
        }
        super.dispose();
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    public int getWeight() {
        return 4;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string2 = IdeBundle.message((String)"scope.view.title", (Object[])new Object[0]);
        if (string2 == null) {
            ScopeViewPane.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon2 = AllIcons.Ide.LocalScope;
        if (icon2 == null) {
            ScopeViewPane.$$$reportNull$$$0(3);
        }
        return icon2;
    }

    @Override
    public boolean isFileNestingEnabled() {
        return true;
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        if (this.myTreeModel == null) {
            this.myTreeModel = new ScopeViewTreeModel(this.myProject, new ProjectViewSettings.Delegate(this.myProject, ID));
            this.myTreeModel.setStructureProvider(CompoundTreeStructureProvider.get(this.myProject));
            this.myTreeModel.setNodeDecorator(CompoundProjectViewNodeDecorator.get(this.myProject));
            this.myTreeModel.setFilter(this.getFilter(this.getSubId()));
            this.myTreeModel.setComparator(this.createComparator());
        }
        if (this.myTree == null) {
            this.myTree = new ProjectViewTree((TreeModel)new AsyncTreeModel((TreeModel)((Object)this.myTreeModel), (Disposable)this));
            this.myTree.setName("ScopeViewTree");
            this.myTree.setRootVisible(false);
            this.myTree.setShowsRootHandles(true);
            this.myTree.addTreeSelectionListener((TreeSelectionListener)new RestoreSelectionListener());
            TreeUtil.installActions((JTree)this.myTree);
            ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
            EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
            EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
            CustomizationUtil.installPopupHandler((JComponent)this.myTree, (String)"ScopeViewPopupMenu", (String)"ScopeViewPopup");
            new TreeSpeedSearch((JTree)this.myTree);
            this.enableDnD();
            this.myTree.getEmptyText().setText(IdeBundle.message((String)"scope.view.empty.text", (Object[])new Object[0])).appendSecondaryText(IdeBundle.message((String)"scope.view.empty.link", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, event -> {
                ProjectView view;
                ProjectView projectView = view = this.myProject.isDisposed() ? null : ProjectView.getInstance(this.myProject);
                if (view != null) {
                    view.changeView("ProjectPane");
                }
            });
        }
        if (this.myScrollPane == null) {
            this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree, (boolean)true);
            ErrorStripePainter painter = new ErrorStripePainter(true);
            Disposer.register(this, (Disposable)new TreeUpdater<ErrorStripePainter>(painter, this.myScrollPane, (JTree)this.myTree){

                protected void update(ErrorStripePainter painter, int index, Object object) {
                    super.update(painter, index, (Object)ScopeViewPane.this.myTreeModel.getStripe(object, ScopeViewPane.this.myTree.isExpanded(index)));
                }
            });
        } else {
            SwingUtilities.updateComponentTreeUI(this.myScrollPane);
        }
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            ScopeViewPane.$$$reportNull$$$0(4);
        }
        return jScrollPane;
    }

    @Override
    @NotNull
    public ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        if (this.myTreeModel == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ScopeViewPane.$$$reportNull$$$0(5);
            }
            return actionCallback;
        }
        this.saveExpandedPaths();
        this.myTreeModel.invalidate(null);
        this.restoreExpandedPaths();
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ScopeViewPane.$$$reportNull$$$0(6);
        }
        return actionCallback;
    }

    @Override
    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new ScopePaneSelectInTarget(this.myProject);
    }

    @Override
    public void select(Object object, VirtualFile file2, boolean requestFocus) {
        NamedScopeFilter current;
        if (this.myTreeModel == null) {
            return;
        }
        PsiElement element2 = object instanceof PsiElement ? (PsiElement)object : null;
        if (this.select(element2, file2, requestFocus, current = this.myTreeModel.getFilter())) {
            return;
        }
        for (NamedScopeFilter filter2 : this.getFilters()) {
            if (current == filter2 || !this.select(element2, file2, requestFocus, filter2)) continue;
            return;
        }
    }

    private void selectScopeView(String subId) {
        ProjectView view;
        ProjectView projectView = view = this.myProject.isDisposed() ? null : ProjectView.getInstance(this.myProject);
        if (view != null) {
            view.changeView(this.getId(), subId);
        }
    }

    private boolean select(PsiElement element2, VirtualFile file2, boolean requestFocus, VirtualFileFilter filter2) {
        if (filter2 == null || !filter2.accept(file2)) {
            return false;
        }
        String subId = filter2.toString();
        if (!Objects.equals(subId, this.getSubId())) {
            if (!requestFocus) {
                return true;
            }
            this.selectScopeView(subId);
        }
        LOG.debug("select element: ", element2, " in file: ", file2);
        TreeVisitor visitor = AbstractProjectViewPane.createVisitor(element2, file2);
        if (visitor == null) {
            return true;
        }
        DnDAwareTree tree = this.myTree;
        this.myTreeModel.getUpdater().updateImmediately(() -> ScopeViewPane.lambda$select$5((JTree)tree, visitor, element2, file2));
        return true;
    }

    private static boolean selectPath(@NotNull JTree tree, TreePath path2) {
        if (tree == null) {
            ScopeViewPane.$$$reportNull$$$0(7);
        }
        if (path2 == null) {
            return false;
        }
        tree.expandPath(path2);
        TreeUtil.selectPath((JTree)tree, (TreePath)path2);
        return true;
    }

    @Override
    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            ScopeViewPane.$$$reportNull$$$0(8);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ScopeViewPane.$$$reportNull$$$0(9);
        }
        return actionCallback;
    }

    @Override
    protected void onSubIdChange() {
        this.updateSelectedScope();
    }

    @Override
    public String @NotNull [] getSubIds() {
        LinkedHashMap<String, NamedScopeFilter> map2 = this.myFilters;
        if (map2 == null || map2.isEmpty()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                ScopeViewPane.$$$reportNull$$$0(10);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = ArrayUtilRt.toStringArray(map2.keySet());
        if (stringArray == null) {
            ScopeViewPane.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        NamedScopeFilter filter2;
        if (subId == null) {
            ScopeViewPane.$$$reportNull$$$0(12);
        }
        String string2 = (filter2 = this.getFilter(subId)) == null ? this.getTitle() : filter2.getScope().getPresentableName();
        if (string2 == null) {
            ScopeViewPane.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @Override
    @NotNull
    public Icon getPresentableSubIdIcon(@NotNull String subId) {
        NamedScopeFilter filter2;
        if (subId == null) {
            ScopeViewPane.$$$reportNull$$$0(14);
        }
        Icon icon2 = (filter2 = this.getFilter(subId)) != null ? filter2.getScope().getIcon() : this.getIcon();
        if (icon2 == null) {
            ScopeViewPane.$$$reportNull$$$0(15);
        }
        return icon2;
    }

    @Override
    protected void installComparator(AbstractTreeBuilder builder2, @NotNull Comparator<? super NodeDescriptor<?>> comparator2) {
        if (comparator2 == null) {
            ScopeViewPane.$$$reportNull$$$0(16);
        }
    }

    @Override
    @Nullable
    public Object getValueFromNode(@Nullable Object node2) {
        if (this.myTreeModel == null) {
            return null;
        }
        return this.myTreeModel.getContent(node2);
    }

    @Override
    public Object getData(@NotNull String dataId) {
        Object data2;
        if (dataId == null) {
            ScopeViewPane.$$$reportNull$$$0(17);
        }
        if ((data2 = super.getData(dataId)) != null) {
            return data2;
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        return null;
    }

    public void updateSelectedScope() {
        if (this.myTreeModel == null) {
            return;
        }
        this.myTreeModel.setFilter(this.getFilter(this.getSubId()));
    }

    @Nullable
    public NamedScope getSelectedScope() {
        NamedScopeFilter filter2 = this.getFilter(this.getSubId());
        return filter2 == null ? null : filter2.getScope();
    }

    @NotNull
    Iterable<NamedScopeFilter> getFilters() {
        Collection<NamedScopeFilter> collection = this.myFilters.values();
        if (collection == null) {
            ScopeViewPane.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @Nullable
    NamedScopeFilter getFilter(@Nullable String subId) {
        LinkedHashMap<String, NamedScopeFilter> map2 = this.myFilters;
        return map2 == null || subId == null ? null : map2.get(subId);
    }

    @NotNull
    private static LinkedHashMap<String, NamedScopeFilter> map(NamedScopesHolder ... holders) {
        LinkedHashMap<String, NamedScopeFilter> map2 = new LinkedHashMap<String, NamedScopeFilter>();
        for (NamedScopeFilter filter2 : NamedScopeFilter.list(holders)) {
            NamedScopeFilter old = map2.put(filter2.toString(), filter2);
            if (old == null) continue;
            LOG.warn("DUPLICATED: " + filter2);
        }
        LinkedHashMap<String, NamedScopeFilter> linkedHashMap = map2;
        if (linkedHashMap == null) {
            ScopeViewPane.$$$reportNull$$$0(19);
        }
        return linkedHashMap;
    }

    @Override
    public boolean supportsAbbreviatePackageNames() {
        return false;
    }

    @Override
    public boolean supportsCompactDirectories() {
        return true;
    }

    @Override
    public boolean supportsFlattenModules() {
        return PlatformUtils.isIntelliJ() && ModuleGrouperKt.isQualifiedModuleNamesEnabled(this.myProject) && ProjectView.getInstance(this.myProject).isShowModules(ID);
    }

    @Override
    public boolean supportsHideEmptyMiddlePackages() {
        return ProjectView.getInstance(this.myProject).isFlattenPackages(ID);
    }

    @Override
    public boolean supportsShowExcludedFiles() {
        return true;
    }

    @Override
    public boolean supportsShowModules() {
        return PlatformUtils.isIntelliJ();
    }

    private static /* synthetic */ void lambda$select$5(JTree tree, TreeVisitor visitor, PsiElement element2, VirtualFile file2) {
        TreeState.expand((JTree)tree, promise -> TreeUtil.visit((JTree)tree, (TreeVisitor)visitor, path3 -> {
            if (ScopeViewPane.selectPath(tree, path3) || element2 == null || Registry.is("async.project.view.support.extra.select.disabled")) {
                promise.setResult(null);
            } else {
                TreeUtil.visit((JTree)tree, (TreeVisitor)AbstractProjectViewPane.createVisitor(file2), path2 -> {
                    ScopeViewPane.selectPath(tree, path2);
                    promise.setResult(null);
                });
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewPane";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "updateFromRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubIds";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSubIdName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSubIdIcon";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkApplicability";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdIcon";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "installComparator";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

