/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LRUPopupBuilder<T> {
    private static final int MAX_VISIBLE_SIZE = 20;
    private static final int LRU_ITEMS = 4;
    private final @NlsContexts.PopupTitle String myTitle;
    private final PropertiesComponent myPropertiesComponent;
    private final Map<T, Pair<@Nls String, Icon>> myPresentations;
    private T mySelection;
    private Consumer<? super T> myOnChosen;
    private Comparator<? super T> myComparator;
    private Iterable<? extends T> myValues;
    private JBIterable<T> myTopValues;
    private JBIterable<T> myMiddleValues;
    private JBIterable<T> myBottomValues;
    private Function<? super T, String> myExtraSpeedSearchNamer;

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project2, @NotNull @NlsContexts.PopupTitle String title, @Nullable Language selection, @NotNull Consumer<? super Language> onChosen2) {
        if (project2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(0);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(1);
        }
        if (onChosen2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(2);
        }
        ListPopup listPopup = LRUPopupBuilder.languagePopupBuilder(project2, title, null).forValues(LanguageUtil.getFileLanguages()).withSelection(selection).onChosen(onChosen2).buildPopup();
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    @NotNull
    public static LRUPopupBuilder<Language> languagePopupBuilder(@NotNull Project project2, @NotNull @NlsContexts.PopupTitle String title, final @Nullable Function<? super Language, ? extends Icon> iconProvider) {
        if (project2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(4);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(5);
        }
        LRUPopupBuilder<Language> lRUPopupBuilder = new LRUPopupBuilder<Language>(project2, title){

            @Override
            public String getDisplayName(Language language) {
                return language.getDisplayName();
            }

            @Override
            public Icon getIcon(Language language) {
                if (iconProvider != null) {
                    return (Icon)iconProvider.apply(language);
                }
                LanguageFileType fileType = language.getAssociatedFileType();
                Icon icon2 = fileType == null ? null : fileType.getIcon();
                return icon2 != null ? icon2 : AllIcons.FileTypes.Any_type;
            }

            @Override
            public String getStorageId(Language language) {
                return language.getID();
            }
        }.withComparator(LanguageUtil.LANGUAGE_COMPARATOR);
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(6);
        }
        return lRUPopupBuilder;
    }

    protected LRUPopupBuilder(@NotNull Project project2, @NotNull @NlsContexts.PopupTitle String title) {
        if (project2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(7);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(8);
        }
        this.myPresentations = new IdentityHashMap<T, Pair<String, Icon>>();
        this.myTopValues = JBIterable.empty();
        this.myMiddleValues = JBIterable.empty();
        this.myBottomValues = JBIterable.empty();
        this.myTitle = title;
        this.myPropertiesComponent = PropertiesComponent.getInstance(project2);
    }

    public abstract String getDisplayName(T var1);

    public abstract String getStorageId(T var1);

    public abstract Icon getIcon(T var1);

    @NotNull
    public LRUPopupBuilder<T> forValues(@Nullable Iterable<? extends T> items) {
        this.myValues = items;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(9);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withSelection(@Nullable T t) {
        this.mySelection = t;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(10);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withExtraTopValue(@NotNull T extra, @Nls @NotNull String displayName, @Nullable Icon icon2) {
        if (extra == null) {
            LRUPopupBuilder.$$$reportNull$$$0(11);
        }
        if (displayName == null) {
            LRUPopupBuilder.$$$reportNull$$$0(12);
        }
        this.myTopValues = this.myTopValues.append(extra);
        this.myPresentations.put(extra, Pair.create(displayName, icon2));
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(13);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withExtraMiddleValue(@NotNull T extra, @Nls @NotNull String displayName, @Nullable Icon icon2) {
        if (extra == null) {
            LRUPopupBuilder.$$$reportNull$$$0(14);
        }
        if (displayName == null) {
            LRUPopupBuilder.$$$reportNull$$$0(15);
        }
        this.myMiddleValues = this.myMiddleValues.append(extra);
        this.myPresentations.put(extra, Pair.create(displayName, icon2));
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(16);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withExtraBottomValue(@NotNull T extra, @Nls @NotNull String displayName, @Nullable Icon icon2) {
        if (extra == null) {
            LRUPopupBuilder.$$$reportNull$$$0(17);
        }
        if (displayName == null) {
            LRUPopupBuilder.$$$reportNull$$$0(18);
        }
        this.myBottomValues = this.myBottomValues.append(extra);
        this.myPresentations.put(extra, Pair.create(displayName, icon2));
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(19);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> onChosen(@Nullable Consumer<? super T> consumer) {
        this.myOnChosen = consumer;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(20);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withComparator(@Nullable Comparator<? super T> comparator2) {
        this.myComparator = comparator2;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(21);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withExtraSpeedSearchNamer(@Nullable Function<? super T, String> function) {
        this.myExtraSpeedSearchNamer = function;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(22);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public ListPopup buildPopup() {
        ArrayList<String> ids = ContainerUtil.newArrayList(this.restoreLRUItems());
        if (this.mySelection != null) {
            ids.add(this.getStorageId(this.mySelection));
        }
        final List<T> topItems = this.myTopValues.toList();
        ArrayList<Object> lru = new ArrayList<Object>(4);
        List<T> middleItems = this.myMiddleValues.toList();
        ArrayList<? super T> items = new ArrayList<T>(20);
        final List<T> bottomItems = this.myBottomValues.toList();
        for (Object t : JBIterable.from(this.myValues)) {
            (ids.contains(this.getStorageId(t)) ? lru : items).add(t);
        }
        if (this.myComparator != null) {
            items.sort(this.myComparator);
        }
        if (!lru.isEmpty()) {
            lru.sort(Comparator.comparingInt(o -> ids.indexOf(this.getStorageId(o))));
        }
        List combinedItems = ContainerUtil.concat(new List[]{topItems, lru, middleItems, items, bottomItems});
        final Object sep1 = ContainerUtil.getOrElse(combinedItems, topItems.size() + lru.size() + middleItems.size(), null);
        final Object sep2 = ContainerUtil.getOrElse(combinedItems, topItems.size() + lru.size() + middleItems.size() + items.size(), null);
        BaseListPopupStep step = new BaseListPopupStep<T>(this.myTitle, combinedItems){

            @NotNull
            public String getTextFor(T t) {
                String string2 = t == null ? "" : (String)LRUPopupBuilder.this.getPresentation(t).first;
                if (string2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string2;
            }

            public Icon getIconFor(T t) {
                return t == null ? null : (Icon)LRUPopupBuilder.this.getPresentation(t).second;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public String getIndexedString(T value) {
                String extra;
                String string2 = extra = LRUPopupBuilder.this.myExtraSpeedSearchNamer != null ? StringUtil.nullize(LRUPopupBuilder.this.myExtraSpeedSearchNamer.apply(value)) : null;
                if (extra == null) {
                    return super.getIndexedString(value);
                }
                return super.getIndexedString(value) + SpeedSearchUtil.getDefaultHardSeparators() + extra;
            }

            public PopupStep<?> onChosen(T t, boolean finalChoice) {
                if (!bottomItems.contains(t) && !topItems.contains(t)) {
                    LRUPopupBuilder.this.storeLRUItems(t);
                }
                if (LRUPopupBuilder.this.myOnChosen != null) {
                    this.doFinalStep(() -> LRUPopupBuilder.this.myOnChosen.consume(t));
                }
                return null;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(T value) {
                return value == sep1 || value == sep2 ? new ListSeparator() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder$2", "getTextFor"));
            }
        };
        int selection = Math.max(0, this.mySelection != null ? combinedItems.indexOf(this.mySelection) : 0);
        step.setDefaultOptionIndex(selection);
        return LRUPopupBuilder.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
    }

    private @NotNull Pair<@Nls String, Icon> getPresentation(T t) {
        Pair<String, Icon> p = this.myPresentations.get(t);
        if (p == null) {
            p = Pair.create(this.getDisplayName(t), this.getIcon(t));
            this.myPresentations.put(t, p);
        }
        Pair<String, Icon> pair = p;
        if (pair == null) {
            LRUPopupBuilder.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup2) {
        if (popup2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(24);
        }
        int nameLen = 0;
        ListPopupStep step = popup2.getListStep();
        List values2 = step.getValues();
        for (Object v : values2) {
            nameLen = Math.max(nameLen, step.getTextFor(v).length());
        }
        if (values2.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol('a', nameLen), EmptyIcon.ICON_16, 2).getPreferredSize();
            size.width += 20;
            size.height *= 20;
            popup2.setSize(size);
        }
        ListPopup listPopup = popup2;
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(25);
        }
        return listPopup;
    }

    @NotNull
    private List<String> restoreLRUItems() {
        List<String> list2 = Objects.requireNonNullElse(this.myPropertiesComponent.getList(this.getLRUKey()), Collections.emptyList());
        if (list2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(26);
        }
        return list2;
    }

    private void storeLRUItems(@NotNull T t) {
        if (t == null) {
            LRUPopupBuilder.$$$reportNull$$$0(27);
        }
        List<String> values2 = this.myPropertiesComponent.getList(this.getLRUKey());
        ArrayList<String> lastUsed = new ArrayList<String>(4);
        lastUsed.add(this.getStorageId(t));
        if (values2 != null) {
            for (String value : values2) {
                if (!lastUsed.contains(value)) {
                    lastUsed.add(value);
                }
                if (lastUsed.size() != 4) continue;
                break;
            }
        }
        this.myPropertiesComponent.setList(this.getLRUKey(), lastUsed);
    }

    @NotNull
    private String getLRUKey() {
        String string2 = this.getClass().getName() + "/" + this.myTitle;
        if (string2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(28);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/LRUPopupBuilder";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/LRUPopupBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forFileLanguages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "languagePopupBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withSelection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraTopValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraMiddleValue";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraBottomValue";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "onChosen";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "withComparator";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraSpeedSearchNamer";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakSizeToPreferred";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreLRUItems";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLRUKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forFileLanguages";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "languagePopupBuilder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withExtraTopValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withExtraMiddleValue";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withExtraBottomValue";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "tweakSizeToPreferred";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "storeLRUItems";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

