/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.CliResult;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeStartupScripts;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ApplicationStarterBase;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Window;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeScriptStarter
extends ApplicationStarterBase {
    private static final Logger LOG = Logger.getInstance(IdeScriptStarter.class);

    IdeScriptStarter() {
        super(new int[0]);
    }

    public String getCommandName() {
        return "ideScript";
    }

    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        return LangBundle.message("ide.script.starter.usage", scriptName, this.getCommandName());
    }

    protected boolean checkArguments(@NotNull List<String> args2) {
        if (args2 == null) {
            IdeScriptStarter.$$$reportNull$$$0(0);
        }
        return args2.size() > 1;
    }

    @NotNull
    protected Future<CliResult> processCommand(@NotNull List<String> args2, @Nullable String currentDirectory) throws Exception {
        if (args2 == null) {
            IdeScriptStarter.$$$reportNull$$$0(1);
        }
        List<Path> filePaths = ContainerUtil.map(args2.subList(1, args2.size()), x$0 -> Paths.get(x$0, new String[0]));
        Project project2 = IdeScriptStarter.guessProject();
        CompletableFuture<CliResult> future2 = new CompletableFuture<CliResult>();
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            List<Pair<Path, IdeScriptEngine>> result2 = IdeStartupScripts.prepareScriptsAndEngines(filePaths);
            IdeStartupScripts.runAllScriptsImpl(project2, result2, project2 != null ? LOG : IdeScriptStarter.redirectStreamsAndGetLogger(result2));
            future2.complete(CliResult.OK);
        });
        CompletableFuture<CliResult> completableFuture = future2;
        if (completableFuture == null) {
            IdeScriptStarter.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    @Nullable
    private static Project guessProject() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Window recentFocusedWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (recentFocusedWindow instanceof IdeFrame) {
            return ((IdeFrame)recentFocusedWindow).getProject();
        }
        return ContainerUtil.find(openProjects, o -> o.isInitialized() && !o.isDisposed());
    }

    @NotNull
    private static Logger redirectStreamsAndGetLogger(List<Pair<Path, IdeScriptEngine>> result2) {
        for (Pair<Path, IdeScriptEngine> pair : result2) {
            ((IdeScriptEngine)pair.second).setStdOut((Writer)new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
            ((IdeScriptEngine)pair.second).setStdErr((Writer)new OutputStreamWriter((OutputStream)System.err, Charset.defaultCharset()));
            ((IdeScriptEngine)pair.second).setStdIn((Reader)new InputStreamReader(System.in, Charset.defaultCharset()));
        }
        return new DefaultLogger(null){

            @Override
            public void info(String message2) {
                System.out.println("INFO: " + message2);
            }

            @Override
            public void info(String message2, Throwable t) {
                System.out.println("INFO: " + message2);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/script/IdeScriptStarter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/script/IdeScriptStarter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkArguments";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processCommand";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

