/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.symbol;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.symbol.DelegatingPsiElementWithSymbolPointer;
import com.intellij.ide.structureView.symbol.SymbolBasedStructureViewModel;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.presentation.SymbolDeclarationPresentation;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.impl.Declarations;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSymbolTreeElement
extends PsiTreeElementBase<PsiElement> {
    private static final Logger LOG = Logger.getInstance(PsiSymbolTreeElement.class);
    @NotNull
    private final Pointer<? extends Symbol> mySymbolPointer;
    @NotNull
    private final SymbolBasedStructureViewModel myStructureViewModel;

    public PsiSymbolTreeElement(@NotNull PsiSymbolDeclaration declaration, @NotNull SymbolBasedStructureViewModel structureViewModel) {
        if (declaration == null) {
            PsiSymbolTreeElement.$$$reportNull$$$0(0);
        }
        if (structureViewModel == null) {
            PsiSymbolTreeElement.$$$reportNull$$$0(1);
        }
        super(declaration.getDeclaringElement());
        this.mySymbolPointer = declaration.getSymbol().createPointer();
        this.myStructureViewModel = structureViewModel;
    }

    @Nullable
    public final PsiSymbolDeclaration getSymbolDeclaration() {
        PsiElement declaringElement = this.getElement();
        if (declaringElement == null) {
            return null;
        }
        Symbol declaredSymbol = this.getSymbol();
        if (declaredSymbol == null) {
            return null;
        }
        for (PsiSymbolDeclaration symbolDeclaration : Declarations.allDeclarationsInElement(declaringElement)) {
            if (!Objects.equals(declaredSymbol, symbolDeclaration.getSymbol())) continue;
            return symbolDeclaration;
        }
        return null;
    }

    public final boolean isValid() {
        return this.getSymbolDeclaration() != null;
    }

    @Nullable
    public final Symbol getSymbol() {
        return this.mySymbolPointer.dereference();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        PsiSymbolDeclaration symbolDeclaration = this.getSymbolDeclaration();
        if (symbolDeclaration == null) {
            LOG.debug("No declaration for presentation");
            PsiSymbolTreeElement psiSymbolTreeElement = this;
            if (psiSymbolTreeElement == null) {
                PsiSymbolTreeElement.$$$reportNull$$$0(2);
            }
            return psiSymbolTreeElement;
        }
        SymbolDeclarationPresentation symbolDeclarationPresentation = SymbolDeclarationPresentation.getFor(symbolDeclaration);
        if (symbolDeclarationPresentation != null) {
            SymbolDeclarationPresentation symbolDeclarationPresentation2 = symbolDeclarationPresentation;
            if (symbolDeclarationPresentation2 == null) {
                PsiSymbolTreeElement.$$$reportNull$$$0(3);
            }
            return symbolDeclarationPresentation2;
        }
        LOG.debug("No presentation for " + symbolDeclaration + " or declaring element");
        PsiSymbolTreeElement psiSymbolTreeElement = this;
        if (psiSymbolTreeElement == null) {
            PsiSymbolTreeElement.$$$reportNull$$$0(4);
        }
        return psiSymbolTreeElement;
    }

    @Nullable
    public String getPresentableText() {
        return null;
    }

    public boolean canNavigate() {
        Navigatable navigatable = this.getNavigatable();
        return navigatable == null ? super.canNavigate() : navigatable.canNavigate();
    }

    public boolean canNavigateToSource() {
        Navigatable navigatable = this.getNavigatable();
        return navigatable == null ? super.canNavigateToSource() : navigatable.canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        Navigatable navigatable = this.getNavigatable();
        if (navigatable == null) {
            super.navigate(requestFocus);
        } else {
            navigatable.navigate(requestFocus);
        }
    }

    @Nullable
    protected Navigatable getNavigatable() {
        PsiSymbolDeclaration symbolDeclaration = this.getSymbolDeclaration();
        return PsiSymbolTreeElement.getNavigatable(symbolDeclaration);
    }

    @Nullable
    public static Navigatable getNavigatable(@Nullable PsiSymbolDeclaration symbolDeclaration) {
        if (symbolDeclaration == null) {
            LOG.debug("No symbol declaration for navigation");
            return null;
        }
        PsiElement declaringElement = symbolDeclaration.getDeclaringElement();
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(declaringElement);
        if (virtualFile2 == null) {
            LOG.debug("Unable to find virtual file for: " + symbolDeclaration + "; " + declaringElement);
            return null;
        }
        return PsiNavigationSupport.getInstance().createNavigatable(declaringElement.getProject(), virtualFile2, symbolDeclaration.getAbsoluteRange().getStartOffset());
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        PsiElement declarationElement = this.getElement();
        List<StructureViewTreeElement> list2 = declarationElement == null ? Collections.emptyList() : this.myStructureViewModel.collectClosestChildrenSymbols(declarationElement);
        if (list2 == null) {
            PsiSymbolTreeElement.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public PsiElement getValue() {
        PsiElement declarationElement = super.getValue();
        return declarationElement == null ? null : new DelegatingPsiElementWithSymbolPointer(declarationElement, this.mySymbolPointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureViewModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/symbol/PsiSymbolTreeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/symbol/PsiSymbolTreeElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

