/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.codeInsight.daemon.ChangeLocalityDetector;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiLineTodoLocalityDetector
implements ChangeLocalityDetector {
    @Override
    @Nullable
    public PsiElement getChangeHighlightingDirtyScopeFor(@NotNull PsiElement changedElement) {
        if (changedElement == null) {
            MultiLineTodoLocalityDetector.$$$reportNull$$$0(0);
        }
        if (!TodoConfiguration.getInstance().isMultiLine()) {
            return null;
        }
        if (changedElement instanceof PsiWhiteSpace) {
            PsiElement prevLeaf = PsiTreeUtil.prevLeaf(changedElement);
            return prevLeaf instanceof PsiComment ? PsiTreeUtil.findCommonParent(changedElement, prevLeaf) : null;
        }
        if (changedElement instanceof PsiComment) {
            PsiComment commentAbove = MultiLineTodoLocalityDetector.findAdjacentComment(changedElement, true);
            PsiComment commentBelow = MultiLineTodoLocalityDetector.findAdjacentComment(changedElement, false);
            if (commentAbove == null && commentBelow == null) {
                return null;
            }
            return PsiTreeUtil.findCommonParent(changedElement, commentAbove, commentBelow);
        }
        return null;
    }

    private static PsiComment findAdjacentComment(PsiElement element2, boolean above) {
        PsiElement currentElement = element2;
        PsiComment lastComment = null;
        boolean nextLine = false;
        while (true) {
            String elementText;
            PsiElement psiElement = currentElement = above ? PsiTreeUtil.prevLeaf(currentElement) : PsiTreeUtil.nextLeaf(currentElement);
            if (currentElement == null || (elementText = currentElement.getText()) == null) break;
            int newLines = StringUtil.countNewLines(elementText);
            if (newLines == 0 && !nextLine) continue;
            if (currentElement instanceof PsiComment) {
                lastComment = (PsiComment)currentElement;
            }
            if (newLines > (nextLine ? 0 : 1)) break;
            nextLine = true;
        }
        return lastComment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedElement", "com/intellij/ide/todo/MultiLineTodoLocalityDetector", "getChangeHighlightingDirtyScopeFor"));
    }
}

