/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ConfigurableFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.Consumer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetTodoFilterAction
extends ActionGroup
implements DumbAware {
    private final Project myProject;
    private final TodoPanelSettings myToDoSettings;
    private final Consumer<? super TodoFilter> myTodoFilterConsumer;

    public SetTodoFilterAction(@NotNull Project project2, @NotNull TodoPanelSettings toDoSettings, @NotNull Consumer<? super TodoFilter> todoFilterConsumer) {
        if (project2 == null) {
            SetTodoFilterAction.$$$reportNull$$$0(0);
        }
        if (toDoSettings == null) {
            SetTodoFilterAction.$$$reportNull$$$0(1);
        }
        if (todoFilterConsumer == null) {
            SetTodoFilterAction.$$$reportNull$$$0(2);
        }
        super(IdeBundle.message((String)"action.filter.todo.items", (Object[])new Object[0]), null, AllIcons.General.Filter);
        this.setPopup(true);
        this.myProject = project2;
        this.myToDoSettings = toDoSettings;
        this.myTodoFilterConsumer = todoFilterConsumer;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = SetTodoFilterAction.createPopupActionGroup(this.myProject, this.myToDoSettings, this.myTodoFilterConsumer).getChildren(e);
        if (anActionArray == null) {
            SetTodoFilterAction.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    public static DefaultActionGroup createPopupActionGroup(final @NotNull Project project2, @NotNull TodoPanelSettings settings, @NotNull Consumer<? super TodoFilter> todoFilterConsumer) {
        if (project2 == null) {
            SetTodoFilterAction.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            SetTodoFilterAction.$$$reportNull$$$0(5);
        }
        if (todoFilterConsumer == null) {
            SetTodoFilterAction.$$$reportNull$$$0(6);
        }
        TodoFilter[] filters = TodoConfiguration.getInstance().getTodoFilters();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new TodoFilterApplier(IdeBundle.message((String)"action.todo.show.all", (Object[])new Object[0]), IdeBundle.message((String)"action.description.todo.show.all", (Object[])new Object[0]), null, settings, todoFilterConsumer));
        for (TodoFilter filter2 : filters) {
            group.add((AnAction)new TodoFilterApplier(filter2.getName(), null, filter2, settings, todoFilterConsumer));
        }
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.todo.edit.filters", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.todo.edit.filters.description", (Object[])new Object[0]), AllIcons.General.Settings){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                util.editConfigurable(project2, (Configurable)ConfigurableFactory.Companion.getInstance().getTodoConfigurable(project2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/SetTodoFilterAction$1", "actionPerformed"));
            }
        });
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDoSettings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoFilterConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/SetTodoFilterAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/SetTodoFilterAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TodoFilterApplier
    extends ToggleAction
    implements DumbAware {
        private final TodoFilter myFilter;
        private final TodoPanelSettings mySettings;
        private final Consumer<? super TodoFilter> myTodoFilterConsumer;

        TodoFilterApplier(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, TodoFilter filter2, TodoPanelSettings settings, Consumer<? super TodoFilter> todoFilterConsumer) {
            super(null, description, null);
            this.mySettings = settings;
            this.myTodoFilterConsumer = todoFilterConsumer;
            this.getTemplatePresentation().setText(text2, false);
            this.myFilter = filter2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TodoFilterApplier.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (this.myFilter != null) {
                e.getPresentation().setEnabled(!this.myFilter.isEmpty());
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                TodoFilterApplier.$$$reportNull$$$0(1);
            }
            String arg1 = this.myFilter != null ? this.myFilter.getName() : null;
            return Objects.equals(arg1, this.mySettings.todoFilterName);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                TodoFilterApplier.$$$reportNull$$$0(2);
            }
            if (state) {
                this.myTodoFilterConsumer.consume((TodoFilter)this.myFilter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/todo/SetTodoFilterAction$TodoFilterApplier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

