/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.BaseToDoNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ModuleToDoNode
extends BaseToDoNode<Module> {
    public ModuleToDoNode(Project project2, @NotNull Module value, TodoTreeBuilder builder2) {
        if (value == null) {
            ModuleToDoNode.$$$reportNull$$$0(0);
        }
        super(project2, value, builder2);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        ArrayList children2 = new ArrayList();
        if (this.myToDoSettings.getIsPackagesShown()) {
            TodoTreeHelper.getInstance(this.getProject()).addPackagesToChildren(children2, (Module)this.getValue(), this.myBuilder);
        } else {
            Iterator<PsiFile> i = this.myBuilder.getAllFiles();
            while (i.hasNext()) {
                PsiFile psiFile = i.next();
                if (psiFile == null) continue;
                VirtualFile virtualFile2 = psiFile.getVirtualFile();
                boolean isInContent = ModuleRootManager.getInstance((Module)this.getValue()).getFileIndex().isInContent(virtualFile2);
                if (!isInContent) continue;
                TodoFileNode fileNode = new TodoFileNode(this.getProject(), psiFile, this.myBuilder, false);
                if (!this.getTreeStructure().accept(psiFile) || children2.contains(fileNode)) continue;
                children2.add(fileNode);
            }
        }
        ArrayList arrayList = children2;
        if (arrayList == null) {
            ModuleToDoNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public boolean contains(Object element2) {
        if (element2 instanceof TodoItem) {
            Module module = ModuleUtilCore.findModuleForFile(((TodoItem)element2).getFile());
            return super.canRepresent((Object)module);
        }
        if (element2 instanceof PsiElement) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
            return super.canRepresent((Object)module);
        }
        return super.canRepresent(element2);
    }

    private TodoTreeStructure getStructure() {
        return this.myBuilder.getTodoTreeStructure();
    }

    public void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            ModuleToDoNode.$$$reportNull$$$0(2);
        }
        String newName2 = ((Module)this.getValue()).getName();
        int todoItemCount = this.getTodoItemCount((Module)this.getValue());
        presentation2.setLocationString(IdeBundle.message((String)"node.todo.group", (Object[])new Object[]{todoItemCount}));
        presentation2.setIcon(ModuleType.get((Module)((Module)this.getValue())).getIcon());
        presentation2.setPresentableText(newName2);
    }

    public String getTestPresentation() {
        return "Module";
    }

    @Override
    public int getFileCount(Module module) {
        Iterator<PsiFile> iterator = this.myBuilder.getFiles(module);
        int count2 = 0;
        while (iterator.hasNext()) {
            PsiFile psiFile = iterator.next();
            if (!this.getStructure().accept(psiFile)) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public int getTodoItemCount(Module val) {
        Iterator<PsiFile> iterator = this.myBuilder.getFiles(val);
        int count2 = 0;
        while (iterator.hasNext()) {
            PsiFile psiFile = iterator.next();
            count2 += ReadAction.compute(() -> this.getTreeStructure().getTodoItemCount(psiFile)).intValue();
        }
        return count2;
    }

    public int getWeight() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/nodes/ModuleToDoNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/nodes/ModuleToDoNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

