/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ViewStructureAction;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.structureView.newStructureView.TreeActionWrapper;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.util.ActionShortcutProvider;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.ide.util.TreeStructureActionsOwner;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.SpeedSearchObjectWithWeight;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.TextRangeUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FileStructurePopup
implements Disposable,
TreeActionsOwner {
    private static final Logger LOG = Logger.getInstance(FileStructurePopup.class);
    @NonNls
    private static final String NARROW_DOWN_PROPERTY_KEY = "FileStructurePopup.narrowDown";
    private final Project myProject;
    private final FileEditor myFileEditor;
    private final StructureViewModel myTreeModelWrapper;
    private final StructureViewModel myTreeModel;
    private final TreeStructureActionsOwner myTreeActionsOwner;
    private JBPopup myPopup;
    private @NlsContexts.PopupTitle String myTitle;
    private final Tree myTree;
    private final SmartTreeStructure myTreeStructure;
    private final FilteringTreeStructure myFilteringStructure;
    private final AsyncTreeModel myAsyncTreeModel;
    private final StructureTreeModel myStructureTreeModel;
    private final TreeSpeedSearch mySpeedSearch;
    private final Object myInitialElement;
    private final Map<Class, JBCheckBox> myCheckBoxes;
    private final List<JBCheckBox> myAutoClicked;
    private String myTestSearchFilter;
    private final List<Pair<String, JBCheckBox>> myTriggeredCheckboxes;
    private final TreeExpander myTreeExpander;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private boolean myCanClose;
    private boolean myDisposed;

    @Deprecated(forRemoval=true)
    public FileStructurePopup(@NotNull Project project2, @NotNull FileEditor fileEditor, @NotNull StructureView structureView, boolean applySortAndFilter) {
        if (project2 == null) {
            FileStructurePopup.$$$reportNull$$$0(0);
        }
        if (fileEditor == null) {
            FileStructurePopup.$$$reportNull$$$0(1);
        }
        if (structureView == null) {
            FileStructurePopup.$$$reportNull$$$0(2);
        }
        this(project2, fileEditor, ViewStructureAction.createStructureViewModel(project2, fileEditor, structureView));
        Disposer.register(this, (Disposable)structureView);
    }

    public FileStructurePopup(@NotNull Project project2, @NotNull FileEditor fileEditor, @NotNull StructureViewModel treeModel) {
        if (project2 == null) {
            FileStructurePopup.$$$reportNull$$$0(3);
        }
        if (fileEditor == null) {
            FileStructurePopup.$$$reportNull$$$0(4);
        }
        if (treeModel == null) {
            FileStructurePopup.$$$reportNull$$$0(5);
        }
        this.myCheckBoxes = new HashMap<Class, JBCheckBox>();
        this.myAutoClicked = new ArrayList<JBCheckBox>();
        this.myTriggeredCheckboxes = new ArrayList<Pair<String, JBCheckBox>>();
        this.myCanClose = true;
        this.myProject = project2;
        this.myFileEditor = fileEditor;
        this.myTreeModel = treeModel;
        DaemonCodeAnalyzer.getInstance(this.myProject).disableUpdateByTimer(this);
        this.myTreeActionsOwner = new TreeStructureActionsOwner(this.myTreeModel);
        this.myTreeActionsOwner.setActionIncluded((TreeAction)Sorter.ALPHA_SORTER, true);
        this.myTreeModelWrapper = new TreeModelWrapper(this.myTreeModel, this.myTreeActionsOwner);
        Disposer.register(this, (Disposable)this.myTreeModelWrapper);
        this.myTreeStructure = new SmartTreeStructure(project2, (TreeModel)this.myTreeModelWrapper){

            public void rebuildTree() {
                if (!ApplicationManager.getApplication().isUnitTestMode() && FileStructurePopup.this.myPopup.isDisposed()) {
                    return;
                }
                ProgressManager.getInstance().computePrioritized(() -> {
                    super.rebuildTree();
                    FileStructurePopup.this.myFilteringStructure.rebuild();
                    return null;
                });
            }

            public boolean isToBuildChildrenInBackground(@NotNull Object element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return this.getRootElement() == element2;
            }

            @NotNull
            protected TreeElementWrapper createTree() {
                TreeElementWrapper treeElementWrapper = StructureViewComponent.createWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
                if (treeElementWrapper == null) {
                    1.$$$reportNull$$$0(1);
                }
                return treeElementWrapper;
            }

            @NonNls
            public String toString() {
                return "structure view tree structure(model=" + FileStructurePopup.this.myTreeModelWrapper + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/FileStructurePopup$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/FileStructurePopup$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTree";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isToBuildChildrenInBackground";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        FileStructurePopupFilter filter2 = new FileStructurePopupFilter();
        this.myFilteringStructure = new FilteringTreeStructure((ElementFilter)filter2, (AbstractTreeStructure)this.myTreeStructure, false);
        this.myStructureTreeModel = new StructureTreeModel((AbstractTreeStructure)this.myFilteringStructure, (Disposable)this);
        this.myAsyncTreeModel = new AsyncTreeModel((javax.swing.tree.TreeModel)this.myStructureTreeModel, (Disposable)this);
        this.myAsyncTreeModel.setRootImmediately((Object)this.myStructureTreeModel.getRootImmediately());
        this.myTree = new MyTree((javax.swing.tree.TreeModel)this.myAsyncTreeModel);
        StructureViewComponent.registerAutoExpandListener((JTree)this.myTree, this.myTreeModel);
        PopupUtil.applyNewUIBackground((Component)this.myTree);
        ModelListener modelListener2 = () -> this.rebuild(false);
        this.myTreeModel.addModelListener(modelListener2);
        Disposer.register(this, () -> this.myTreeModel.removeModelListener(modelListener2));
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myProject.getMessageBus().connect(this).subscribe(UISettingsListener.TOPIC, o -> this.rebuild(false));
        this.myTree.setTransferHandler(new TransferHandler(){

            @Override
            public boolean importData(@NotNull TransferHandler.TransferSupport support) {
                String s;
                if (support == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)) != null && !FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                    FileStructurePopup.this.mySpeedSearch.showPopup(s);
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent component2) {
                JBIterable<Pair> pairs = JBIterable.of(FileStructurePopup.this.myTree.getSelectionPaths()).filterMap(TreeUtil::getLastUserObject).filter(FilteringTreeStructure.FilteringNode.class).filterMap(o -> o.getDelegate() instanceof PsiElement ? Pair.create(o, (PsiElement)o.getDelegate()) : null).collect();
                if (pairs.isEmpty()) {
                    return null;
                }
                Set psiSelection = pairs.map(Functions.pairSecond()).toSet();
                String text2 = StringUtil.join(pairs, pair -> {
                    PsiElement psi = (PsiElement)pair.second;
                    String defaultPresentation = ((FilteringTreeStructure.FilteringNode)pair.first).getPresentation().getPresentableText();
                    if (psi == null) {
                        return defaultPresentation;
                    }
                    for (PsiElement p = psi.getParent(); p != null; p = p.getParent()) {
                        if (!psiSelection.contains(p)) continue;
                        return null;
                    }
                    return ObjectUtils.chooseNotNull(psi.getText(), defaultPresentation);
                }, "\n");
                String htmlText = "<body>\n" + text2 + "\n</body>";
                return new TextTransferable(XmlStringUtil.wrapInHtml(htmlText), text2);
            }

            @Override
            public int getSourceActions(JComponent component2) {
                return 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/ide/util/FileStructurePopup$2", "importData"));
            }
        });
        this.mySpeedSearch = new MyTreeSpeedSearch();
        this.mySpeedSearch.setComparator(new SpeedSearchComparator(false, true, " ()"));
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myTree);
        this.myInitialElement = this.myTreeModel.getCurrentEditorElement();
        TreeUtil.installActions((JTree)this.myTree);
    }

    public void show() {
        JComponent panel2 = this.createCenterPanel();
        this.myTree.addTreeSelectionListener(__ -> {
            PopupUpdateProcessor updateProcessor;
            if (this.myPopup.isVisible() && (updateProcessor = (PopupUpdateProcessor)((Object)((Object)this.myPopup.getUserData(PopupUpdateProcessor.class)))) != null) {
                AbstractTreeNode node2 = this.getSelectedNode();
                updateProcessor.updatePopup(node2);
            }
        });
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(panel2, (JComponent)this.myTree).setTitle(this.myTitle).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setMovable(true).setBelongsToGlobalPopupStack(true).setCancelOnOtherWindowOpen(true).setCancelKeyEnabled(false).setDimensionServiceKey(this.myProject, FileStructurePopup.getDimensionServiceKey(), true).setCancelCallback(() -> this.myCanClose).createPopup();
        Disposer.register((Disposable)this.myPopup, this);
        this.myTree.getEmptyText().setText(CommonBundle.getLoadingTreeNodeText());
        this.myPopup.showCenteredInCurrentWindow(this.myProject);
        ((AbstractPopup)this.myPopup).setShowHints(true);
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTree, true);
        this.rebuildAndSelect(false, this.myInitialElement).onProcessed(path2 -> UIUtil.invokeLaterIfNeeded(() -> {
            TreeUtil.ensureSelection((JTree)this.myTree);
            this.installUpdater();
        }));
    }

    private void installUpdater() {
        if (ApplicationManager.getApplication().isUnitTestMode() || this.myPopup.isDisposed()) {
            return;
        }
        final Alarm alarm2 = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myPopup);
        alarm2.addRequest(new Runnable(){
            String filter = "";

            @Override
            public void run() {
                alarm2.cancelAllRequests();
                String prefix = FileStructurePopup.this.mySpeedSearch.getEnteredPrefix();
                FileStructurePopup.this.myTree.getEmptyText().setText((String)(StringUtil.isEmpty(prefix) ? LangBundle.message("status.text.structure.empty", new Object[0]) : "'" + prefix + "' " + LangBundle.message("status.text.structure.empty.not.found", new Object[0])));
                if (prefix == null) {
                    prefix = "";
                }
                if (!this.filter.equals(prefix)) {
                    boolean isBackspace = prefix.length() < this.filter.length();
                    this.filter = prefix;
                    FileStructurePopup.this.rebuild(true).onProcessed(ignore -> UIUtil.invokeLaterIfNeeded(() -> {
                        if (FileStructurePopup.this.isDisposed()) {
                            return;
                        }
                        TreeUtil.promiseExpandAll((JTree)FileStructurePopup.this.myTree);
                        if (isBackspace && FileStructurePopup.this.handleBackspace(this.filter)) {
                            return;
                        }
                        if (FileStructurePopup.this.myFilteringStructure.getRootElement().getChildren().length == 0) {
                            for (JBCheckBox box2 : FileStructurePopup.this.myCheckBoxes.values()) {
                                if (box2.isSelected()) continue;
                                FileStructurePopup.this.myAutoClicked.add(box2);
                                FileStructurePopup.this.myTriggeredCheckboxes.add(0, Pair.create(this.filter, box2));
                                box2.doClick();
                                this.filter = "";
                                break;
                            }
                        }
                    }));
                }
                if (!alarm2.isDisposed()) {
                    alarm2.addRequest((Runnable)this, 300);
                }
            }
        }, 300);
    }

    private boolean handleBackspace(String filter2) {
        Pair<String, JBCheckBox> next;
        boolean clicked = false;
        Iterator<Pair<String, JBCheckBox>> iterator = this.myTriggeredCheckboxes.iterator();
        while (iterator.hasNext() && (next = iterator.next()).getFirst().length() >= filter2.length()) {
            iterator.remove();
            next.getSecond().doClick();
            clicked = true;
        }
        return clicked;
    }

    @NotNull
    public Promise<TreePath> select(final Object element2) {
        final int[] stage = new int[]{1, 0};
        final TreePath[] deepestPath = new TreePath[]{null};
        final TreeVisitor visitor = path2 -> {
            Object last2 = path2.getLastPathComponent();
            Object userObject = StructureViewComponent.unwrapNavigatable(last2);
            Object value = StructureViewComponent.unwrapValue(last2);
            if (Comparing.equal(value, element2) || userObject instanceof AbstractTreeNode && ((AbstractTreeNode)userObject).canRepresent(element2)) {
                return TreeVisitor.Action.INTERRUPT;
            }
            if (value instanceof PsiElement && element2 instanceof PsiElement) {
                if (PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)element2, true)) {
                    int count2 = path2.getPathCount();
                    if (stage[1] == 0 || stage[1] < count2) {
                        stage[1] = count2;
                        deepestPath[0] = path2;
                    }
                } else if (stage[0] != 3) {
                    stage[0] = 2;
                    return TreeVisitor.Action.SKIP_CHILDREN;
                }
            }
            return TreeVisitor.Action.CONTINUE;
        };
        final Function<TreePath, Promise> action2 = path2 -> {
            this.myTree.expandPath(path2);
            TreeUtil.selectPath((JTree)this.myTree, (TreePath)path2);
            TreeUtil.ensureSelection((JTree)this.myTree);
            return Promises.resolvedPromise((Object)path2);
        };
        Function<TreePath, Promise<TreePath>> fallback = new Function<TreePath, Promise<TreePath>>(){

            @Override
            public Promise<TreePath> fun(TreePath path2) {
                Object minChild;
                TreePath adjusted;
                if (path2 == null && stage[0] == 2) {
                    stage[0] = 3;
                    return FileStructurePopup.this.myAsyncTreeModel.accept(visitor).thenAsync(this);
                }
                TreePath treePath = adjusted = path2 == null ? deepestPath[0] : path2;
                if (path2 == null && adjusted != null && element2 instanceof PsiElement && (minChild = FileStructurePopup.findClosestPsiElement((PsiElement)element2, adjusted, (javax.swing.tree.TreeModel)FileStructurePopup.this.myAsyncTreeModel)) != null) {
                    adjusted = adjusted.pathByAddingChild(minChild);
                }
                return adjusted == null ? Promises.rejectedPromise() : (Promise)action2.fun(adjusted);
            }
        };
        Promise<TreePath> promise = this.myAsyncTreeModel.accept(visitor).thenAsync(fallback);
        if (promise == null) {
            FileStructurePopup.$$$reportNull$$$0(6);
        }
        return promise;
    }

    @TestOnly
    public AsyncPromise<Void> rebuildAndUpdate() {
        AsyncPromise result2 = new AsyncPromise();
        TreeVisitor visitor = path2 -> {
            AbstractTreeNode node2 = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)path2);
            if (node2 != null) {
                node2.update();
            }
            return TreeVisitor.Action.CONTINUE;
        };
        this.rebuild(false).onProcessed(ignore1 -> this.myAsyncTreeModel.accept(visitor).onProcessed(ignore2 -> result2.setResult(null)));
        return result2;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
    }

    private static boolean isShouldNarrowDown() {
        return PropertiesComponent.getInstance().getBoolean(NARROW_DOWN_PROPERTY_KEY, true);
    }

    @NonNls
    protected static String getDimensionServiceKey() {
        return "StructurePopup";
    }

    @Nullable
    public PsiElement getCurrentElement(@Nullable PsiFile psiFile) {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        Object elementAtCursor = this.myTreeModelWrapper.getCurrentEditorElement();
        if (elementAtCursor instanceof PsiElement) {
            return (PsiElement)elementAtCursor;
        }
        if (psiFile != null && this.myFileEditor instanceof TextEditor) {
            return psiFile.getViewProvider().findElementAt(((TextEditor)this.myFileEditor).getEditor().getCaretModel().getOffset());
        }
        return null;
    }

    public JComponent createCenterPanel() {
        ArrayList<FileStructureFilter> fileStructureFilters = new ArrayList<FileStructureFilter>();
        ArrayList<FileStructureNodeProvider> fileStructureNodeProviders = new ArrayList<FileStructureNodeProvider>();
        if (this.myTreeActionsOwner != null) {
            for (Filter filter2 : this.myTreeModel.getFilters()) {
                if (!(filter2 instanceof FileStructureFilter)) continue;
                FileStructureFilter fsFilter = (FileStructureFilter)filter2;
                this.myTreeActionsOwner.setActionIncluded((TreeAction)fsFilter, true);
                fileStructureFilters.add(fsFilter);
            }
            if (this.myTreeModel instanceof ProvidingTreeModel) {
                for (NodeProvider provider2 : ((ProvidingTreeModel)this.myTreeModel).getNodeProviders()) {
                    if (!(provider2 instanceof FileStructureNodeProvider)) continue;
                    fileStructureNodeProviders.add((FileStructureNodeProvider)provider2);
                }
            }
        }
        int checkBoxCount = fileStructureNodeProviders.size() + fileStructureFilters.size();
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setPreferredSize(JBUI.size(540, 500));
        JPanel chkPanel = new JPanel(new GridLayout(0, checkBoxCount > 0 && checkBoxCount % 4 == 0 ? checkBoxCount / 2 : 3, JBUIScale.scale(10), 0));
        chkPanel.setOpaque(false);
        Shortcut[] F4 = ActionManager.getInstance().getAction("EditSource").getShortcutSet().getShortcuts();
        Shortcut[] ENTER = CustomShortcutSet.fromString((String[])new String[]{"ENTER"}).getShortcuts();
        CustomShortcutSet shortcutSet = new CustomShortcutSet(ArrayUtil.mergeArrays(F4, ENTER));
        new NavigateSelectedElementAction(panel2).registerCustomShortcutSet((ShortcutSet)shortcutSet, panel2);
        DumbAwareAction.create(e -> {
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive()) {
                this.mySpeedSearch.hidePopup();
            } else {
                this.myPopup.cancel();
            }
        }).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ESCAPE"}), (JComponent)this.myTree);
        new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                TreePath path2;
                Rectangle bounds;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                Rectangle rectangle = bounds = (path2 = FileStructurePopup.this.myTree.getClosestPathForLocation(e.getX(), e.getY())) == null ? null : FileStructurePopup.this.myTree.getPathBounds(path2);
                if (bounds == null || bounds.x > e.getX() || bounds.y > e.getY() || bounds.y + bounds.height < e.getY()) {
                    return false;
                }
                FileStructurePopup.this.navigateSelectedElement();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/FileStructurePopup$5", "onClick"));
            }
        }.installOn((Component)this.myTree);
        for (FileStructureFilter filter3 : fileStructureFilters) {
            this.addCheckbox(chkPanel, (TreeAction)filter3);
        }
        for (FileStructureNodeProvider provider3 : fileStructureNodeProviders) {
            this.addCheckbox(chkPanel, (TreeAction)provider3);
        }
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)chkPanel, "West");
        topPanel.add((Component)this.createSettingsButton(), "East");
        topPanel.setBackground(JBUI.CurrentTheme.Popup.toolbarPanelColor());
        Dimension prefSize = topPanel.getPreferredSize();
        prefSize.height = JBUI.CurrentTheme.Popup.toolbarHeight();
        topPanel.setPreferredSize(prefSize);
        topPanel.setBorder(JBUI.Borders.emptyLeft(10));
        panel2.add((Component)topPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setBorder(IdeBorderFactory.createBorder((Color)JBUI.CurrentTheme.Popup.toolbarBorderColor(), (int)10));
        panel2.add((Component)scrollPane, "Center");
        DataManager.registerDataProvider((JComponent)panel2, dataId -> {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            if (PlatformCoreDataKeys.FILE_EDITOR.is(dataId)) {
                return this.myFileEditor;
            }
            if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId) && this.myFileEditor instanceof TextEditor) {
                return ((TextEditor)this.myFileEditor).getEditor();
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return this.getSelectedElements().filter(PsiElement.class).first();
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                return PsiUtilCore.toPsiElementArray(this.getSelectedElements().filter(PsiElement.class).toList());
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return this.getSelectedElements().filter(Navigatable.class).first();
            }
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                List<Navigatable> result2 = this.getSelectedElements().filter(Navigatable.class).toList();
                return result2.isEmpty() ? null : result2.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
            }
            if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
                return this.myPopup;
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return this.myCopyPasteDelegator.getCopyProvider();
            }
            if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
                return this.myTreeExpander;
            }
            return null;
        });
        panel2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileStructurePopup.this.myPopup.cancel();
            }
        });
        return panel2;
    }

    @NotNull
    private JBIterable<Object> getSelectedElements() {
        JBIterable<Object> jBIterable = JBIterable.of(this.myTree.getSelectionPaths()).filterMap(o -> StructureViewComponent.unwrapValue(o.getLastPathComponent()));
        if (jBIterable == null) {
            FileStructurePopup.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    private JComponent createSettingsButton() {
        final JLabel label2 = new JLabel(AllIcons.General.GearPlain);
        label2.setBorder(JBUI.Borders.empty(0, 4));
        label2.setHorizontalAlignment(4);
        label2.setVerticalAlignment(0);
        final List<AnAction> sorters = this.createSorters();
        new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    7.$$$reportNull$$$0(0);
                }
                DefaultActionGroup group = new DefaultActionGroup();
                if (!sorters.isEmpty()) {
                    group.addAll((Collection)sorters);
                    group.addSeparator();
                }
                group.add((AnAction)new ToggleNarrowDownAction());
                DataManager dataManager = DataManager.getInstance();
                ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataManager.getDataContext((Component)label2), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
                popup2.addListener(new JBPopupListener(){

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        FileStructurePopup.this.myCanClose = true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/FileStructurePopup$7$1", "onClosed"));
                    }
                });
                FileStructurePopup.this.myCanClose = false;
                popup2.showUnderneathOf((Component)label2);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/FileStructurePopup$7", "onClick"));
            }
        }.installOn(label2);
        JLabel jLabel = label2;
        if (jLabel == null) {
            FileStructurePopup.$$$reportNull$$$0(8);
        }
        return jLabel;
    }

    private List<AnAction> createSorters() {
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        for (Sorter sorter : this.myTreeModel.getSorters()) {
            if (!sorter.isVisible()) continue;
            actions2.add((AnAction)new MyTreeActionWrapper((TreeAction)sorter));
        }
        return actions2;
    }

    @Nullable
    private static Object findClosestPsiElement(@NotNull PsiElement element2, @NotNull TreePath adjusted, @NotNull javax.swing.tree.TreeModel treeModel) {
        TextRange range;
        if (element2 == null) {
            FileStructurePopup.$$$reportNull$$$0(9);
        }
        if (adjusted == null) {
            FileStructurePopup.$$$reportNull$$$0(10);
        }
        if (treeModel == null) {
            FileStructurePopup.$$$reportNull$$$0(11);
        }
        if ((range = element2.getTextRange()) == null) {
            return null;
        }
        Object parent = adjusted.getLastPathComponent();
        int minDistance = 0;
        Object minChild = null;
        int count2 = treeModel.getChildCount(parent);
        for (int i = 0; i < count2; ++i) {
            TextRange r;
            Object child = treeModel.getChild(parent, i);
            Object value = StructureViewComponent.unwrapValue(child);
            if (value instanceof StubBasedPsiElement && ((StubBasedPsiElement)value).getStub() != null) continue;
            TextRange textRange = r = value instanceof PsiElement ? ((PsiElement)value).getTextRange() : null;
            if (r == null) continue;
            int distance = TextRangeUtil.getDistance(range, r);
            if (minChild != null && distance >= minDistance) continue;
            minDistance = distance;
            minChild = child;
        }
        return minChild;
    }

    @Nullable
    private AbstractTreeNode getSelectedNode() {
        TreePath path2 = this.myTree.getSelectionPath();
        Object o = StructureViewComponent.unwrapNavigatable(path2 == null ? null : path2.getLastPathComponent());
        return o instanceof AbstractTreeNode ? (AbstractTreeNode)o : null;
    }

    private boolean navigateSelectedElement() {
        AbstractTreeNode selectedNode = this.getSelectedNode();
        if (ApplicationManager.getApplication().isInternal()) {
            String enteredPrefix = this.mySpeedSearch.getEnteredPrefix();
            String itemText = FileStructurePopup.getSpeedSearchText(selectedNode);
            if (StringUtil.isNotEmpty(enteredPrefix) && StringUtil.isNotEmpty(itemText)) {
                LOG.info("Chosen in file structure popup by prefix '" + enteredPrefix + "': '" + itemText + "'");
            }
        }
        Ref succeeded = new Ref();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            if (selectedNode != null) {
                if (selectedNode.canNavigateToSource()) {
                    selectedNode.navigate(true);
                    this.myPopup.cancel();
                    succeeded.set(true);
                } else {
                    succeeded.set(false);
                }
            } else {
                succeeded.set(false);
            }
            IdeDocumentHistory.getInstance((Project)this.myProject).includeCurrentCommandAsNavigation();
        }, LangBundle.message("command.name.navigate", new Object[0]), null);
        return (Boolean)succeeded.get();
    }

    private void addCheckbox(JPanel panel2, TreeAction action2) {
        Object text2;
        Object object = action2 instanceof FileStructureFilter ? ((FileStructureFilter)action2).getCheckBoxText() : (text2 = action2 instanceof FileStructureNodeProvider ? ((FileStructureNodeProvider)action2).getCheckBoxText() : null);
        if (text2 == null) {
            return;
        }
        Shortcut[] shortcuts = FileStructurePopup.extractShortcutFor(action2);
        JBCheckBox checkBox = new JBCheckBox();
        checkBox.setOpaque(false);
        UIUtil.applyStyle(UIUtil.ComponentStyle.SMALL, (Component)checkBox);
        boolean selected = FileStructurePopup.getDefaultValue(action2);
        checkBox.setSelected(selected);
        boolean isRevertedStructureFilter = action2 instanceof FileStructureFilter && ((FileStructureFilter)action2).isReverted();
        this.myTreeActionsOwner.setActionIncluded(action2, isRevertedStructureFilter != selected);
        checkBox.addActionListener(actionEvent -> {
            this.logFileStructureCheckboxClick(action2);
            boolean state = checkBox.isSelected();
            if (!this.myAutoClicked.contains(checkBox)) {
                FileStructurePopup.saveState(action2, state);
            }
            this.myTreeActionsOwner.setActionIncluded(action2, isRevertedStructureFilter != state);
            this.rebuild(false).onProcessed(ignore -> {
                if (this.mySpeedSearch.isPopupActive()) {
                    this.mySpeedSearch.refreshSelection();
                }
            });
        });
        checkBox.setFocusable(false);
        if (shortcuts.length > 0) {
            text2 = (String)text2 + " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ")";
            DumbAwareAction.create(e -> checkBox.doClick()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)this.myTree);
        }
        checkBox.setText((String)text2);
        panel2.add((Component)checkBox);
        this.myCheckBoxes.put(action2.getClass(), checkBox);
    }

    private void logFileStructureCheckboxClick(TreeAction action2) {
        Language language = null;
        FileType fileType = this.myFileEditor.getFile().getFileType();
        if (fileType instanceof LanguageFileType) {
            language = ((LanguageFileType)fileType).getLanguage();
        }
        ActionsEventLogGroup.ACTION_FINISHED.log(this.myProject, new EventPair[]{EventFields.PluginInfoFromInstance.with((Object)action2), EventFields.ActionPlace.with((Object)"FileStructurePopup"), EventFields.CurrentFile.with((Object)language), ActionsEventLogGroup.ACTION_CLASS.with((Object)action2.getClass().getName()), ActionsEventLogGroup.ACTION_ID.with((Object)action2.getClass().getName())});
    }

    @NotNull
    private Promise<Void> rebuild(boolean refilterOnly) {
        Object selection = JBIterable.of(this.myTree.getSelectionPaths()).filterMap(o -> StructureViewComponent.unwrapValue(o.getLastPathComponent())).first();
        Promise<Void> promise = this.rebuildAndSelect(refilterOnly, selection).then(o -> null);
        if (promise == null) {
            FileStructurePopup.$$$reportNull$$$0(12);
        }
        return promise;
    }

    @NotNull
    private Promise<TreePath> rebuildAndSelect(boolean refilterOnly, Object selection) {
        AsyncPromise result2 = new AsyncPromise();
        this.myStructureTreeModel.getInvoker().invoke(() -> {
            if (refilterOnly) {
                this.myFilteringStructure.refilter();
                this.myStructureTreeModel.invalidate().onSuccess(res -> (selection == null ? this.myAsyncTreeModel.accept(o -> TreeVisitor.Action.CONTINUE) : this.select(selection)).onError(ignore2 -> result2.setError("rejected")).onSuccess(p -> UIUtil.invokeLaterIfNeeded(() -> {
                    TreeUtil.expand((JTree)this.getTree(), (int)(this.myTreeModel instanceof StructureViewCompositeModel ? 3 : 2));
                    TreeUtil.ensureSelection((JTree)this.myTree);
                    this.mySpeedSearch.refreshSelection();
                    result2.setResult(p);
                })));
            } else {
                this.myTreeStructure.rebuildTree();
                this.myStructureTreeModel.invalidate().onSuccess(res -> this.rebuildAndSelect(true, selection).processed((Promise<TreePath>)result2));
            }
        });
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            FileStructurePopup.$$$reportNull$$$0(13);
        }
        return asyncPromise;
    }

    static Shortcut @NotNull [] extractShortcutFor(@NotNull TreeAction action2) {
        if (action2 == null) {
            FileStructurePopup.$$$reportNull$$$0(14);
        }
        if (action2 instanceof ActionShortcutProvider) {
            String actionId = ((ActionShortcutProvider)action2).getActionIdForShortcut();
            Shortcut[] shortcutArray = KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts();
            if (shortcutArray == null) {
                FileStructurePopup.$$$reportNull$$$0(15);
            }
            return shortcutArray;
        }
        Shortcut[] shortcutArray = action2 instanceof FileStructureFilter ? ((FileStructureFilter)action2).getShortcut() : ((FileStructureNodeProvider)action2).getShortcut();
        if (shortcutArray == null) {
            FileStructurePopup.$$$reportNull$$$0(16);
        }
        return shortcutArray;
    }

    private static boolean getDefaultValue(TreeAction action2) {
        String propertyName = action2 instanceof PropertyOwner ? ((PropertyOwner)action2).getPropertyName() : action2.getName();
        return PropertiesComponent.getInstance().getBoolean(TreeStructureUtil.getPropertyName((String)propertyName), Sorter.ALPHA_SORTER.equals(action2));
    }

    private static void saveState(TreeAction action2, boolean state) {
        String propertyName = action2 instanceof PropertyOwner ? ((PropertyOwner)action2).getPropertyName() : action2.getName();
        PropertiesComponent.getInstance().setValue(TreeStructureUtil.getPropertyName((String)propertyName), state, Sorter.ALPHA_SORTER.equals(action2));
    }

    public void setTitle(@NlsContexts.PopupTitle String title) {
        this.myTitle = title;
    }

    @NotNull
    public Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            FileStructurePopup.$$$reportNull$$$0(17);
        }
        return tree;
    }

    @TestOnly
    public TreeSpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    @TestOnly
    public void setSearchFilterForTests(String filter2) {
        this.myTestSearchFilter = filter2;
    }

    public void setTreeActionState(Class<? extends TreeAction> action2, boolean state) {
        JBCheckBox checkBox = this.myCheckBoxes.get(action2);
        if (checkBox != null) {
            checkBox.setSelected(state);
            for (ActionListener listener2 : checkBox.getActionListeners()) {
                listener2.actionPerformed(new ActionEvent(this, 1, ""));
            }
        }
    }

    @Nullable
    public static String getSpeedSearchText(Object object) {
        String text2 = String.valueOf(object);
        Object value = StructureViewComponent.unwrapWrapper(object);
        if (text2 != null) {
            String locationString;
            if (value instanceof PsiTreeElementBase && ((PsiTreeElementBase)value).isSearchInLocationString() && !StringUtil.isEmpty(locationString = ((PsiTreeElementBase)value).getLocationString())) {
                String locationPrefix = null;
                String locationSuffix = null;
                if (value instanceof LocationPresentation) {
                    locationPrefix = ((LocationPresentation)value).getLocationPrefix();
                    locationSuffix = ((LocationPresentation)value).getLocationSuffix();
                }
                return text2 + StringUtil.notNullize(locationPrefix, " (") + locationString + StringUtil.notNullize(locationSuffix, ")");
            }
            return text2;
        }
        if (value instanceof TreeElement) {
            return ReadAction.compute(() -> ((TreeElement)value).getPresentation().getPresentableText());
        }
        return null;
    }

    @Override
    public void setActionActive(String name2, boolean state) {
    }

    @Override
    public boolean isActionActive(String name2) {
        return false;
    }

    @Nullable
    private String getSearchPrefix() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myTestSearchFilter;
        }
        return this.mySpeedSearch != null && !StringUtil.isEmpty(this.mySpeedSearch.getEnteredPrefix()) ? this.mySpeedSearch.getEnteredPrefix() : null;
    }

    @Nullable
    private static SpeedSearchObjectWithWeight find(@NotNull PsiElement element2, @NotNull List<? extends SpeedSearchObjectWithWeight> objects, @NotNull BiPredicate<? super PsiElement, ? super TreePath> predicate) {
        if (element2 == null) {
            FileStructurePopup.$$$reportNull$$$0(18);
        }
        if (objects == null) {
            FileStructurePopup.$$$reportNull$$$0(19);
        }
        if (predicate == null) {
            FileStructurePopup.$$$reportNull$$$0(20);
        }
        return (SpeedSearchObjectWithWeight)ContainerUtil.find(objects, object -> predicate.test(element2, ObjectUtils.tryCast(object.node, TreePath.class)));
    }

    private static boolean isElement(@NotNull PsiElement element2, @Nullable TreePath path2) {
        if (element2 == null) {
            FileStructurePopup.$$$reportNull$$$0(21);
        }
        return element2.equals(StructureViewComponent.unwrapValue(TreeUtil.getLastUserObject(FilteringTreeStructure.FilteringNode.class, (TreePath)path2)));
    }

    private static boolean isParent(@NotNull PsiElement parent, @Nullable TreePath path2) {
        if (parent == null) {
            FileStructurePopup.$$$reportNull$$$0(22);
        }
        return path2 != null && FileStructurePopup.isElement(parent, path2.getParentPath());
    }

    private static boolean isAncestor(@NotNull PsiElement ancestor, @Nullable TreePath path2) {
        if (ancestor == null) {
            FileStructurePopup.$$$reportNull$$$0(23);
        }
        while (path2 != null) {
            if (FileStructurePopup.isElement(ancestor, path2)) {
                return true;
            }
            path2 = path2.getParentPath();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureView";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/FileStructurePopup";
                break;
            }
            case 9: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjusted";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/FileStructurePopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsButton";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuild";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuildAndSelect";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractShortcutFor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findClosestPsiElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractShortcutFor";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isParent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class ToggleNarrowDownAction
    extends ToggleAction {
        private ToggleNarrowDownAction() {
            super(IdeBundle.message((String)"checkbox.narrow.down.on.typing", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleNarrowDownAction.$$$reportNull$$$0(0);
            }
            return FileStructurePopup.isShouldNarrowDown();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleNarrowDownAction.$$$reportNull$$$0(1);
            }
            PropertiesComponent.getInstance().setValue(FileStructurePopup.NARROW_DOWN_PROPERTY_KEY, Boolean.toString(state));
            if (FileStructurePopup.this.mySpeedSearch.isPopupActive() && !StringUtil.isEmpty(FileStructurePopup.this.mySpeedSearch.getEnteredPrefix())) {
                FileStructurePopup.this.rebuild(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/FileStructurePopup$ToggleNarrowDownAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class NavigateSelectedElementAction
    extends DumbAwareAction {
        private final JPanel myPanel;

        private NavigateSelectedElementAction(JPanel panel2) {
            this.myPanel = panel2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean succeeded;
            if (e == null) {
                NavigateSelectedElementAction.$$$reportNull$$$0(0);
            }
            if (succeeded = FileStructurePopup.this.navigateSelectedElement()) {
                this.unregisterCustomShortcutSet(this.myPanel);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/FileStructurePopup$NavigateSelectedElementAction", "actionPerformed"));
        }
    }

    static class MyTree
    extends DnDAwareTree
    implements PlaceProvider {
        MyTree(javax.swing.tree.TreeModel treeModel) {
            super(treeModel);
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            HintUpdateSupply.installHintUpdateSupply((JComponent)((Object)this), o -> {
                Object value = StructureViewComponent.unwrapValue(o);
                return value instanceof PsiElement ? (PsiElement)value : null;
            });
        }

        public String getPlace() {
            return "StructureViewPopup";
        }
    }

    private class MyTreeSpeedSearch
    extends TreeSpeedSearch {
        MyTreeSpeedSearch() {
            super(FileStructurePopup.this.myTree, path2 -> FileStructurePopup.getSpeedSearchText(TreeUtil.getLastUserObject((TreePath)path2)), true);
        }

        protected Point getComponentLocationOnScreen() {
            return FileStructurePopup.this.myPopup.getContent().getLocationOnScreen();
        }

        protected Rectangle getComponentVisibleRect() {
            return FileStructurePopup.this.myPopup.getContent().getVisibleRect();
        }

        public Object findElement(@NotNull String s) {
            List elements;
            SpeedSearchObjectWithWeight best;
            if (s == null) {
                MyTreeSpeedSearch.$$$reportNull$$$0(0);
            }
            if ((best = (SpeedSearchObjectWithWeight)ContainerUtil.getFirstItem(elements = SpeedSearchObjectWithWeight.findElement((String)s, (SpeedSearchBase)this))) == null) {
                return null;
            }
            if (FileStructurePopup.this.myInitialElement instanceof PsiElement) {
                SpeedSearchObjectWithWeight bestSibling;
                PsiElement initial = (PsiElement)FileStructurePopup.this.myInitialElement;
                SpeedSearchObjectWithWeight bestForParent = FileStructurePopup.find(initial, elements, (x$0, x$1) -> FileStructurePopup.isParent(x$0, x$1));
                if (bestForParent != null) {
                    return bestForParent.node;
                }
                PsiElement parent = initial.getParent();
                if (parent != null && (bestSibling = FileStructurePopup.find(parent, elements, (x$0, x$1) -> FileStructurePopup.isParent(x$0, x$1))) != null) {
                    return bestSibling.node;
                }
                SpeedSearchObjectWithWeight bestForAncestor = FileStructurePopup.find(initial, elements, (x$0, x$1) -> FileStructurePopup.isAncestor(x$0, x$1));
                if (bestForAncestor != null) {
                    return bestForAncestor.node;
                }
            }
            return best.node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ide/util/FileStructurePopup$MyTreeSpeedSearch", "findElement"));
        }
    }

    private class FileStructurePopupFilter
    implements ElementFilter {
        private String myLastFilter;
        private final Set<Object> myVisibleParents = new HashSet<Object>();
        private final boolean isUnitTest = ApplicationManager.getApplication().isUnitTestMode();

        private FileStructurePopupFilter() {
        }

        public boolean shouldBeShowing(Object value) {
            if (!FileStructurePopup.isShouldNarrowDown()) {
                return true;
            }
            String filter2 = FileStructurePopup.this.getSearchPrefix();
            if (!StringUtil.equals(this.myLastFilter, filter2)) {
                this.myVisibleParents.clear();
                this.myLastFilter = filter2;
            }
            if (filter2 != null) {
                if (this.myVisibleParents.contains(value)) {
                    return true;
                }
                String text2 = FileStructurePopup.getSpeedSearchText(value);
                if (text2 == null) {
                    return false;
                }
                if (this.matches(filter2, text2)) {
                    Object o = value;
                    while (o instanceof FilteringTreeStructure.FilteringNode && (o = ((FilteringTreeStructure.FilteringNode)o).getParent()) != null) {
                        this.myVisibleParents.add(o);
                    }
                    return true;
                }
                return false;
            }
            return true;
        }

        private boolean matches(@NotNull String filter2, @NotNull String text2) {
            if (filter2 == null) {
                FileStructurePopupFilter.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                FileStructurePopupFilter.$$$reportNull$$$0(1);
            }
            return (this.isUnitTest || FileStructurePopup.this.mySpeedSearch.isPopupActive()) && StringUtil.isNotEmpty(filter2) && FileStructurePopup.this.mySpeedSearch.getComparator().matchingFragments(filter2, text2) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/util/FileStructurePopup$FileStructurePopupFilter";
            objectArray[2] = "matches";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyTreeActionWrapper
    extends TreeActionWrapper {
        private final TreeAction myAction;

        MyTreeActionWrapper(TreeAction action2) {
            super(action2, FileStructurePopup.this.myTreeActionsOwner);
            this.myAction = action2;
            FileStructurePopup.this.myTreeActionsOwner.setActionIncluded(action2, FileStructurePopup.getDefaultValue(action2));
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyTreeActionWrapper.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setIcon(null);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyTreeActionWrapper.$$$reportNull$$$0(1);
            }
            boolean actionState = TreeModelWrapper.shouldRevert(this.myAction) != state;
            FileStructurePopup.this.myTreeActionsOwner.setActionIncluded(this.myAction, actionState);
            FileStructurePopup.saveState(this.myAction, state);
            FileStructurePopup.this.rebuild(false).onProcessed(ignore -> {
                if (FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                    FileStructurePopup.this.mySpeedSearch.refreshSelection();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/FileStructurePopup$MyTreeActionWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

