/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.DefaultModuleRendererFactory;
import com.intellij.util.TextWithIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PsiElementModuleRenderer
extends DefaultListCellRenderer {
    private final @NotNull Function<Object, @Nullable TextWithIcon> myTextWithIconProvider;
    @Nls
    private String myText;

    PsiElementModuleRenderer(@NotNull Function<Object, @Nullable TextWithIcon> provider2) {
        if (provider2 == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(0);
        }
        this.myTextWithIconProvider = provider2;
    }

    @Deprecated(forRemoval=true)
    public PsiElementModuleRenderer() {
        this(new DefaultModuleRendererFactory()::getModuleTextWithIcon);
    }

    @Override
    public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component listCellRendererComponent = super.getListCellRendererComponent((JList<?>)list2, (Object)null, index, isSelected, cellHasFocus);
        this.customizeCellRenderer(value, isSelected);
        return listCellRendererComponent;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    private void customizeCellRenderer(Object value, boolean selected) {
        this.myText = "";
        TextWithIcon textWithIcon = this.myTextWithIconProvider.apply(value);
        if (textWithIcon != null) {
            this.myText = textWithIcon.getText();
            this.setIcon(textWithIcon.getIcon());
        } else {
            this.myText = "";
        }
        this.setText(this.myText);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, UIUtil.getListCellHPadding()));
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(4);
        this.setBackground(selected ? UIUtil.getListSelectionBackground(true) : UIUtil.getListBackground());
        this.setForeground(selected ? UIUtil.getListSelectionForeground(true) : UIUtil.getInactiveTextColor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/util/PsiElementModuleRenderer", "<init>"));
    }
}

