/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameFilterConfiguration;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseByNameFilter<T> {
    private final ChooseByNamePopup myParentPopup;
    private final ActionToolbar myToolbar;
    private final ElementsChooser<T> myChooser;
    private final JPanel myChooserPanel;
    private JBPopup myPopup;
    private final Project myProject;

    public ChooseByNameFilter(@NotNull ChooseByNamePopup popup2, @NotNull FilteringGotoByModel<T> model2, final @NotNull ChooseByNameFilterConfiguration<T> filterConfiguration, @NotNull Project project2) {
        if (popup2 == null) {
            ChooseByNameFilter.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            ChooseByNameFilter.$$$reportNull$$$0(1);
        }
        if (filterConfiguration == null) {
            ChooseByNameFilter.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            ChooseByNameFilter.$$$reportNull$$$0(3);
        }
        this.myParentPopup = popup2;
        DefaultActionGroup actionGroup = DefaultActionGroup.createFlatGroup(() -> "go.to.file.filter");
        FilterAction action2 = new FilterAction(){

            @Override
            protected boolean isActive() {
                return !filterConfiguration.getState().getFilteredOutFileTypeNames().isEmpty();
            }
        };
        actionGroup.add((AnAction)action2);
        this.myToolbar = ActionManager.getInstance().createActionToolbar("gotfile.filter", (ActionGroup)actionGroup, true);
        this.myToolbar.setLayoutPolicy(0);
        this.myToolbar.getComponent().setFocusable(false);
        this.myToolbar.getComponent().setBorder(null);
        this.myProject = project2;
        this.myChooser = this.createChooser(model2, filterConfiguration);
        this.myChooserPanel = this.createChooserPanel();
        popup2.setToolArea(this.myToolbar.getComponent());
    }

    private JPanel createChooserPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add((Component)this.myChooser);
        JPanel buttons = new JPanel();
        JButton all = new JButton(LangBundle.message("label.all", new Object[0]));
        all.addActionListener(__ -> this.myChooser.setAllElementsMarked(true));
        buttons.add(all);
        JButton none2 = new JButton(LangBundle.message("label.none", new Object[0]));
        none2.addActionListener(__ -> this.myChooser.setAllElementsMarked(false));
        buttons.add(none2);
        JButton invert = new JButton(LangBundle.message("label.invert", new Object[0]));
        invert.addActionListener(__ -> this.myChooser.invertSelection());
        buttons.add(invert);
        panel2.add(buttons);
        return panel2;
    }

    @NotNull
    protected ElementsChooser<T> createChooser(@NotNull FilteringGotoByModel<T> model2, @NotNull ChooseByNameFilterConfiguration<? super T> filterConfiguration) {
        if (model2 == null) {
            ChooseByNameFilter.$$$reportNull$$$0(4);
        }
        if (filterConfiguration == null) {
            ChooseByNameFilter.$$$reportNull$$$0(5);
        }
        ArrayList<T> elements = new ArrayList<T>(this.getAllFilterValues());
        ElementsChooser chooser2 = new ElementsChooser<T>(elements, true){

            protected String getItemText(@NotNull T value) {
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                return ChooseByNameFilter.this.textForFilterValue(value);
            }

            protected Icon getItemIcon(@NotNull T value) {
                if (value == null) {
                    2.$$$reportNull$$$0(1);
                }
                return ChooseByNameFilter.this.iconForFilterValue(value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNameFilter$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getItemText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getItemIcon";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        chooser2.setFocusable(false);
        int count2 = chooser2.getElementCount();
        for (int i = 0; i < count2; ++i) {
            Object type = chooser2.getElementAt(i);
            if (DumbService.getInstance(this.myProject).isDumb() || filterConfiguration.isVisible(type)) continue;
            chooser2.setElementMarked(type, false);
        }
        this.updateModel(model2, chooser2, true);
        chooser2.addElementsMarkListener((arg_0, arg_1) -> this.lambda$createChooser$4(filterConfiguration, model2, (ElementsChooser)chooser2, arg_0, arg_1));
        ElementsChooser elementsChooser = chooser2;
        if (elementsChooser == null) {
            ChooseByNameFilter.$$$reportNull$$$0(6);
        }
        return elementsChooser;
    }

    @NlsSafe
    protected abstract String textForFilterValue(@NotNull T var1);

    @Nullable
    protected abstract Icon iconForFilterValue(@NotNull T var1);

    @NotNull
    protected abstract Collection<T> getAllFilterValues();

    protected void updateModel(@NotNull FilteringGotoByModel<T> gotoFileModel, @NotNull ElementsChooser<T> chooser2, boolean initial) {
        if (gotoFileModel == null) {
            ChooseByNameFilter.$$$reportNull$$$0(7);
        }
        if (chooser2 == null) {
            ChooseByNameFilter.$$$reportNull$$$0(8);
        }
        List markedElements = chooser2.getMarkedElements();
        gotoFileModel.setFilterItems(markedElements);
        this.myParentPopup.rebuildList(initial);
    }

    private void createPopup() {
        if (this.myPopup != null) {
            return;
        }
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myChooserPanel, this.myChooser).setModalContext(false).setFocusable(false).setResizable(true).setCancelOnClickOutside(false).setMinSize(new Dimension(200, 200)).setDimensionServiceKey(this.myProject, "GotoFile_FileTypePopup", false).createPopup();
        this.myPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                ChooseByNameFilter.this.myPopup = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/gotoByName/ChooseByNameFilter$3", "onClosed"));
            }
        });
        this.myPopup.showUnderneathOf((Component)this.myToolbar.getComponent());
    }

    public void close() {
        if (this.myPopup != null) {
            Disposer.dispose((Disposable)this.myPopup);
        }
    }

    private /* synthetic */ void lambda$createChooser$4(ChooseByNameFilterConfiguration filterConfiguration, FilteringGotoByModel model2, ElementsChooser chooser2, Object element2, boolean isMarked) {
        filterConfiguration.setVisible(element2, isMarked);
        this.updateModel(model2, chooser2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/ChooseByNameFilter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoFileModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNameFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createChooser";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class FilterAction
    extends ToggleAction
    implements DumbAware {
        FilterAction() {
            super(IdeBundle.messagePointer((String)"action.ToggleAction.text.filter", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.ToggleAction.text.filter.files.by.type", (Object[])new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(0);
            }
            return ChooseByNameFilter.this.myPopup != null;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(1);
            }
            if (state) {
                ChooseByNameFilter.this.createPopup();
            } else {
                ChooseByNameFilter.this.close();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(2);
            }
            Icon icon2 = this.getTemplatePresentation().getIcon();
            e.getPresentation().setIcon(this.isActive() ? ExecutionUtil.getLiveIndicator((Icon)icon2) : icon2);
        }

        protected boolean isActive() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNameFilter$FilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

