/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.gotoByName.ChooseByNameItem;
import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListChooseByNameModel<T extends ChooseByNameItem>
extends SimpleChooseByNameModel {
    private static final int MAX_DESC_LENGTH = 80;
    private static final String ELLIPSIS_SUFFIX = "...";
    private Pattern myCompiledPattern;
    @NlsSafe
    private String myPattern;
    private final List<? extends T> myItems;
    private final @NlsContexts.Label String myNotInMessage;

    public ListChooseByNameModel(@NotNull Project project2, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String prompt, @NotNull @NlsContexts.Label String notInMessage, @NotNull List<? extends T> items) {
        if (project2 == null) {
            ListChooseByNameModel.$$$reportNull$$$0(0);
        }
        if (prompt == null) {
            ListChooseByNameModel.$$$reportNull$$$0(1);
        }
        if (notInMessage == null) {
            ListChooseByNameModel.$$$reportNull$$$0(2);
        }
        if (items == null) {
            ListChooseByNameModel.$$$reportNull$$$0(3);
        }
        super(project2, prompt, null);
        this.myItems = items;
        this.myNotInMessage = notInMessage;
    }

    @Override
    public String[] getNames() {
        ArrayList<String> taskFullCmds = new ArrayList<String>();
        for (ChooseByNameItem item : this.myItems) {
            taskFullCmds.add(item.getName());
        }
        return ArrayUtilRt.toStringArray(taskFullCmds);
    }

    @Override
    protected Object[] getElementsByName(String name2, String pattern) {
        for (ChooseByNameItem item : this.myItems) {
            if (!item.getName().equals(name2)) continue;
            return new Object[]{item};
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public String getNotInMessage() {
        String string2 = this.myNotInMessage;
        if (string2 == null) {
            ListChooseByNameModel.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getNotFoundMessage() {
        String string2 = this.myNotInMessage;
        if (string2 == null) {
            ListChooseByNameModel.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    @NotNull
    public ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setOpaque(true);
                panel2.setBorder(JBUI.Borders.emptyRight(5));
                Color bg = isSelected ? UIUtil.getListSelectionBackground(true) : UIUtil.getListBackground();
                panel2.setBackground(bg);
                if (value instanceof ChooseByNameItem) {
                    ChooseByNameItem item = (ChooseByNameItem)value;
                    Color fg = isSelected ? UIUtil.getListSelectionForeground(true) : UIUtil.getListForeground();
                    JLabel actionLabel = new JLabel(item.getName(), null, 2);
                    actionLabel.setBackground(bg);
                    actionLabel.setForeground(fg);
                    actionLabel.setFont(actionLabel.getFont().deriveFont(1));
                    actionLabel.setBorder(JBUI.Borders.emptyLeft(4));
                    panel2.add((Component)actionLabel, "West");
                    String description = item.getDescription();
                    if (description != null) {
                        Object normalizedDesc = description.length() > 80 ? description.substring(0, 80) + ListChooseByNameModel.ELLIPSIS_SUFFIX : description;
                        JLabel descriptionLabel = new JLabel((String)normalizedDesc);
                        descriptionLabel.setBackground(bg);
                        descriptionLabel.setForeground(fg);
                        descriptionLabel.setBorder(JBUI.Borders.emptyLeft(15));
                        panel2.add((Component)descriptionLabel, "East");
                    }
                } else {
                    @NlsSafe String text2 = value.toString();
                    JLabel actionLabel = new JLabel(text2, null, 2);
                    actionLabel.setBackground(bg);
                    actionLabel.setForeground(UIUtil.getListForeground());
                    actionLabel.setFont(actionLabel.getFont().deriveFont(0));
                    actionLabel.setBorder(JBUI.Borders.emptyLeft(4));
                    panel2.add((Component)actionLabel, "West");
                }
                return panel2;
            }
        };
    }

    @Override
    public String getElementName(@NotNull Object element2) {
        if (element2 == null) {
            ListChooseByNameModel.$$$reportNull$$$0(6);
        }
        if (!(element2 instanceof ChooseByNameItem)) {
            return null;
        }
        return ((ChooseByNameItem)element2).getName();
    }

    public boolean matches(@NotNull String name2, @NotNull String pattern) {
        Pattern compiledPattern;
        if (name2 == null) {
            ListChooseByNameModel.$$$reportNull$$$0(7);
        }
        if (pattern == null) {
            ListChooseByNameModel.$$$reportNull$$$0(8);
        }
        if ((compiledPattern = this.getTaskPattern(pattern)) == null) {
            return false;
        }
        return new Perl5Matcher().matches(name2, compiledPattern);
    }

    @Nullable
    private Pattern getTaskPattern(String pattern) {
        if (!Comparing.strEqual(pattern, this.myPattern)) {
            this.myCompiledPattern = null;
            this.myPattern = pattern;
        }
        if (this.myCompiledPattern == null) {
            String regex = "^.*" + NameUtil.buildRegexp((String)pattern, (int)0, (boolean)true, (boolean)true);
            Perl5Compiler compiler = new Perl5Compiler();
            try {
                this.myCompiledPattern = compiler.compile(regex);
            }
            catch (MalformedPatternException malformedPatternException) {
                // empty catch block
            }
        }
        return this.myCompiledPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notInMessage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/ListChooseByNameModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/ListChooseByNameModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotInMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

