/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.TrustedPaths;
import com.intellij.ide.util.projectWizard.CustomStepProjectGenerator;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.actions.ProjectSpecificAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionsWithPanelProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.HideableProjectGenerator;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.TemplateProjectDirectoryGenerator;
import com.intellij.util.PairConsumer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNewProjectStep<T>
extends DefaultActionGroup
implements DumbAware,
ActionsWithPanelProvider {
    public static final ExtensionPointName<DirectoryProjectGenerator<?>> EP_NAME = new ExtensionPointName("com.intellij.directoryProjectGenerator");
    private static final Logger LOG = Logger.getInstance(AbstractNewProjectStep.class);
    private static final Key<Boolean> CREATED_KEY = new Key("abstract.new.project.step.created");
    private final Customization<T> myCustomization;

    protected AbstractNewProjectStep(@NotNull Customization<T> customization) {
        if (customization == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(0);
        }
        super(Presentation.NULL_STRING, true);
        this.myCustomization = customization;
        this.updateActions();
        EP_NAME.addChangeListener(() -> this.updateActions(), null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(1);
        }
        super.update(e);
        NewWelcomeScreen.updateNewProjectIconIfWelcomeScreen((AnActionEvent)e);
        this.updateActions();
    }

    protected void updateActions() {
        List<DirectoryProjectGenerator<?>> projectGenerators;
        this.removeAll();
        AbstractCallback<T> callback = this.myCustomization.createCallback();
        ProjectSpecificAction projectSpecificAction = this.myCustomization.createProjectSpecificAction(callback);
        this.addProjectSpecificAction(projectSpecificAction);
        List<DirectoryProjectGenerator<?>> generators = this.myCustomization.getProjectGenerators();
        this.addAll(this.myCustomization.getActions(generators, callback));
        if (!this.myCustomization.showUserDefinedProjects()) {
            return;
        }
        ProjectTemplate[] templates = new ArchivedTemplatesFactory().createTemplates("User-defined");
        if (templates.length == 0) {
            projectGenerators = Collections.emptyList();
        } else {
            projectGenerators = new ArrayList(templates.length);
            for (ProjectTemplate template : templates) {
                projectGenerators.add((DirectoryProjectGenerator<?>)new TemplateProjectDirectoryGenerator((LocalArchivedTemplate)template));
            }
        }
        this.addAll(this.myCustomization.getActions(projectGenerators, callback));
    }

    protected void addProjectSpecificAction(@NotNull ProjectSpecificAction projectSpecificAction) {
        if (projectSpecificAction == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(2);
        }
        this.addAll(projectSpecificAction.getChildren(null));
    }

    public static <T> Project doGenerateProject(@Nullable Project projectToClose, @NotNull String locationString, @Nullable DirectoryProjectGenerator<T> generator, @NotNull T settings) {
        if (locationString == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(4);
        }
        OpenProjectTask options = OpenProjectTask.build().withProjectToClose(projectToClose).asNewProject().withRunConfigurators().withCreatedByWizard().withoutVfsRefresh().withBeforeOpenCallback(project2 -> {
            project2.putUserData(CREATED_KEY, true);
            return true;
        });
        return AbstractNewProjectStep.doGenerateProject(projectToClose, locationString, generator, settings, options);
    }

    public static <T> Project doGenerateProject(@Nullable Project projectToClose, @NotNull String locationString, @Nullable DirectoryProjectGenerator<T> generator, @NotNull T settings, @NotNull OpenProjectTask options) {
        if (locationString == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(6);
        }
        if (options == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(7);
        }
        Path location = Paths.get(locationString, new String[0]);
        try {
            Files.createDirectories(location, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.warn(e);
            String message2 = ActionsBundle.message((String)"action.NewDirectoryProject.cannot.create.dir", (Object[])new Object[]{location.toString()});
            Messages.showErrorDialog((Project)projectToClose, (String)message2, (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]));
            return null;
        }
        VirtualFile baseDir = WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName(location.toString())));
        if (baseDir == null) {
            LOG.error("Couldn't find '" + location + "' in VFS");
            return null;
        }
        VfsUtil.markDirtyAndRefresh(false, true, true, baseDir);
        if (baseDir.getChildren().length > 0) {
            String noText;
            String yesText;
            String title = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.title", (Object[])new Object[0]);
            String message3 = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.text", (Object[])new Object[]{location.toString()});
            int result2 = Messages.showYesNoDialog((Project)projectToClose, (String)message3, (String)title, (String)(yesText = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.create.new", (Object[])new Object[0])), (String)(noText = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.open.existing", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon());
            if (result2 == 1) {
                return PlatformProjectOpenProcessor.doOpenProject((Path)location, (OpenProjectTask)new OpenProjectTask());
            }
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(location.getParent());
        if (generator instanceof TemplateProjectDirectoryGenerator) {
            ((TemplateProjectDirectoryGenerator)generator).generateProject(baseDir.getName(), locationString);
        }
        TrustedPaths.getInstance().setProjectPathTrusted(location, true);
        Project project2 = ProjectManagerEx.getInstanceEx().openProject(location, options);
        if (project2 != null && generator != null && !(generator instanceof TemplateProjectDirectoryGenerator)) {
            generator.generateProject(project2, baseDir, settings, ModuleManager.getInstance(project2).getModules()[0]);
        }
        AbstractNewProjectStep.logProjectGeneratedEvent(generator, project2);
        return project2;
    }

    private static void logProjectGeneratedEvent(@Nullable DirectoryProjectGenerator<?> generator, @Nullable Project project2) {
        FeatureUsageData data2 = new FeatureUsageData();
        if (generator != null) {
            data2.addData("generator_id", generator.getClass().getName());
            data2.addPluginInfo(PluginInfoDetectorKt.getPluginInfo(generator.getClass()));
        }
        FUCounterUsageLogger.getInstance().logEvent(project2, "new.project.wizard", "project.generated", data2);
    }

    public static boolean created(@NotNull Project project2) {
        if (project2 == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(8);
        }
        return Boolean.TRUE.equals(project2.getUserData(CREATED_KEY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customization";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSpecificAction";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationString";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/projectWizard/AbstractNewProjectStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addProjectSpecificAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doGenerateProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "created";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AbstractCallback<T>
    implements PairConsumer<ProjectSettingsStepBase<T>, ProjectGeneratorPeer<T>> {
        @Override
        public void consume(@Nullable ProjectSettingsStepBase<T> settings, @NotNull ProjectGeneratorPeer<T> projectGeneratorPeer) {
            if (projectGeneratorPeer == null) {
                AbstractCallback.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                return;
            }
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            Project projectToClose = frame != null ? frame.getProject() : null;
            DirectoryProjectGenerator<T> generator = settings.getProjectGenerator();
            Object actualSettings = projectGeneratorPeer.getSettings();
            AbstractNewProjectStep.doGenerateProject(projectToClose, settings.getProjectLocation(), generator, actualSettings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectGeneratorPeer", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$AbstractCallback", "consume"));
        }
    }

    protected static abstract class Customization<T> {
        protected Customization() {
        }

        @NotNull
        protected ProjectSpecificAction createProjectSpecificAction(@NotNull AbstractCallback<T> callback) {
            if (callback == null) {
                Customization.$$$reportNull$$$0(0);
            }
            DirectoryProjectGenerator<T> emptyProjectGenerator = this.createEmptyProjectGenerator();
            return new ProjectSpecificAction(emptyProjectGenerator, this.createProjectSpecificSettingsStep(emptyProjectGenerator, callback));
        }

        @NotNull
        protected abstract AbstractCallback<T> createCallback();

        @NotNull
        protected abstract DirectoryProjectGenerator<T> createEmptyProjectGenerator();

        @NotNull
        protected abstract ProjectSettingsStepBase<T> createProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator<T> var1, @NotNull AbstractCallback<T> var2);

        @NotNull
        protected List<DirectoryProjectGenerator<?>> getProjectGenerators() {
            List<DirectoryProjectGenerator<?>> list2 = EP_NAME.getExtensionList();
            if (list2 == null) {
                Customization.$$$reportNull$$$0(1);
            }
            return list2;
        }

        public AnAction[] getActions(@NotNull List<DirectoryProjectGenerator<?>> generators, @NotNull AbstractCallback<T> callback) {
            if (generators == null) {
                Customization.$$$reportNull$$$0(2);
            }
            if (callback == null) {
                Customization.$$$reportNull$$$0(3);
            }
            ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
            for (DirectoryProjectGenerator<?> projectGenerator : generators) {
                try {
                    actions2.addAll(Arrays.asList(this.getActions(projectGenerator, callback)));
                }
                catch (Throwable throwable) {
                    LOG.error("Broken project generator " + projectGenerator, throwable);
                }
            }
            return actions2.toArray(AnAction.EMPTY_ARRAY);
        }

        public AnAction @NotNull [] getActions(@NotNull DirectoryProjectGenerator<T> generator, @NotNull AbstractCallback<T> callback) {
            if (generator == null) {
                Customization.$$$reportNull$$$0(4);
            }
            if (callback == null) {
                Customization.$$$reportNull$$$0(5);
            }
            if (this.shouldIgnore(generator)) {
                if (AnAction.EMPTY_ARRAY == null) {
                    Customization.$$$reportNull$$$0(6);
                }
                return AnAction.EMPTY_ARRAY;
            }
            ProjectSettingsStepBase step = generator instanceof CustomStepProjectGenerator ? (ProjectSettingsStepBase)((CustomStepProjectGenerator)generator).createStep(generator, callback) : this.createProjectSpecificSettingsStep(generator, callback);
            ProjectSpecificAction projectSpecificAction = new ProjectSpecificAction(generator, step);
            AnAction[] anActionArray = projectSpecificAction.getChildren(null);
            if (anActionArray == null) {
                Customization.$$$reportNull$$$0(7);
            }
            return anActionArray;
        }

        protected boolean shouldIgnore(@NotNull DirectoryProjectGenerator<?> generator) {
            if (generator == null) {
                Customization.$$$reportNull$$$0(8);
            }
            return generator instanceof HideableProjectGenerator && ((HideableProjectGenerator)generator).isHidden();
        }

        public boolean showUserDefinedProjects() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generators";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectGenerators";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createProjectSpecificAction";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getActions";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldIgnore";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

