/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ComputeVirtualFileNameStatAction
extends AnAction
implements DumbAware {
    Object2IntOpenHashMap<String> suffixes = new Object2IntOpenHashMap();
    Object2IntOpenHashMap<String> nameCount = new Object2IntOpenHashMap();

    ComputeVirtualFileNameStatAction() {
        super(ActionsBundle.messagePointer((String)"action.ComputeVirtualFileNameStatAction.text", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ComputeVirtualFileNameStatAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] roots2;
        if (e == null) {
            ComputeVirtualFileNameStatAction.$$$reportNull$$$0(1);
        }
        long start2 = System.currentTimeMillis();
        this.suffixes.clear();
        this.nameCount.clear();
        for (VirtualFile virtualFile2 : roots2 = ManagingFS.getInstance().getRoots(LocalFileSystem.getInstance())) {
            this.compute(virtualFile2);
        }
        ArrayList<Pair<String, Integer>> names = new ArrayList<Pair<String, Integer>>(this.nameCount.size());
        for (Object2IntMap.Entry entry : this.nameCount.object2IntEntrySet()) {
            names.add(new Pair<String, Integer>((String)entry.getKey(), entry.getIntValue()));
        }
        names.sort((o1, o2) -> (Integer)o2.second - (Integer)o1.second);
        System.out.println("Most frequent names (" + names.size() + " total):");
        int saveByIntern = 0;
        for (Pair pair : names) {
            int count2 = (Integer)pair.second;
            String name2 = (String)pair.first;
            System.out.println(name2 + " -> " + count2);
            saveByIntern += count2 * name2.length();
            if (count2 != 1) continue;
            break;
        }
        System.out.println("Total save if names were interned: " + saveByIntern + "; ------------");
        System.out.println("Suffix counts:(" + this.suffixes.size() + " total)");
        ComputeVirtualFileNameStatAction.show(this.suffixes);
        Object2IntOpenHashMap<String> save = new Object2IntOpenHashMap<String>();
        for (Object2IntMap.Entry entry : this.suffixes.object2IntEntrySet()) {
            save.put((String)entry.getKey(), entry.getIntValue() * ((String)entry.getKey()).length());
        }
        System.out.println("Supposed save by stripping suffixes: (" + save.size() + " total)");
        List<Pair<String, Integer>> list2 = ComputeVirtualFileNameStatAction.show(save);
        ArrayList<String> picked = new ArrayList<String>();
        while (picked.size() != 15) {
            Pair<String, Integer> cp = list2.get(0);
            String candidate = (String)cp.first;
            picked.add(candidate);
            System.out.println("Candidate: '" + candidate + "', save = " + cp.second);
            picked.sort((o1, o2) -> o2.length() - o1.length());
            list2.clear();
            for (Object2IntMap.Entry entry : this.suffixes.object2IntEntrySet()) {
                String s2 = (String)entry.getKey();
                int count3 = entry.getIntValue();
                for (int i = picked.size() - 1; i >= 0; --i) {
                    String pick = (String)picked.get(i);
                    if (!pick.endsWith(s2)) continue;
                    count3 -= this.suffixes.getInt(pick);
                    break;
                }
                list2.add(Pair.create(s2, s2.length() * count3));
            }
            list2.sort((o1, o2) -> ((Integer)o2.second).compareTo((Integer)o1.second));
        }
        System.out.println("Picked: " + StringUtil.join(picked, s -> "\"" + s + "\"", ","));
        picked.sort((o1, o2) -> o2.length() - o1.length());
        int saved = 0;
        for (int i = 0; i < picked.size(); ++i) {
            String s3 = (String)picked.get(i);
            int count4 = this.suffixes.getInt(s3);
            for (int k = 0; k < i; ++k) {
                String prev = (String)picked.get(k);
                if (!prev.endsWith(s3)) continue;
                count4 -= this.suffixes.getInt(prev);
                break;
            }
            saved += count4 * s3.length();
        }
        System.out.println("total saved = " + saved);
        System.out.println("Time spent: " + (System.currentTimeMillis() - start2));
    }

    private static List<Pair<String, Integer>> show(Object2IntMap<String> prefixes) {
        ArrayList<Pair<String, Integer>> prefs = new ArrayList<Pair<String, Integer>>(prefixes.size());
        for (Object2IntMap.Entry entry : prefixes.object2IntEntrySet()) {
            prefs.add(new Pair<String, Integer>((String)entry.getKey(), entry.getIntValue()));
        }
        prefs.sort((o1, o2) -> ((Integer)o2.second).compareTo((Integer)o1.second));
        int i = 0;
        for (Pair pair : prefs) {
            Integer count2 = (Integer)pair.second;
            System.out.printf("%60.60s : %d\n", pair.first, count2);
            if (i++ <= 100) continue;
            System.out.println("\n.......<" + count2 + "...\n");
            break;
        }
        return prefs;
    }

    private void compute(VirtualFile root) {
        String name2 = root.getName();
        this.nameCount.addTo(name2, 1);
        for (int i = 1; i <= name2.length(); ++i) {
            String suffix = name2.substring(name2.length() - i);
            this.suffixes.addTo(suffix, 1);
        }
        Collection cachedChildren = ((VirtualFileSystemEntry)root).getCachedChildren();
        for (VirtualFile cachedChild : cachedChildren) {
            this.compute(cachedChild);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/ComputeVirtualFileNameStatAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/ComputeVirtualFileNameStatAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

