/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

final class DumpDirectoryInfoAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(DumpDirectoryInfoAction.class);

    DumpDirectoryInfoAction() {
        super(ActionsBundle.messagePointer((String)"action.DumpDirectoryInfoAction.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            DumpDirectoryInfoAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) != null) {
            DirectoryIndex index = DirectoryIndex.getInstance(project2);
            VirtualFile root = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ContentIterator contentIterator = fileOrDir -> {
                    LOG.info(fileOrDir.getPath());
                    LOG.info(index.getInfoForFile(fileOrDir).toString());
                    return true;
                };
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
                if (root != null) {
                    fileIndex.iterateContentUnderDirectory(root, contentIterator);
                } else {
                    fileIndex.iterateContent(contentIterator);
                }
            }, "Dumping directory index", true, project2);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DumpDirectoryInfoAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpDirectoryInfoAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/DumpDirectoryInfoAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/DumpDirectoryInfoAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

