/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.ResourceUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

final class DumpInspectionDescriptionsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DumpInspectionDescriptionsAction.class);

    DumpInspectionDescriptionsAction() {
        super(ActionsBundle.messagePointer((String)"action.DumpInspectionDescriptionsAction.text", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DumpInspectionDescriptionsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Path groupsFile;
        boolean groupsOk;
        if (event == null) {
            DumpInspectionDescriptionsAction.$$$reportNull$$$0(1);
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance().getCurrentProfile();
        final TreeSet<String> classes = new TreeSet<String>();
        final TreeMap<String, TreeSet<String>> groups2 = new TreeMap<String, TreeSet<String>>();
        String tempDirectory = FileUtil.getTempDirectory();
        File descDirectory = new File(tempDirectory, "inspections");
        if (!descDirectory.mkdirs() && !descDirectory.isDirectory()) {
            LOG.error("Unable to create directory: " + descDirectory.getAbsolutePath());
            return;
        }
        for (InspectionToolWrapper<?, ?> toolWrapper : profile.getInspectionTools(null)) {
            classes.add(DumpInspectionDescriptionsAction.getInspectionClass(toolWrapper).getName());
            String group = DumpInspectionDescriptionsAction.getGroupName(toolWrapper);
            TreeSet<String> names = (TreeSet<String>)groups2.get(group);
            if (names == null) {
                names = new TreeSet<String>();
                groups2.put(group, names);
            }
            names.add(toolWrapper.getShortName());
            final InputStream stream = DumpInspectionDescriptionsAction.getDescriptionStream(toolWrapper);
            if (stream == null) continue;
            DumpInspectionDescriptionsAction.doDump(descDirectory.toPath().resolve(toolWrapper.getShortName() + ".html"), new Processor(){

                @Override
                public void process(BufferedWriter writer) throws Exception {
                    writer.write(ResourceUtil.loadText(stream));
                }
            });
        }
        DumpInspectionDescriptionsAction.doNotify("Inspection descriptions dumped to\n" + descDirectory.getAbsolutePath());
        Path fqnListFile = Path.of(tempDirectory, "inspection_fqn_list.txt");
        boolean fqnOk = DumpInspectionDescriptionsAction.doDump(fqnListFile, new Processor(){

            @Override
            public void process(BufferedWriter writer) throws Exception {
                for (String name2 : classes) {
                    writer.write(name2);
                    writer.newLine();
                }
            }
        });
        if (fqnOk) {
            DumpInspectionDescriptionsAction.doNotify("Inspection class names dumped to\n" + fqnListFile);
        }
        if (groupsOk = DumpInspectionDescriptionsAction.doDump(groupsFile = Path.of(tempDirectory, "inspection_groups.txt"), new Processor(){

            @Override
            public void process(BufferedWriter writer) throws Exception {
                for (Map.Entry entry : groups2.entrySet()) {
                    writer.write((String)entry.getKey());
                    writer.write(58);
                    writer.newLine();
                    for (String name2 : (Collection)entry.getValue()) {
                        writer.write("  ");
                        writer.write(name2);
                        writer.newLine();
                    }
                }
            }
        })) {
            DumpInspectionDescriptionsAction.doNotify("Inspection groups dumped to\n" + fqnListFile);
        }
    }

    private static Class<?> getInspectionClass(InspectionToolWrapper<?, ?> toolWrapper) {
        return toolWrapper instanceof LocalInspectionToolWrapper ? ((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool()).getClass() : toolWrapper.getClass();
    }

    private static String getGroupName(InspectionToolWrapper<?, ?> toolWrapper) {
        String name2 = toolWrapper.getGroupDisplayName();
        return StringUtil.isEmptyOrSpaces(name2) ? "General" : name2;
    }

    private static InputStream getDescriptionStream(InspectionToolWrapper<?, ?> toolWrapper) {
        Class<?> aClass = DumpInspectionDescriptionsAction.getInspectionClass(toolWrapper);
        return ResourceUtil.getResourceAsStream(aClass.getClassLoader(), "inspectionDescriptions", toolWrapper.getShortName() + ".html");
    }

    private static boolean doDump(Path file2, Processor processor) {
        boolean bl;
        block8: {
            BufferedWriter writer = Files.newBufferedWriter(file2, new OpenOption[0]);
            try {
                processor.process(writer);
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error(e);
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }

    private static void doNotify(String message2) {
        Notifications.Bus.notify((Notification)new Notification("Actions", "Inspection descriptions dumped", message2, NotificationType.INFORMATION));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/DumpInspectionDescriptionsAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/DumpInspectionDescriptionsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Processor {
        public void process(BufferedWriter var1) throws Exception;
    }
}

