/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.internal.ImageDuplicateResultsDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.util.io.DigestUtil;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class ShowImageDuplicatesAction
extends AnAction {
    private static final List<String> IMAGE_EXTENSIONS = Arrays.asList("png", "jpg", "jpeg", "gif", "tiff", "bmp");

    ShowImageDuplicatesAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowImageDuplicatesAction.$$$reportNull$$$0(0);
        }
        Project project2 = ShowImageDuplicatesAction.getEventProject((AnActionEvent)e);
        assert (project2 != null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ShowImageDuplicatesAction.collectAndShowDuplicates(project2), "Gathering Images", true, project2);
    }

    private static void collectAndShowDuplicates(Project project2) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null && !indicator.isCanceled()) {
            indicator.setText("Collecting project images...");
            indicator.setIndeterminate(false);
            ArrayList<VirtualFile> images = new ArrayList<VirtualFile>();
            for (String ext : IMAGE_EXTENSIONS) {
                images.addAll(ReadAction.compute(() -> FilenameIndex.getAllFilesByExt((Project)project2, (String)ext)));
            }
            HashMap<Long, Set<VirtualFile>> duplicates = new HashMap<Long, Set<VirtualFile>>();
            HashMap all = new HashMap();
            for (int i = 0; i < images.size(); ++i) {
                indicator.setFraction((double)(i + 1) / (double)images.size());
                VirtualFile file2 = (VirtualFile)images.get(i);
                ReadAction.run(() -> {
                    if (!(file2.getFileSystem() instanceof LocalFileSystem)) {
                        return;
                    }
                    long length = file2.getLength();
                    if (all.containsKey(length)) {
                        if (!duplicates.containsKey(length)) {
                            HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
                            files2.add((VirtualFile)all.get(length));
                            duplicates.put(length, files2);
                        }
                        ((Set)duplicates.get(length)).add(file2);
                    } else {
                        all.put(length, file2);
                    }
                });
                indicator.checkCanceled();
            }
            ShowImageDuplicatesAction.showResults(project2, images, duplicates);
        }
    }

    private static void showResults(Project project2, List<VirtualFile> images, Map<Long, Set<VirtualFile>> duplicates) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null || indicator.isCanceled()) {
            return;
        }
        indicator.setText("MD5 check");
        int count2 = duplicates.values().stream().mapToInt(Set::size).sum();
        HashMap realDuplicates = new HashMap();
        int seek = 0;
        for (Set<VirtualFile> files2 : duplicates.values()) {
            for (VirtualFile file2 : files2) {
                indicator.setFraction((double)(++seek) / (double)count2);
                try {
                    ReadAction.run(() -> {
                        String md52 = ShowImageDuplicatesAction.getMD5Checksum(file2);
                        realDuplicates.computeIfAbsent(md52, k -> new HashSet()).add(file2);
                    });
                }
                catch (Exception exception) {}
            }
        }
        count2 = 0;
        for (String key : new ArrayList(realDuplicates.keySet())) {
            int size = ((Set)realDuplicates.get(key)).size();
            if (size == 1) {
                realDuplicates.remove(key);
                continue;
            }
            count2 += size;
        }
        ApplicationManager.getApplication().invokeLater(() -> new ImageDuplicateResultsDialog(project2, images, realDuplicates).show());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowImageDuplicatesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowImageDuplicatesAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(ShowImageDuplicatesAction.getEventProject((AnActionEvent)e) != null);
    }

    private static byte[] createChecksum(VirtualFile file2) throws Exception {
        byte[] buffer = new byte[1024];
        MessageDigest md52 = DigestUtil.md5();
        try (InputStream fis = file2.getInputStream();){
            int read;
            while ((read = fis.read(buffer)) > 0) {
                md52.update(buffer, 0, read);
            }
            byte[] byArray = md52.digest();
            return byArray;
        }
    }

    private static String getMD5Checksum(VirtualFile fis) throws Exception {
        byte[] bytes = ShowImageDuplicatesAction.createChecksum(fis);
        StringBuilder md52 = new StringBuilder();
        for (byte b : bytes) {
            md52.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return md52.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/ShowImageDuplicatesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/ShowImageDuplicatesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

