/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.actions;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.documentation.DocumentationTarget;
import com.intellij.lang.documentation.ide.DocumentationBrowserFacade;
import com.intellij.lang.documentation.ide.IdeDocumentationTargetProvider;
import com.intellij.lang.documentation.ide.impl.DocumentationBrowser;
import com.intellij.lang.documentation.ide.impl.DocumentationHistory;
import com.intellij.lang.documentation.psi.UtilKt;
import com.intellij.lang.documentation.symbol.impl.ImplKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u001e\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002\u001a\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\bH\u0000\u001a\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\bH\u0000\u001a\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u001a(\u0010\"\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0007\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"DOCUMENTATION_BROWSER", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/lang/documentation/ide/DocumentationBrowserFacade;", "DOCUMENTATION_POPUP", "Lcom/intellij/openapi/ui/popup/JBPopup;", "getDOCUMENTATION_POPUP", "()Lcom/intellij/openapi/actionSystem/DataKey;", "DOCUMENTATION_TARGETS", "", "Lcom/intellij/lang/documentation/DocumentationTarget;", "PRIMARY_GROUP_ID", "", "TOGGLE_AUTO_SHOW_ACTION_ID", "TOGGLE_AUTO_UPDATE_ACTION_ID", "TOGGLE_SHOW_IN_POPUP_ACTION_ID", "documentationBrowser", "Lcom/intellij/lang/documentation/ide/impl/DocumentationBrowser;", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "documentationHistory", "Lcom/intellij/lang/documentation/ide/impl/DocumentationHistory;", "documentationTargetsInner", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "groupActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "kotlin.jvm.PlatformType", "groupId", "navigationActions", "primaryActions", "registerBackForwardActions", "", "component", "Ljavax/swing/JComponent;", "targetsFromEditor", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "intellij.platform.lang.impl"})
public final class ActionsKt {
    @JvmField
    @NotNull
    public static final DataKey<List<DocumentationTarget>> DOCUMENTATION_TARGETS;
    @JvmField
    @NotNull
    public static final DataKey<DocumentationBrowserFacade> DOCUMENTATION_BROWSER;
    @NotNull
    private static final DataKey<JBPopup> DOCUMENTATION_POPUP;
    @NotNull
    public static final String PRIMARY_GROUP_ID = "Documentation.PrimaryGroup";
    @NotNull
    public static final String TOGGLE_SHOW_IN_POPUP_ACTION_ID = "Documentation.ToggleShowInPopup";
    @NotNull
    public static final String TOGGLE_AUTO_SHOW_ACTION_ID = "Documentation.ToggleAutoShow";
    @NotNull
    public static final String TOGGLE_AUTO_UPDATE_ACTION_ID = "Documentation.ToggleAutoUpdate";

    @NotNull
    public static final DataKey<JBPopup> getDOCUMENTATION_POPUP() {
        return DOCUMENTATION_POPUP;
    }

    @NotNull
    public static final List<AnAction> primaryActions() {
        return ActionsKt.groupActions(PRIMARY_GROUP_ID);
    }

    @NotNull
    public static final List<AnAction> navigationActions() {
        return ActionsKt.groupActions("Documentation.Navigation");
    }

    private static final List<AnAction> groupActions(String groupId) {
        ActionGroup actionGroup;
        ActionGroup actionGroup2 = actionGroup = ActionUtil.getActionGroup((String)groupId);
        if (actionGroup2 == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        AnAction[] anActionArray = actionGroup2.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"requireNotNull(ActionUti\u2026oupId)).getChildren(null)");
        return CollectionsKt.listOf((Object[])Arrays.copyOf(anActionArray, anActionArray.length));
    }

    public static final void registerBackForwardActions(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        EmptyAction.registerWithShortcutSet((String)"Documentation.Back", (ShortcutSet)((ShortcutSet)new CustomShortcutSet(new Shortcut[]{(Shortcut)KeyboardShortcut.fromString((String)(ScreenReader.isActive() ? "alt LEFT" : "LEFT")), (Shortcut)KeymapUtil.parseMouseShortcut((String)"button4")})), (JComponent)component2);
        EmptyAction.registerWithShortcutSet((String)"Documentation.Forward", (ShortcutSet)((ShortcutSet)new CustomShortcutSet(new Shortcut[]{(Shortcut)KeyboardShortcut.fromString((String)(ScreenReader.isActive() ? "alt RIGHT" : "RIGHT")), (Shortcut)KeymapUtil.parseMouseShortcut((String)"button5")})), (JComponent)component2);
    }

    private static final List<DocumentationTarget> documentationTargetsInner(DataProvider dataProvider) {
        List<DocumentationTarget> symbolTargets;
        Collection collection;
        List symbols;
        Collection collection2;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataProvider);
        if (project2 == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"CommonDataKeys.PROJECT.g\u2026er) ?: return emptyList()");
        Project project3 = project2;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataProvider);
        if (editor2 != null) {
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            List<DocumentationTarget> editorTargets = ActionsKt.targetsFromEditor(project3, editor2, caretModel.getOffset());
            if (editorTargets != null) {
                return editorTargets;
            }
        }
        if (!((collection2 = (Collection)(symbols = (List)CommonDataKeys.SYMBOLS.getData(dataProvider))) == null || collection2.isEmpty()) && !(collection = (Collection)(symbolTargets = ImplKt.symbolDocumentationTargets(project3, symbols))).isEmpty()) {
            return symbolTargets;
        }
        PsiElement targetElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataProvider);
        if (targetElement != null) {
            return CollectionsKt.listOf((Object)UtilKt.psiDocumentationTarget(targetElement, null));
        }
        return CollectionsKt.emptyList();
    }

    @ApiStatus.Internal
    @Nullable
    public static final List<DocumentationTarget> targetsFromEditor(@NotNull Project project2, @NotNull Editor editor2, int offset) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor2, project2);
        if (psiFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiUtilBase.getPsiFileIn\u2026           ?: return null");
        PsiFile file2 = psiFile;
        IdeDocumentationTargetProvider ideDocumentationTargetProvider = IdeDocumentationTargetProvider.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)ideDocumentationTargetProvider, (String)"IdeDocumentationTargetPr\u2026ider.getInstance(project)");
        IdeDocumentationTargetProvider ideTargetProvider = ideDocumentationTargetProvider;
        LookupEx lookup2 = LookupManager.getActiveLookup(editor2);
        if (lookup2 != null) {
            LookupElement lookupElement = lookup2.getCurrentItem();
            if (lookupElement == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"lookup.currentItem\n     \u2026           ?: return null");
            LookupElement lookupElement2 = lookupElement;
            DocumentationTarget documentationTarget = ideTargetProvider.documentationTarget(editor2, file2, lookupElement2);
            if (documentationTarget == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)documentationTarget, (String)"ideTargetProvider.docume\u2026           ?: return null");
            DocumentationTarget target2 = documentationTarget;
            return CollectionsKt.listOf((Object)target2);
        }
        return (List)ContainerUtil.nullize((Collection)ideTargetProvider.documentationTargets(editor2, file2, offset));
    }

    @Nullable
    public static final DocumentationHistory documentationHistory(@NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        DocumentationBrowser documentationBrowser = ActionsKt.documentationBrowser(dc);
        return documentationBrowser != null ? documentationBrowser.getHistory() : null;
    }

    @Nullable
    public static final DocumentationBrowser documentationBrowser(@NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        Object object = dc.getData(DOCUMENTATION_BROWSER);
        if (!(object instanceof DocumentationBrowser)) {
            object = null;
        }
        return (DocumentationBrowser)object;
    }

    static {
        DataKey dataKey = DataKey.create((String)"documentation.targets");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"DataKey.create(\"documentation.targets\")");
        DOCUMENTATION_TARGETS = dataKey;
        DataKey dataKey2 = DataKey.create((String)"documentation.browser");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"DataKey.create(\"documentation.browser\")");
        DOCUMENTATION_BROWSER = dataKey2;
        DataKey dataKey3 = DataKey.create((String)"documentation.popup");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"DataKey.create(\"documentation.popup\")");
        DOCUMENTATION_POPUP = dataKey3;
    }

    public static final /* synthetic */ List access$documentationTargetsInner(DataProvider dataProvider) {
        return ActionsKt.documentationTargetsInner(dataProvider);
    }
}

