/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.ui;

import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.options.FontSize;
import com.intellij.ui.FontSizeModel;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/documentation/ide/ui/FontSizeMouseWheelListener;", "Ljava/awt/event/MouseWheelListener;", "model", "Lcom/intellij/ui/FontSizeModel;", "(Lcom/intellij/ui/FontSizeModel;)V", "mouseWheelMoved", "", "e", "Ljava/awt/event/MouseWheelEvent;", "intellij.platform.lang.impl"})
public final class FontSizeMouseWheelListener
implements MouseWheelListener {
    private final FontSizeModel model;

    @Override
    public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
        if (!editorSettingsExternalizable.isWheelFontChangeEnabled() || !EditorUtil.isChangeFontSize((MouseWheelEvent)e)) {
            return;
        }
        int rotation = e.getWheelRotation();
        if (rotation == 0) {
            return;
        }
        FontSize newFontSize = this.model.getValue();
        boolean increase = rotation <= 0;
        int n = Math.abs(rotation);
        for (int i = 0; i < n; ++i) {
            FontSize fontSize;
            int it = i;
            boolean bl = false;
            if (increase) {
                FontSize fontSize2 = newFontSize.larger();
                fontSize = fontSize2;
                Intrinsics.checkNotNullExpressionValue((Object)fontSize2, (String)"newFontSize.larger()");
            } else {
                FontSize fontSize3 = newFontSize.smaller();
                fontSize = fontSize3;
                Intrinsics.checkNotNullExpressionValue((Object)fontSize3, (String)"newFontSize.smaller()");
            }
            newFontSize = fontSize;
        }
        this.model.setValue(newFontSize);
    }

    public FontSizeMouseWheelListener(@NotNull FontSizeModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
    }
}

