/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.ui;

import com.intellij.lang.documentation.ide.ui.DocumentationUI;
import com.intellij.lang.documentation.ide.ui.SearchHighlighterPainter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.EventListeners;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\b\u0010$\u001a\u00020 H\u0016J\b\u0010%\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020 H\u0002J\b\u0010'\u001a\u00020 H\u0002J\b\u0010(\u001a\u00020 H\u0002J\b\u0010)\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010+\u001a\u00020 H\u0002J\b\u0010,\u001a\u00020 H\u0002J\b\u0010-\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0012j\b\u0012\u0004\u0012\u00020\b`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR*\u0010\u001e\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/lang/documentation/ide/ui/SearchModel;", "Lcom/intellij/openapi/Disposable;", "ui", "Lcom/intellij/lang/documentation/ide/ui/DocumentationUI;", "(Lcom/intellij/lang/documentation/ide/ui/DocumentationUI;)V", "cs", "Lkotlinx/coroutines/CoroutineScope;", "currentSelection", "", "editorPane", "Ljavax/swing/JEditorPane;", "hasNext", "", "getHasNext", "()Z", "hasPrev", "getHasPrev", "indices", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "matchLabel", "Ljavax/swing/JLabel;", "getMatchLabel", "()Ljavax/swing/JLabel;", "pattern", "", "searchField", "Lcom/intellij/ui/SearchTextField;", "getSearchField", "()Lcom/intellij/ui/SearchTextField;", "tagHandles", "Lkotlin/Function0;", "", "createNavigationActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "near", "next", "prev", "removeHighlights", "scroll", "setPattern", "updateHighlighting", "updateIndices", "updateMatchLabel", "intellij.platform.lang.impl"})
public final class SearchModel
implements Disposable {
    private final JEditorPane editorPane;
    private final CoroutineScope cs;
    @NotNull
    private final SearchTextField searchField;
    @NotNull
    private final JLabel matchLabel;
    private String pattern;
    private final ArrayList<Integer> indices;
    private int currentSelection;
    private final ArrayList<Function0<Unit>> tagHandles;

    @NotNull
    public final SearchTextField getSearchField() {
        return this.searchField;
    }

    @NotNull
    public final JLabel getMatchLabel() {
        return this.matchLabel;
    }

    @Override
    public void dispose() {
        CoroutineScopeKt.cancel$default(this.cs, "SearchModel disposal", null, 2, null);
        this.pattern = "";
        this.indices.clear();
        this.currentSelection = -1;
        this.removeHighlights();
    }

    @NotNull
    public final List<AnAction> createNavigationActions() {
        return CollectionsKt.listOf((Object[])new DumbAwareAction[]{new DumbAwareAction(this){
            final /* synthetic */ SearchModel this$0;

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                presentation2.setEnabled(SearchModel.access$getHasPrev$p(this.this$0));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchModel.access$prev(this.this$0);
            }
            {
                this.this$0 = this$0;
                ActionUtil.copyFrom((AnAction)((AnAction)this), (String)"PreviousOccurence");
            }
        }, new DumbAwareAction(this){
            final /* synthetic */ SearchModel this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchModel.access$next(this.this$0);
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                presentation2.setEnabled(SearchModel.access$getHasNext$p(this.this$0));
            }
            {
                this.this$0 = this$0;
                ActionUtil.copyFrom((AnAction)((AnAction)this), (String)"NextOccurence");
            }
        }});
    }

    private final void setPattern(String pattern) {
        if (Intrinsics.areEqual((Object)this.pattern, (Object)pattern)) {
            return;
        }
        this.pattern = pattern;
        this.updateIndices();
        this.updateHighlighting();
    }

    private final boolean getHasNext() {
        return this.currentSelection + 1 < this.indices.size();
    }

    private final boolean getHasPrev() {
        return this.currentSelection - 1 >= 0;
    }

    private final void next() {
        boolean bl = this.getHasNext();
        if (!bl) {
            boolean bl2 = false;
            String string2 = "Doesn't have next element";
            throw new IllegalStateException(string2.toString());
        }
        ++this.currentSelection;
        this.updateHighlighting();
        this.updateMatchLabel();
        this.scroll();
    }

    private final void prev() {
        boolean bl = this.getHasPrev();
        if (!bl) {
            boolean bl2 = false;
            String string2 = "Doesn't have prev element";
            throw new IllegalStateException(string2.toString());
        }
        --this.currentSelection;
        this.updateHighlighting();
        this.updateMatchLabel();
        this.scroll();
    }

    private final void near() {
        Object v1;
        Rectangle visibleRect;
        Rectangle rectangle = visibleRect = this.editorPane.getVisibleRect();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"visibleRect");
        Point visibleRestCenter = new Point((int)rectangle.getCenterX(), (int)visibleRect.getCenterY());
        int currentOffset = this.editorPane.viewToModel2D(visibleRestCenter);
        Iterable $this$minByOrNull$iv = this.indices;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                int it = ((Number)minElem$iv).intValue();
                boolean bl = false;
                int n = it - currentOffset;
                int minValue$iv = Math.abs(n);
                do {
                    Object e$iv = iterator$iv.next();
                    int it2 = ((Number)e$iv).intValue();
                    $i$a$-minByOrNull-SearchModel$near$nearestSelection$1 = false;
                    int n2 = it2 - currentOffset;
                    int v$iv = Math.abs(n2);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        Integer n = v1;
        if (n == null) {
            return;
        }
        int nearestSelection = n;
        this.currentSelection = this.indices.indexOf(nearestSelection);
        this.updateHighlighting();
        this.updateMatchLabel();
        this.scroll();
    }

    private final void scroll() {
        Integer n = this.indices.get(this.currentSelection);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"indices[currentSelection]");
        Rectangle viewRectangle = this.editorPane.modelToView(((Number)n).intValue());
        this.editorPane.scrollRectToVisible(viewRectangle);
    }

    private final void updateIndices() {
        this.indices.clear();
        this.currentSelection = 0;
        CharSequence charSequence = this.pattern;
        if (charSequence.length() > 0) {
            Document document = this.editorPane.getDocument();
            Document document2 = this.editorPane.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editorPane.document");
            String text2 = document.getText(0, document2.getLength());
            for (int index = 0; index < text2.length() && (index = StringUtil.indexOfIgnoreCase(text2, this.pattern, index)) != -1; index += this.pattern.length()) {
                this.indices.add(index);
            }
        }
        this.updateMatchLabel();
    }

    private final void updateMatchLabel() {
        this.matchLabel.setForeground(UIUtil.getLabelForeground());
        this.matchLabel.setFont(JBUI.Fonts.toolbarFont());
        int matches = this.indices.size();
        int cursorIndex = this.currentSelection + 1;
        CharSequence charSequence = this.pattern;
        if (charSequence.length() == 0) {
            JBTextField jBTextField = this.searchField.getTextEditor();
            Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"searchField.textEditor");
            jBTextField.setBackground(UIUtil.getTextFieldBackground());
            this.matchLabel.setText("");
        } else if (matches > 0) {
            JBTextField jBTextField = this.searchField.getTextEditor();
            Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"searchField.textEditor");
            jBTextField.setBackground(UIUtil.getTextFieldBackground());
            this.matchLabel.setText(ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])new Object[]{cursorIndex, matches}));
        } else {
            JBTextField jBTextField = this.searchField.getTextEditor();
            Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"searchField.textEditor");
            jBTextField.setBackground(LightColors.RED);
            this.matchLabel.setForeground(UIUtil.getErrorForeground());
            this.matchLabel.setText(ApplicationBundle.message((String)"editorsearch.matches", (Object[])new Object[]{matches}));
        }
    }

    private final void removeHighlights() {
        for (Function0<Unit> tagHandle : this.tagHandles) {
            tagHandle.invoke();
        }
        this.tagHandles.clear();
    }

    private final void updateHighlighting() {
        this.removeHighlights();
        Highlighter highlighter = this.editorPane.getHighlighter();
        if (highlighter == null) {
            return;
        }
        Highlighter highlighter2 = highlighter;
        this.editorPane.invalidate();
        this.editorPane.repaint();
        Iterator<Integer> iterator = this.indices.iterator();
        while (iterator.hasNext()) {
            Integer index;
            Integer n = index = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"index");
            Object tag = highlighter2.addHighlight(n, index + this.pattern.length(), new SearchHighlighterPainter(Intrinsics.areEqual((Object)this.indices.get(this.currentSelection), (Object)index)));
            this.tagHandles.add(new Function0<Unit>(highlighter2, tag){
                final /* synthetic */ Highlighter $highlighter;
                final /* synthetic */ Object $tag;

                public final void invoke() {
                    this.$highlighter.removeHighlight(this.$tag);
                }
                {
                    this.$highlighter = highlighter;
                    this.$tag = object;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public SearchModel(@NotNull DocumentationUI ui2) {
        void label2;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
        this.editorPane = ui2.getEditorPane();
        this.cs = CoroutineScopeKt.CoroutineScope(CoroutinesKt.getEDT(Dispatchers.INSTANCE));
        this.searchField = new SearchTextField();
        JLabel jLabel2 = jLabel = new JLabel();
        SearchModel searchModel = this;
        boolean bl = false;
        label2.setFont(JBUI.Fonts.toolbarFont());
        label2.setText("9888 results");
        label2.setPreferredSize(label2.getPreferredSize());
        label2.setText(null);
        label2.setHorizontalAlignment(4);
        Unit unit = Unit.INSTANCE;
        searchModel.matchLabel = jLabel;
        this.searchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                String pattern;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string2 = pattern = this.getSearchField().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pattern");
                this.setPattern(string2);
                this.near();
            }
        });
        this.searchField.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10 && this.getHasNext()) {
                    this.next();
                }
            }
        });
        BuildersKt.launch$default(this.cs, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ui2, null){
            int label;
            final /* synthetic */ SearchModel this$0;
            final /* synthetic */ DocumentationUI $ui;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Flow flow2 = this.$ui.getContentUpdates();
                        3 $completion$iv = this;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<Unit>(this){
                            final /* synthetic */ 3 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            @Nullable
                            public Object emit(Object value, @NotNull Continuation $completion) {
                                Continuation continuation = $completion;
                                Unit it = (Unit)value;
                                boolean bl = false;
                                SearchModel.access$updateIndices(this.this$0.this$0);
                                SearchModel.access$updateHighlighting(this.this$0.this$0);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation<? super Unit>)$completion$iv);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = searchModel;
                this.$ui = documentationUI;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        EventListeners.addPropertyChangeListener(this.editorPane, this, "highlighter", new PropertyChangeListener(){

            @Override
            public final void propertyChange(PropertyChangeEvent it) {
                this.updateHighlighting();
            }
        });
        this.pattern = "";
        this.indices = new ArrayList();
        this.tagHandles = new ArrayList();
    }

    public static final /* synthetic */ boolean access$getHasPrev$p(SearchModel $this) {
        return $this.getHasPrev();
    }

    public static final /* synthetic */ void access$prev(SearchModel $this) {
        $this.prev();
    }

    public static final /* synthetic */ void access$updateIndices(SearchModel $this) {
        $this.updateIndices();
    }
}

