/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.ui;

import com.intellij.codeInsight.documentation.CornerAwareScrollPaneLayout;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.documentation.LinkData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0000\u001a\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0000\u001a\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"#\u0010\u0002\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00040\u00040\u0003\u00a2\u0006\u0002\b\u00068\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n*\u0018\b\u0000\u0010\u001e\"\b\u0012\u0004\u0012\u00020 0\u001f2\b\u0012\u0004\u0012\u00020 0\u001f\u00a8\u0006!"}, d2={"DEFAULT_UI_RESPONSE_TIMEOUT", "", "FORCED_WIDTH", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "actionButton", "Ljavax/swing/JComponent;", "actions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "contextComponent", "linkChunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "presentableText", "", "Lorg/jetbrains/annotations/Nls;", "links", "Lcom/intellij/lang/documentation/LinkData;", "scrollPaneWithCorner", "parent", "Lcom/intellij/openapi/Disposable;", "scrollPane", "Ljavax/swing/JScrollPane;", "corner", "toolbarComponent", "UISnapshot", "Lkotlin/Function0;", "", "intellij.platform.lang.impl"})
public final class UiKt {
    @NotNull
    private static final Logger LOG;
    public static final long DEFAULT_UI_RESPONSE_TIMEOUT = 300L;
    @JvmField
    @NotNull
    public static final Key<Integer> FORCED_WIDTH;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public static final JComponent toolbarComponent(@NotNull ActionGroup actions2, @NotNull JComponent contextComponent) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)actions2, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)contextComponent, (String)"contextComponent");
        ActionToolbar it = object = ActionManager.getInstance().createActionToolbar("JavadocToolbar", actions2, true);
        boolean bl = false;
        it.setSecondaryActionsIcon(AllIcons.Actions.More, true);
        it.setTargetComponent(contextComponent);
        ActionToolbar actionToolbar = object;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026ent(contextComponent)\n  }");
        ActionToolbar toolbar = actionToolbar;
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"toolbar.component");
        it = object = jComponent;
        boolean bl2 = false;
        it.setBorder(IdeBorderFactory.createBorder((Color)UIUtil.getTooltipSeparatorColor(), (int)8));
        return object;
    }

    @NotNull
    public static final JComponent actionButton(@NotNull ActionGroup actions2, @NotNull JComponent contextComponent) {
        Presentation presentation2;
        Intrinsics.checkNotNullParameter((Object)actions2, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)contextComponent, (String)"contextComponent");
        Presentation it = presentation2 = new Presentation();
        boolean bl = false;
        it.setIcon(AllIcons.Actions.More);
        it.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
        Presentation presentation3 = presentation2;
        ActionButton button2 = new ActionButton(contextComponent, actions2, presentation3, (AnAction)actions2, presentation3, "unknown", new Dimension(20, 20)){
            final /* synthetic */ JComponent $contextComponent;
            final /* synthetic */ ActionGroup $actions;
            final /* synthetic */ Presentation $presentation;

            @NotNull
            protected DataContext getDataContext() {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.$contextComponent);
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance(\u2026Context(contextComponent)");
                return dataContext;
            }
            {
                this.$contextComponent = $captured_local_variable$0;
                this.$actions = $captured_local_variable$1;
                this.$presentation = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
        button2.setNoIconsInPopup(true);
        return (JComponent)button2;
    }

    @NotNull
    public static final JComponent scrollPaneWithCorner(@NotNull Disposable parent, @NotNull JScrollPane scrollPane, @NotNull JComponent corner) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)scrollPane, (String)"scrollPane");
        Intrinsics.checkNotNullParameter((Object)corner, (String)"corner");
        LayoutManager defaultLayout = scrollPane.getLayout();
        scrollPane.setLayout((LayoutManager)((Object)new CornerAwareScrollPaneLayout(corner)));
        Disposer.register(parent, new Disposable(scrollPane, defaultLayout){
            final /* synthetic */ JScrollPane $scrollPane;
            final /* synthetic */ LayoutManager $defaultLayout;

            public final void dispose() {
                this.$scrollPane.setLayout(this.$defaultLayout);
            }
            {
                this.$scrollPane = jScrollPane;
                this.$defaultLayout = layoutManager;
            }
        });
        JLayeredPane layeredPane2 = (JLayeredPane)new JBLayeredPane(scrollPane, corner){
            final /* synthetic */ JScrollPane $scrollPane;
            final /* synthetic */ JComponent $corner;

            public void doLayout() {
                Rectangle r = this.getBounds();
                for (Component component2 : this.getComponents()) {
                    if (component2 == this.$scrollPane) {
                        component2.setBounds(0, 0, r.width, r.height);
                        continue;
                    }
                    if (component2 == this.$corner) {
                        Dimension d = ((JComponent)component2).getPreferredSize();
                        component2.setBounds(r.width - d.width - 2, r.height - d.height - 2, d.width, d.height);
                        continue;
                    }
                    String string2 = "can't layout unexpected component: " + component2;
                    throw new IllegalStateException(string2.toString());
                }
            }

            @NotNull
            public Dimension getPreferredSize() {
                Dimension dimension = this.$scrollPane.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"scrollPane.preferredSize");
                return dimension;
            }
            {
                this.$scrollPane = $captured_local_variable$0;
                this.$corner = $captured_local_variable$1;
            }
        };
        Component component2 = scrollPane;
        Integer n = JLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"JLayeredPane.DEFAULT_LAYER");
        layeredPane2.setLayer(component2, n);
        layeredPane2.add(scrollPane);
        Component component3 = corner;
        Integer n2 = JLayeredPane.PALETTE_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"JLayeredPane.PALETTE_LAYER");
        layeredPane2.setLayer(component3, n2);
        layeredPane2.add(corner);
        return layeredPane2;
    }

    @Nullable
    public static final HtmlChunk linkChunk(@NotNull String presentableText2, @NotNull LinkData links) {
        Intrinsics.checkNotNullParameter((Object)presentableText2, (String)"presentableText");
        Intrinsics.checkNotNullParameter((Object)links, (String)"links");
        String externalUrl = links.getExternalUrl();
        if (externalUrl != null) {
            HtmlChunk htmlChunk = DocumentationManager.getLink(presentableText2, externalUrl);
            if (htmlChunk == null) {
                htmlChunk = DocumentationManager.getGenericExternalDocumentationLink(presentableText2);
            }
            return htmlChunk;
        }
        List<String> linkUrls = links.getLinkUrls();
        Collection collection = linkUrls;
        if (!collection.isEmpty()) {
            HtmlChunk htmlChunk = DocumentationManager.getExternalLinks(presentableText2, linkUrls);
            if (htmlChunk == null) {
                htmlChunk = DocumentationManager.getGenericExternalDocumentationLink(presentableText2);
            }
            return htmlChunk;
        }
        return null;
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.lang.documentation.ide.ui");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026ng.documentation.ide.ui\")");
        LOG = logger;
        Key key = Key.create("WidthBasedLayout.width");
        Intrinsics.checkNotNullExpressionValue(key, (String)"Key.create<Int>(\"WidthBasedLayout.width\")");
        FORCED_WIDTH = key;
    }
}

