/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.psi;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.navigation.SingleTargetElementInfo;
import com.intellij.lang.documentation.DocumentationContentData;
import com.intellij.lang.documentation.DocumentationImageResolver;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationResult;
import com.intellij.lang.documentation.DocumentationResultData;
import com.intellij.lang.documentation.DocumentationTarget;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.documentation.LinkData;
import com.intellij.lang.documentation.psi.UtilKt;
import com.intellij.model.Pointer;
import com.intellij.navigation.TargetPresentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.awt.Image;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001$B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bB+\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB!\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0003J\u0017\u0010\"\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b#2\u0006\u0010 \u001a\u00020!H\u0003R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/intellij/lang/documentation/psi/PsiElementDocumentationTarget;", "Lcom/intellij/lang/documentation/DocumentationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "targetElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;)V", "sourceElement", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "anchor", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "pointer", "Lcom/intellij/lang/documentation/psi/PsiElementDocumentationTarget$PsiElementDocumentationTargetPointer;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/documentation/psi/PsiElementDocumentationTarget$PsiElementDocumentationTargetPointer;)V", "navigatable", "Lcom/intellij/pom/Navigatable;", "getNavigatable", "()Lcom/intellij/pom/Navigatable;", "presentation", "Lcom/intellij/navigation/TargetPresentation;", "getPresentation", "()Lcom/intellij/navigation/TargetPresentation;", "getTargetElement", "()Lcom/intellij/psi/PsiElement;", "computeDocumentation", "Lcom/intellij/lang/documentation/DocumentationResult;", "computeDocumentationHint", "createPointer", "Lcom/intellij/model/Pointer;", "localDoc", "Lcom/intellij/lang/documentation/DocumentationResultData;", "provider", "Lcom/intellij/lang/documentation/DocumentationProvider;", "localDocHtml", "Lorg/jetbrains/annotations/Nls;", "PsiElementDocumentationTargetPointer", "intellij.platform.lang.impl"})
@VisibleForTesting
public final class PsiElementDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final PsiElement targetElement;
    private final PsiElement sourceElement;
    private final PsiElementDocumentationTargetPointer pointer;

    @Override
    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        return this.pointer;
    }

    @Override
    @NotNull
    public TargetPresentation getPresentation() {
        return com.intellij.codeInsight.navigation.UtilKt.targetPresentation(this.targetElement);
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        PsiElement psiElement = this.targetElement;
        if (!(psiElement instanceof Navigatable)) {
            psiElement = null;
        }
        return (Navigatable)((Object)psiElement);
    }

    @Override
    @Nullable
    public String computeDocumentationHint() {
        return SingleTargetElementInfo.generateInfo((PsiElement)this.targetElement, (PsiElement)this.sourceElement, (boolean)UtilKt.isNavigatableQuickDoc((PsiElement)this.sourceElement, (PsiElement)this.targetElement)).text;
    }

    @Override
    @Nullable
    public DocumentationResult computeDocumentation() {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(this.targetElement, this.sourceElement);
        Intrinsics.checkNotNullExpressionValue((Object)documentationProvider, (String)"DocumentationManager.get\u2026etElement, sourceElement)");
        DocumentationProvider provider2 = documentationProvider;
        DocumentationResultData localDoc = this.localDoc(provider2);
        if (!(provider2 instanceof ExternalDocumentationProvider)) {
            return localDoc;
        }
        SmartPsiElementPointer<?> smartPsiElementPointer = this.targetElement.getUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY);
        List<String> urls = provider2.getUrlFor(this.targetElement, (PsiElement)(smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null));
        Collection collection = urls;
        if (collection == null || collection.isEmpty()) {
            return localDoc;
        }
        DocumentationResultData documentationResultData = localDoc;
        return this.pointer.fetchExternal(this.targetElement, (ExternalDocumentationProvider)((Object)provider2), urls, documentationResultData != null ? DocumentationResultData.copy$default(documentationResultData, null, LinkData.copy$default(localDoc.getLinks$intellij_platform_lang_impl(), null, urls, 1, null), null, null, 13, null) : null);
    }

    @RequiresReadLock
    private final DocumentationResultData localDoc(DocumentationProvider provider2) {
        String string2 = this.localDocHtml(provider2);
        if (string2 == null) {
            return null;
        }
        String html = string2;
        return new DocumentationResultData(new DocumentationContentData(html, this.pointer.getImageResolver()), null, this.pointer.getAnchor(), null, 10, null);
    }

    @RequiresReadLock
    private final String localDocHtml(DocumentationProvider provider2) {
        String fileDoc;
        SmartPsiElementPointer<?> smartPsiElementPointer = this.targetElement.getUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY);
        Object originalPsi = smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null;
        String doc = provider2.generateDoc(this.targetElement, (PsiElement)originalPsi);
        if (this.targetElement instanceof PsiFile && (fileDoc = DocumentationManager.generateFileDoc((PsiFile)this.targetElement, doc == null)) != null) {
            return doc == null ? fileDoc : doc + fileDoc;
        }
        return doc;
    }

    @NotNull
    public final PsiElement getTargetElement() {
        return this.targetElement;
    }

    private PsiElementDocumentationTarget(PsiElement targetElement, PsiElement sourceElement, PsiElementDocumentationTargetPointer pointer) {
        this.targetElement = targetElement;
        this.sourceElement = sourceElement;
        this.pointer = pointer;
    }

    public PsiElementDocumentationTarget(@NotNull Project project2, @NotNull PsiElement targetElement) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        this(project2, targetElement, null);
    }

    public PsiElementDocumentationTarget(@NotNull Project project2, @NotNull PsiElement targetElement, @Nullable PsiElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        this(project2, targetElement, sourceElement, null);
    }

    public PsiElementDocumentationTarget(@NotNull Project project2, @NotNull PsiElement targetElement, @Nullable PsiElement sourceElement, @Nullable String anchor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        PsiElement psiElement = sourceElement;
        this(targetElement, sourceElement, new PsiElementDocumentationTargetPointer(project2, (Pointer<? extends PsiElement>)UtilsKt.createSmartPointer(targetElement), (Pointer<PsiElement>)(psiElement != null ? UtilsKt.createSmartPointer(psiElement) : null), anchor));
    }

    public /* synthetic */ PsiElementDocumentationTarget(PsiElement targetElement, PsiElement sourceElement, PsiElementDocumentationTargetPointer pointer, DefaultConstructorMarker $constructor_marker) {
        this(targetElement, sourceElement, pointer);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0001\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0001\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/documentation/psi/PsiElementDocumentationTarget$PsiElementDocumentationTargetPointer;", "Lcom/intellij/model/Pointer;", "Lcom/intellij/lang/documentation/psi/PsiElementDocumentationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "targetPointer", "Lcom/intellij/psi/PsiElement;", "sourcePointer", "anchor", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/model/Pointer;Lcom/intellij/model/Pointer;Ljava/lang/String;)V", "getAnchor", "()Ljava/lang/String;", "imageResolver", "Lcom/intellij/lang/documentation/DocumentationImageResolver;", "getImageResolver", "()Lcom/intellij/lang/documentation/DocumentationImageResolver;", "getProject", "()Lcom/intellij/openapi/project/Project;", "dereference", "fetchExternal", "Lcom/intellij/lang/documentation/DocumentationResult;", "targetElement", "provider", "Lcom/intellij/lang/documentation/ExternalDocumentationProvider;", "urls", "", "localDoc", "Lcom/intellij/lang/documentation/DocumentationResult$Data;", "intellij.platform.lang.impl"})
    private static final class PsiElementDocumentationTargetPointer
    implements Pointer<PsiElementDocumentationTarget> {
        @NotNull
        private final DocumentationImageResolver imageResolver;
        @NotNull
        private final Project project;
        private final Pointer<? extends PsiElement> targetPointer;
        private final Pointer<PsiElement> sourcePointer;
        @Nullable
        private final String anchor;

        @Override
        @Nullable
        public PsiElementDocumentationTarget dereference() {
            PsiElement psiElement;
            PsiElement psiElement2 = this.targetPointer.dereference();
            if (psiElement2 == null) {
                return null;
            }
            PsiElement target2 = psiElement2;
            if (this.sourcePointer == null) {
                psiElement = null;
            } else {
                psiElement = this.sourcePointer.dereference();
                if (psiElement == null) {
                    return null;
                }
            }
            PsiElement source = psiElement;
            return new PsiElementDocumentationTarget(target2, source, this, null);
        }

        @NotNull
        public final DocumentationResult fetchExternal(@NotNull PsiElement targetElement, @NotNull ExternalDocumentationProvider provider2, @NotNull List<String> urls, @Nullable DocumentationResult.Data localDoc) {
            Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            return DocumentationResult.Companion.asyncDocumentation(new Supplier(this, urls, provider2, targetElement, localDoc){
                final /* synthetic */ PsiElementDocumentationTargetPointer this$0;
                final /* synthetic */ List $urls;
                final /* synthetic */ ExternalDocumentationProvider $provider;
                final /* synthetic */ PsiElement $targetElement;
                final /* synthetic */ DocumentationResult.Data $localDoc;

                @Nullable
                public final DocumentationResult.Data get() {
                    UtilKt.LOG.debug("External documentation URLs: " + this.$urls);
                    for (String url : this.$urls) {
                        ProgressManager.checkCanceled();
                        String string2 = this.$provider.fetchExternalDocumentation(this.this$0.getProject(), this.$targetElement, CollectionsKt.listOf((Object)url), false);
                        if (string2 == null) {
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"provider.fetchExternalDo\u2026              ?: continue");
                        String doc = string2;
                        UtilKt.LOG.debug("Fetched documentation from " + url);
                        Flow flow2 = null;
                        LinkData linkData = new LinkData(url, null, 2, null);
                        String string3 = this.this$0.getAnchor();
                        return new DocumentationResultData(new DocumentationContentData(doc, this.this$0.getImageResolver()), linkData, string3, flow2, 8, null);
                    }
                    return this.$localDoc;
                }
                {
                    this.this$0 = psiElementDocumentationTargetPointer;
                    this.$urls = list2;
                    this.$provider = externalDocumentationProvider;
                    this.$targetElement = psiElement;
                    this.$localDoc = data2;
                }
            });
        }

        @NotNull
        public final DocumentationImageResolver getImageResolver() {
            return this.imageResolver;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public final String getAnchor() {
            return this.anchor;
        }

        public PsiElementDocumentationTargetPointer(@NotNull Project project2, @NotNull Pointer<? extends PsiElement> targetPointer, @Nullable Pointer<PsiElement> sourcePointer, @Nullable String anchor) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(targetPointer, (String)"targetPointer");
            this.project = project2;
            this.targetPointer = targetPointer;
            this.sourcePointer = sourcePointer;
            this.anchor = anchor;
            this.imageResolver = new DocumentationImageResolver(this){
                final /* synthetic */ PsiElementDocumentationTargetPointer this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public final Image resolveImage(@NotNull String url) {
                    Image image;
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    AutoCloseable autoCloseable = SlowOperations.allowSlowOperations("old API fallback");
                    Throwable throwable = null;
                    try {
                        Image image2;
                        AccessToken it = (AccessToken)autoCloseable;
                        boolean bl = false;
                        Object object = this.this$0.dereference();
                        if (object != null && (object = ((PsiElementDocumentationTarget)object).getTargetElement()) != null) {
                            Object object2;
                            Object targetElement = object2 = object;
                            boolean bl2 = false;
                            image2 = DocumentationManager.getElementImage((PsiElement)targetElement, url);
                        } else {
                            image2 = null;
                        }
                        image = image2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    return image;
                }
                {
                    this.this$0 = psiElementDocumentationTargetPointer;
                }
            };
        }
    }
}

