/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.largeFilesEditor.Utils;
import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.largeFilesEditor.editor.Page;
import com.intellij.largeFilesEditor.search.LfeSearchManager;
import com.intellij.largeFilesEditor.search.Position;
import com.intellij.largeFilesEditor.search.RangeSearchCreator;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.actions.FindForwardBackwardAction;
import com.intellij.largeFilesEditor.search.actions.LargeFileFindAllAction;
import com.intellij.largeFilesEditor.search.actions.LargeFilePrevNextOccurrenceAction;
import com.intellij.largeFilesEditor.search.actions.LargeFileStatusTextAction;
import com.intellij.largeFilesEditor.search.actions.LargeFileToggleAction;
import com.intellij.largeFilesEditor.search.searchResultsPanel.RangeSearch;
import com.intellij.largeFilesEditor.search.searchResultsPanel.RangeSearchCallback;
import com.intellij.largeFilesEditor.search.searchTask.CloseSearchTask;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.DefaultCustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBList;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class LfeSearchManagerImpl
implements LfeSearchManager,
CloseSearchTask.Callback {
    private static final int CONTEXT_ONE_SIDE_LENGTH = 100;
    private static final long STATUS_TEXT_LIFE_TIME = 3000L;
    private static final Logger LOG = Logger.getInstance(LfeSearchManagerImpl.class);
    private static final long PROGRESS_STATUS_UPDATE_PERIOD = 150L;
    private final LargeFileEditor largeFileEditor;
    private final FileDataProviderForSearch fileDataProviderForSearch;
    private final RangeSearchCreator rangeSearchCreator;
    private final JBList<SearchResult> myCloseSearchResultsList;
    private CloseSearchTask lastExecutedCloseSearchTask;
    private boolean notFoundState;
    private long lastProgressStatusUpdateTime;
    private SearchReplaceComponent mySearchReplaceComponent;
    private LargeFileFindAllAction myFindAllAction;
    private FindForwardBackwardAction myFindForwardAction;
    private FindForwardBackwardAction myFindBackwardAction;
    private LargeFilePrevNextOccurrenceAction myNextOccurrenceAction;
    private LargeFilePrevNextOccurrenceAction myPrevOccurrenceAction;
    private LargeFileToggleAction myToggleCaseSensitiveAction;
    private LargeFileToggleAction myToggleWholeWordsAction;
    private LargeFileToggleAction myToggleRegularExpression;
    private LargeFileStatusTextAction myStatusTextAction;
    private @NlsContexts.StatusText String myStatusText;
    private boolean myIsStatusTextHidden;
    private long myLastTimeStatusTextWasChanged;

    public LfeSearchManagerImpl(@NotNull LargeFileEditor largeFileEditor, FileDataProviderForSearch fileDataProviderForSearch, @NotNull RangeSearchCreator rangeSearchCreator) {
        if (largeFileEditor == null) {
            LfeSearchManagerImpl.$$$reportNull$$$0(0);
        }
        if (rangeSearchCreator == null) {
            LfeSearchManagerImpl.$$$reportNull$$$0(1);
        }
        this.lastProgressStatusUpdateTime = System.currentTimeMillis();
        this.largeFileEditor = largeFileEditor;
        this.fileDataProviderForSearch = fileDataProviderForSearch;
        this.rangeSearchCreator = rangeSearchCreator;
        this.createActions();
        this.createSearchReplaceComponent();
        this.attachListenersToSearchReplaceComponent();
        this.myCloseSearchResultsList = this.createCloseSearchResultsList();
        this.lastExecutedCloseSearchTask = null;
        this.notFoundState = false;
        this.myStatusText = "";
        this.myIsStatusTextHidden = true;
        this.myLastTimeStatusTextWasChanged = System.currentTimeMillis();
    }

    @Override
    public SearchReplaceComponent getSearchReplaceComponent() {
        return this.mySearchReplaceComponent;
    }

    @Override
    public CloseSearchTask getLastExecutedCloseSearchTask() {
        return this.lastExecutedCloseSearchTask;
    }

    @Override
    public void onSearchActionHandlerExecuted() {
        this.largeFileEditor.getEditor().setHeaderComponent((JComponent)((Object)this.mySearchReplaceComponent));
        this.mySearchReplaceComponent.requestFocusInTheSearchFieldAndSelectContent(this.largeFileEditor.getProject());
        this.mySearchReplaceComponent.getSearchTextComponent().selectAll();
    }

    @Override
    @NotNull
    public LargeFileEditor getLargeFileEditor() {
        LargeFileEditor largeFileEditor = this.largeFileEditor;
        if (largeFileEditor == null) {
            LfeSearchManagerImpl.$$$reportNull$$$0(2);
        }
        return largeFileEditor;
    }

    @Override
    public void launchNewRangeSearch(long fromPageNumber, long toPageNumber, boolean forwardDirection) {
        SearchTaskOptions options = new SearchTaskOptions().setStringToFind(this.mySearchReplaceComponent.getSearchTextComponent().getText()).setSearchDirectionForward(forwardDirection).setSearchBounds(fromPageNumber, -1, toPageNumber, -1).setCaseSensitive(this.myToggleCaseSensitiveAction.isSelected()).setWholeWords(this.myToggleWholeWordsAction.isSelected()).setRegularExpression(this.myToggleRegularExpression.isSelected()).setContextOneSideLength(100);
        this.launchNewRangeSearch(options);
    }

    private void launchNewRangeSearch(SearchTaskOptions searchTaskOptions) {
        this.showRegexSearchWarningIfNeed();
        RangeSearch rangeSearch = this.rangeSearchCreator.createContent(this.largeFileEditor.getProject(), this.largeFileEditor.getFile(), this.largeFileEditor.getFile().getName());
        rangeSearch.runNewSearch(searchTaskOptions, this.fileDataProviderForSearch);
    }

    @Override
    public void gotoNextOccurrence(boolean directionForward) {
        int gotoSearchResultIndex = LfeSearchManagerImpl.getNextOccurrenceIndexIfCan(directionForward, this.largeFileEditor.getCaretPageNumber(), this.largeFileEditor.getCaretPageOffset(), this.myCloseSearchResultsList);
        if (gotoSearchResultIndex == -1) {
            boolean launchedLoopedCloseSearch = false;
            SearchTaskOptions normalCloseSearchOptions = this.generateOptionsForNormalCloseSearch(directionForward);
            if (this.notFoundState) {
                this.notFoundState = false;
                launchedLoopedCloseSearch = this.launchLoopedCloseSearchTaskIfNeeded(normalCloseSearchOptions);
            }
            if (!launchedLoopedCloseSearch) {
                this.launchCloseSearch(normalCloseSearchOptions);
            }
        } else {
            this.myCloseSearchResultsList.setSelectedIndex(gotoSearchResultIndex);
            this.setNewStatusText("");
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void launchCloseSearch(SearchTaskOptions searchTaskOptions) {
        void options;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (StringUtil.isEmpty(options.stringToFind)) {
            return;
        }
        this.stopSearchTaskIfItExists();
        this.showRegexSearchWarningIfNeed();
        this.lastExecutedCloseSearchTask = new CloseSearchTask((SearchTaskOptions)options, this.largeFileEditor.getProject(), this.fileDataProviderForSearch, this);
        ApplicationManager.getApplication().executeOnPooledThread(this.lastExecutedCloseSearchTask);
    }

    private void showRegexSearchWarningIfNeed() {
        EditorNotifications.getInstance((Project)this.largeFileEditor.getProject()).updateNotifications(this.largeFileEditor.getFile());
    }

    private boolean launchLoopedCloseSearchTaskIfNeeded(SearchTaskOptions normalCloseSearchOptions) {
        SearchTaskOptions loopedOptions;
        if (this.lastExecutedCloseSearchTask == null || !this.lastExecutedCloseSearchTask.isFinished()) {
            return false;
        }
        SearchTaskOptions oldOptions = this.lastExecutedCloseSearchTask.getOptions();
        if (oldOptions.loopedPhase) {
            return false;
        }
        if (!normalCloseSearchOptions.stringToFind.equals(oldOptions.stringToFind) || normalCloseSearchOptions.wholeWords != oldOptions.wholeWords || normalCloseSearchOptions.caseSensitive != oldOptions.caseSensitive || normalCloseSearchOptions.regularExpression != oldOptions.regularExpression || normalCloseSearchOptions.searchForwardDirection != oldOptions.searchForwardDirection || normalCloseSearchOptions.leftBoundPageNumber != oldOptions.leftBoundPageNumber || normalCloseSearchOptions.leftBoundCaretPageOffset != oldOptions.leftBoundCaretPageOffset || normalCloseSearchOptions.rightBoundPageNumber != oldOptions.rightBoundPageNumber || normalCloseSearchOptions.rightBoundCaretPageOffset != oldOptions.rightBoundCaretPageOffset) {
            return false;
        }
        try {
            loopedOptions = normalCloseSearchOptions.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.warn(e);
            Messages.showWarningDialog((String)EditorBundle.message((String)"large.file.editor.message.error.while.searching", (Object[])new Object[0]), (String)EditorBundle.message((String)"large.file.editor.title.search.error", (Object[])new Object[0]));
            return false;
        }
        loopedOptions.loopedPhase = true;
        if (loopedOptions.searchForwardDirection) {
            loopedOptions.setSearchBounds(0L, -1, normalCloseSearchOptions.leftBoundPageNumber, normalCloseSearchOptions.leftBoundCaretPageOffset);
        } else {
            loopedOptions.setSearchBounds(normalCloseSearchOptions.rightBoundPageNumber, normalCloseSearchOptions.rightBoundCaretPageOffset, -1L, -1);
        }
        this.launchCloseSearch(loopedOptions);
        return true;
    }

    private SearchTaskOptions generateOptionsForNormalCloseSearch(boolean directionForward) {
        SearchTaskOptions options = new SearchTaskOptions().setSearchDirectionForward(directionForward).setStringToFind(this.mySearchReplaceComponent.getSearchTextComponent().getText()).setCaseSensitive(this.myToggleCaseSensitiveAction.isSelected()).setWholeWords(this.myToggleWholeWordsAction.isSelected()).setRegularExpression(this.myToggleRegularExpression.isSelected()).setContextOneSideLength(100);
        if (!this.myCloseSearchResultsList.isEmpty() && this.myCloseSearchResultsList.getSelectedIndex() != -1) {
            Position position = ((SearchResult)this.myCloseSearchResultsList.getSelectedValue()).startPosition;
            if (directionForward) {
                options.setSearchBounds(position.pageNumber + 1L, 0, -1L, -1);
            } else {
                options.setSearchBounds(-1L, -1, position.pageNumber, position.symbolOffsetInPage);
            }
        } else {
            long caretPageNumber = this.largeFileEditor.getCaretPageNumber();
            int caretPageOffset = this.largeFileEditor.getCaretPageOffset();
            if (directionForward) {
                options.setSearchBounds(caretPageNumber, caretPageOffset, -1L, -1);
            } else {
                options.setSearchBounds(-1L, -1, caretPageNumber, caretPageOffset);
            }
        }
        return options;
    }

    @Override
    public void tellSearchProgress(CloseSearchTask caller, long curPageNumber, long pagesAmount) {
        long time = System.currentTimeMillis();
        if (time - this.lastProgressStatusUpdateTime > 150L || curPageNumber == 0L || curPageNumber == pagesAmount - 1L) {
            this.lastProgressStatusUpdateTime = time;
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!caller.isShouldStop()) {
                    this.setNewStatusText(EditorBundle.message((String)"large.file.editor.message.searching.at.some.percent.of.file", (Object[])new Object[]{Utils.calculatePagePositionPercent(curPageNumber, pagesAmount)}));
                }
            });
        }
    }

    @Override
    public void tellClosestResultFound(CloseSearchTask caller, List<? extends SearchResult> allMatchesAtFrame, int indexOfClosestResult) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!caller.isShouldStop()) {
                this.setNewStatusText("");
                SearchResult closestResult = (SearchResult)allMatchesAtFrame.get(indexOfClosestResult);
                this.largeFileEditor.getEditorModel().showSearchResult(closestResult);
                this.largeFileEditor.getEditorModel().setHighlightingCloseSearchResultsEnabled(true);
            }
        });
    }

    @Override
    public void tellSearchIsFinished(CloseSearchTask caller, long lastScannedPageNumber) {
        ApplicationManager.getApplication().invokeLater(() -> {
            SearchTaskOptions options = caller.getOptions();
            if (!caller.isShouldStop()) {
                if (options.loopedPhase) {
                    this.setNewStatusText(EditorBundle.message((String)"large.file.editor.message.search.is.completed.and.no.more.matches", (Object[])new Object[0]));
                    this.mySearchReplaceComponent.setNotFoundBackground();
                    if (!(this.largeFileEditor.getEditor().getHeaderComponent() instanceof SearchReplaceComponent)) {
                        String message2 = EditorBundle.message((String)"large.file.editor.message.some.string.not.found", (Object[])new Object[]{options.stringToFind});
                        LfeSearchManagerImpl.showSimpleHintInEditor(message2, this.largeFileEditor.getEditor());
                    }
                } else {
                    this.notFoundState = true;
                    AnAction action2 = ActionManager.getInstance().getAction(options.searchForwardDirection ? "FindNext" : "FindPrevious");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2);
                    this.setNewStatusText("");
                    String message3 = !shortcutsText.isEmpty() ? (options.searchForwardDirection ? EditorBundle.message((String)"large.file.editor.some.string.not.found.press.some.shortcut.to.search.from.the.start", (Object[])new Object[]{options.stringToFind, shortcutsText}) : EditorBundle.message((String)"large.file.editor.some.string.not.found.press.some.shortcut.to.search.from.the.end", (Object[])new Object[]{options.stringToFind, shortcutsText})) : (options.searchForwardDirection ? EditorBundle.message((String)"large.file.editor.some.string.not.found.perform.some.action.again.to.search.from.start", (Object[])new Object[]{options.stringToFind, action2.getTemplatePresentation().getText()}) : EditorBundle.message((String)"large.file.editor.some.string.not.found.perform.some.action.again.to.search.from.end", (Object[])new Object[]{options.stringToFind, action2.getTemplatePresentation().getText()}));
                    LfeSearchManagerImpl.showSimpleHintInEditor(message3, this.largeFileEditor.getEditor());
                }
            }
        });
    }

    private static void showSimpleHintInEditor(@NlsContexts.HintText String message2, Editor editor2) {
        JComponent hintComponent = HintUtil.createInformationLabel((String)message2);
        LightweightHint hint = new LightweightHint(hintComponent);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, (short)2, 42, 0, false);
    }

    @Override
    public void tellSearchWasStopped(CloseSearchTask caller, long curPageNumber) {
    }

    @Override
    public void tellSearchWasCatchedException(CloseSearchTask caller, IOException e) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!caller.isShouldStop()) {
                this.setNewStatusText(EditorBundle.message((String)"large.file.editor.message.search.stopped.because.something.went.wrong", (Object[])new Object[0]));
            }
        });
    }

    @Override
    public void onEscapePressed() {
        if (this.lastExecutedCloseSearchTask != null && !this.lastExecutedCloseSearchTask.isShouldStop() && !this.lastExecutedCloseSearchTask.isFinished()) {
            this.stopSearchTaskIfItExists();
            if (this.lastExecutedCloseSearchTask != null) {
                this.setNewStatusText(EditorBundle.message((String)"large.file.editor.message.stopped.by.user", (Object[])new Object[0]));
            }
        } else {
            this.stopSearchTaskIfItExists();
            IdeFocusManager.getInstance((Project)this.largeFileEditor.getProject()).requestFocus((Component)this.largeFileEditor.getEditor().getContentComponent(), false);
            this.largeFileEditor.getEditorModel().setHighlightingCloseSearchResultsEnabled(false);
            if (this.largeFileEditor.getEditor().getHeaderComponent() instanceof SearchReplaceComponent) {
                this.largeFileEditor.getEditor().setHeaderComponent(null);
            }
        }
    }

    @Override
    @NlsContexts.StatusText
    public String getStatusText() {
        return this.myStatusText;
    }

    @Override
    public void updateStatusText() {
        if (this.myIsStatusTextHidden) {
            return;
        }
        if (System.currentTimeMillis() - this.myLastTimeStatusTextWasChanged > 3000L) {
            this.myStatusText = "";
            this.myIsStatusTextHidden = true;
        }
    }

    @Override
    public void updateSearchReplaceComponentActions() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.mySearchReplaceComponent.updateActions();
        } else {
            ApplicationManager.getApplication().invokeLater(() -> this.mySearchReplaceComponent.updateActions());
        }
    }

    @Override
    @RequiresEdt
    public void onSearchParametersChanged() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.lastExecutedCloseSearchTask != null) {
            this.lastExecutedCloseSearchTask.shouldStop();
            this.setNewStatusText("");
        }
        this.mySearchReplaceComponent.setRegularBackground();
        this.largeFileEditor.getEditorModel().setHighlightingCloseSearchResultsEnabled(false);
        String stringToFind = this.mySearchReplaceComponent.getSearchTextComponent().getText();
        boolean isMultiline = stringToFind.contains("\n");
        this.mySearchReplaceComponent.update(stringToFind, "", false, isMultiline);
    }

    @Override
    public void onCaretPositionChanged(CaretEvent e) {
        if (this.myCloseSearchResultsList.getSelectedIndex() != -1 && e.getEditor().getCaretModel().getOffset() != ((SearchResult)this.myCloseSearchResultsList.getSelectedValue()).startPosition.symbolOffsetInPage && e.getEditor().getCaretModel().getOffset() != 0) {
            this.myCloseSearchResultsList.clearSelection();
        }
    }

    @Override
    public void dispose() {
        this.stopSearchTaskIfItExists();
    }

    @Override
    public List<SearchResult> getSearchResultsInPage(Page page2) {
        SearchTaskOptions options = new SearchTaskOptions().setStringToFind(this.mySearchReplaceComponent.getSearchTextComponent().getText()).setStringToFind(this.mySearchReplaceComponent.getSearchTextComponent().getText()).setCaseSensitive(this.myToggleCaseSensitiveAction.isSelected()).setWholeWords(this.myToggleWholeWordsAction.isSelected()).setRegularExpression(this.myToggleRegularExpression.isSelected()).setSearchDirectionForward(true).setSearchBounds(page2.getPageNumber(), -1, page2.getPageNumber(), -1).setContextOneSideLength(0);
        if (StringUtil.isEmpty(options.stringToFind)) {
            return null;
        }
        RangeSearch rangeSearch = new RangeSearch(this.getLargeFileEditor().getFile(), this.getLargeFileEditor().getProject(), new RangeSearchCallback(){

            @Override
            public FileDataProviderForSearch getFileDataProviderForSearch(boolean createIfNotExists, Project project2, VirtualFile virtualFile2) {
                return LfeSearchManagerImpl.this.fileDataProviderForSearch;
            }

            @Override
            public void showResultInEditor(SearchResult searchResult, Project project2, VirtualFile virtualFile2) {
            }
        });
        rangeSearch.runNewSearch(options, this.fileDataProviderForSearch, false);
        return rangeSearch.getSearchResultsList();
    }

    @Override
    public boolean isSearchWorkingNow() {
        return this.lastExecutedCloseSearchTask != null && !this.lastExecutedCloseSearchTask.isFinished();
    }

    @Override
    public boolean canShowRegexSearchWarning() {
        if (!this.myToggleRegularExpression.isSelected()) {
            return false;
        }
        String stringToFind = this.mySearchReplaceComponent.getSearchTextComponent().getText();
        return stringToFind.length() > this.largeFileEditor.getPageSize() / 10 || stringToFind.contains("*") || stringToFind.contains("+") || stringToFind.contains("{");
    }

    private void createActions() {
        this.myNextOccurrenceAction = new LargeFilePrevNextOccurrenceAction(this, true);
        this.myPrevOccurrenceAction = new LargeFilePrevNextOccurrenceAction(this, false);
        this.myFindAllAction = new LargeFileFindAllAction(this);
        this.myFindForwardAction = new FindForwardBackwardAction(true, this);
        this.myFindBackwardAction = new FindForwardBackwardAction(false, this);
        this.myToggleCaseSensitiveAction = new LargeFileToggleAction(this, EditorBundle.message((String)"large.file.editor.match.case.action.mnemonic.text", (Object[])new Object[0]));
        this.myToggleWholeWordsAction = new LargeFileToggleAction(this, EditorBundle.message((String)"large.file.editor.words.action.mnemonic.text", (Object[])new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean enabled = LfeSearchManagerImpl.this.myToggleRegularExpression != null && !LfeSearchManagerImpl.this.myToggleRegularExpression.isSelected(e);
                boolean visible = LfeSearchManagerImpl.this.mySearchReplaceComponent == null || !LfeSearchManagerImpl.this.mySearchReplaceComponent.isMultiline();
                e.getPresentation().setEnabled(enabled);
                e.getPresentation().setVisible(visible);
                this.setSelected(e, this.isSelected(e) && enabled && visible);
                super.update(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/largeFilesEditor/search/LfeSearchManagerImpl$2", "update"));
            }
        };
        this.myToggleRegularExpression = new LargeFileToggleAction(this, EditorBundle.message((String)"large.file.editor.regex.action.mnemonic.text", (Object[])new Object[0])){

            @Override
            public void setSelected(boolean state) {
                super.setSelected(state);
                if (state && LfeSearchManagerImpl.this.myToggleWholeWordsAction != null) {
                    LfeSearchManagerImpl.this.myToggleWholeWordsAction.setSelected(false);
                }
            }
        };
        this.myStatusTextAction = new LargeFileStatusTextAction(this);
    }

    private void createSearchReplaceComponent() {
        this.mySearchReplaceComponent = SearchReplaceComponent.buildFor(this.largeFileEditor.getProject(), this.largeFileEditor.getEditor().getContentComponent()).addPrimarySearchActions(new AnAction[]{this.myPrevOccurrenceAction, this.myNextOccurrenceAction, new Separator(), this.myFindAllAction, this.myFindBackwardAction, this.myFindForwardAction}).addExtraSearchActions(new AnAction[]{this.myToggleCaseSensitiveAction, this.myToggleWholeWordsAction, this.myToggleRegularExpression, new DefaultCustomComponentAction(() -> RegExHelpPopup.createRegExLink(new HtmlBuilder().append(HtmlChunk.text("?").bold()).wrapWithHtmlBody().toString(), null, "FindInFile")), this.myStatusTextAction}).withCloseAction(this::onEscapePressed).build();
    }

    private void attachListenersToSearchReplaceComponent() {
        this.mySearchReplaceComponent.addListener(new SearchReplaceComponent.Listener(){

            @Override
            public void searchFieldDocumentChanged() {
                LfeSearchManagerImpl.this.onSearchParametersChanged();
            }

            @Override
            public void replaceFieldDocumentChanged() {
            }

            @Override
            public void multilineStateChanged() {
            }
        });
    }

    private JBList<SearchResult> createCloseSearchResultsList() {
        CollectionListModel<SearchResult> model2 = new CollectionListModel<SearchResult>(new SearchResult[0]);
        JBList list2 = new JBList(model2);
        list2.addListSelectionListener((ListSelectionListener)new CloseSearchResultsListSelectionListener((JBList<SearchResult>)list2));
        return list2;
    }

    private void stopSearchTaskIfItExists() {
        if (this.lastExecutedCloseSearchTask != null) {
            this.lastExecutedCloseSearchTask.shouldStop();
        }
    }

    private void setNewStatusText(@NlsContexts.StatusText String newStatusText) {
        this.myStatusText = newStatusText;
        this.myLastTimeStatusTextWasChanged = System.currentTimeMillis();
        this.myIsStatusTextHidden = StringUtil.isEmpty(newStatusText);
        this.updateSearchReplaceComponentActions();
    }

    private static int getNextOccurrenceIndexIfCan(boolean directionForward, long currentPageNumber, int caretPageOffset, JBList<SearchResult> listResult) {
        int index;
        ListModel model2 = listResult.getModel();
        if (model2.getSize() == -1) {
            return -1;
        }
        if (listResult.getSelectedIndex() != -1) {
            index = listResult.getSelectedIndex();
            index = directionForward ? ++index : --index;
        } else {
            index = 0;
            while (true) {
                if (index >= model2.getSize()) {
                    if (directionForward) {
                        return -1;
                    }
                    return model2.getSize() - 1;
                }
                SearchResult searchResult = (SearchResult)model2.getElementAt(index);
                if (currentPageNumber <= searchResult.startPosition.pageNumber && (currentPageNumber != searchResult.startPosition.pageNumber || caretPageOffset < searchResult.startPosition.symbolOffsetInPage)) break;
                ++index;
            }
            if (!directionForward) {
                --index;
            }
        }
        if (index < 0 || index >= model2.getSize()) {
            return -1;
        }
        return index;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "largeFileEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeSearchCreator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/largeFilesEditor/search/LfeSearchManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/largeFilesEditor/search/LfeSearchManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLargeFileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class CloseSearchResultsListSelectionListener
    implements ListSelectionListener {
        private final JBList<SearchResult> list;

        CloseSearchResultsListSelectionListener(JBList<SearchResult> list2) {
            this.list = list2;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SearchResult selectedSearchResult;
            if (!e.getValueIsAdjusting() && (selectedSearchResult = (SearchResult)this.list.getSelectedValue()) != null) {
                LfeSearchManagerImpl.this.largeFileEditor.showSearchResult(selectedSearchResult);
            }
        }
    }
}

