/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.searchTask;

import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.largeFilesEditor.search.searchTask.FrameSearcher;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskBase;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CloseSearchTask
extends SearchTaskBase {
    private static final Logger logger = Logger.getInstance(CloseSearchTask.class);
    private final Callback myCallback;

    public CloseSearchTask(SearchTaskOptions options, Project project2, FileDataProviderForSearch fileDataProviderForSearch, Callback callback) {
        super(options, project2, fileDataProviderForSearch);
        this.myCallback = callback;
    }

    @Override
    public void doRun() {
        FrameSearcher searcher2 = this.createFrameSearcher(this.options, this.project);
        int tailLength = CloseSearchTask.getTailLength(this.options);
        try {
            long pagesAmount = this.fileDataProviderForSearch.getPagesAmount();
            long curPageNumber = CloseSearchTask.getPageNumberForBeginning(pagesAmount, this.options);
            if (CloseSearchTask.isTheEndOfSearchingCycle(curPageNumber, pagesAmount, this.options)) {
                this.myCallback.tellSearchIsFinished(this, curPageNumber);
                return;
            }
            String prevPageText = curPageNumber > 0L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber - 1L).getText() : "";
            String curPageText = this.fileDataProviderForSearch.getPage_wait(curPageNumber).getText();
            String nextPageText = curPageNumber < pagesAmount - 1L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber + 1L).getText() : "";
            String tailText = CloseSearchTask.getTailFromPage(nextPageText, tailLength);
            char prefixSymbol = CloseSearchTask.getPrefixSymbol(prevPageText);
            char postfixSymbol = CloseSearchTask.getPostfixSymbol(nextPageText, tailLength);
            this.myCallback.tellSearchProgress(this, curPageNumber, pagesAmount);
            searcher2.setFrame(curPageNumber, prefixSymbol, curPageText, tailText, postfixSymbol);
            ArrayList<SearchResult> allMatchesAtFrame = searcher2.findAllMatchesAtFrame();
            int index = CloseSearchTask.tryGetClosestResult(allMatchesAtFrame, this.options);
            if (index != -1) {
                this.myCallback.tellClosestResultFound(this, allMatchesAtFrame, index);
                return;
            }
            do {
                pagesAmount = this.fileDataProviderForSearch.getPagesAmount();
                if (this.options.searchForwardDirection) {
                    prevPageText = curPageText;
                    curPageText = nextPageText;
                    nextPageText = ++curPageNumber < pagesAmount - 1L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber + 1L).getText() : "";
                } else {
                    nextPageText = curPageText;
                    curPageText = prevPageText;
                    String string2 = prevPageText = --curPageNumber > 0L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber - 1L).getText() : "";
                }
                if (CloseSearchTask.isTheEndOfSearchingCycle(curPageNumber, pagesAmount, this.options)) {
                    this.myCallback.tellSearchIsFinished(this, CloseSearchTask.getPreviousPageNumber(curPageNumber, this.options));
                    return;
                }
                if (this.isShouldStop()) {
                    this.myCallback.tellSearchWasStopped(this, curPageNumber);
                    return;
                }
                tailText = CloseSearchTask.getTailFromPage(nextPageText, tailLength);
                prefixSymbol = CloseSearchTask.getPrefixSymbol(prevPageText);
                postfixSymbol = CloseSearchTask.getPostfixSymbol(nextPageText, tailLength);
                this.myCallback.tellSearchProgress(this, curPageNumber, pagesAmount);
                searcher2.setFrame(curPageNumber, prefixSymbol, curPageText, tailText, postfixSymbol);
            } while ((allMatchesAtFrame = searcher2.findAllMatchesAtFrame()).size() <= 0);
            this.myCallback.tellClosestResultFound(this, allMatchesAtFrame, this.options.searchForwardDirection ? 0 : allMatchesAtFrame.size() - 1);
            return;
        }
        catch (IOException e) {
            logger.warn(e);
            this.myCallback.tellSearchWasCatchedException(this, e);
            return;
        }
    }

    private static int tryGetClosestResult(ArrayList<SearchResult> allMatchesAtFrame, SearchTaskOptions options) {
        block6: {
            if (allMatchesAtFrame.isEmpty()) break block6;
            if (options.searchForwardDirection) {
                if (options.leftBoundPageNumber == -1L) {
                    return 0;
                }
                for (int i = 0; i < allMatchesAtFrame.size(); ++i) {
                    SearchResult searchResult = allMatchesAtFrame.get(i);
                    if (searchResult.startPosition.pageNumber <= options.leftBoundPageNumber && (searchResult.startPosition.pageNumber != options.leftBoundPageNumber || searchResult.startPosition.symbolOffsetInPage < options.leftBoundCaretPageOffset)) continue;
                    return i;
                }
            } else {
                if (options.rightBoundPageNumber == -1L) {
                    return allMatchesAtFrame.size() - 1;
                }
                for (int i = allMatchesAtFrame.size() - 1; i >= 0; --i) {
                    SearchResult searchResult = allMatchesAtFrame.get(i);
                    if (searchResult.endPostion.pageNumber >= options.rightBoundPageNumber && (searchResult.endPostion.pageNumber != options.rightBoundPageNumber || searchResult.endPostion.symbolOffsetInPage >= options.rightBoundCaretPageOffset)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static interface Callback {
        public void tellSearchIsFinished(CloseSearchTask var1, long var2);

        public void tellSearchProgress(CloseSearchTask var1, long var2, long var4);

        public void tellSearchWasStopped(CloseSearchTask var1, long var2);

        public void tellSearchWasCatchedException(CloseSearchTask var1, IOException var2);

        public void tellClosestResultFound(CloseSearchTask var1, List<? extends SearchResult> var2, int var3);
    }
}

