/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.presentation.impl;

import com.intellij.ide.TypePresentationService;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.model.Symbol;
import com.intellij.model.presentation.PresentableSymbol;
import com.intellij.model.presentation.SymbolPresentation;
import com.intellij.model.presentation.SymbolPresentationProvider;
import com.intellij.model.presentation.SymbolPresentationService;
import com.intellij.model.presentation.impl.DefaultSymbolPresentation;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageViewUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/model/presentation/impl/SymbolPresentationServiceImpl;", "Lcom/intellij/model/presentation/SymbolPresentationService;", "()V", "getSymbolPresentation", "Lcom/intellij/model/presentation/SymbolPresentation;", "symbol", "Lcom/intellij/model/Symbol;", "Companion", "intellij.platform.lang.impl"})
public final class SymbolPresentationServiceImpl
implements SymbolPresentationService {
    private static final ClassExtension<SymbolPresentationProvider> ourExtension;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public SymbolPresentation getSymbolPresentation(@NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        for (SymbolPresentationProvider provider2 : ourExtension.forKey(symbol.getClass())) {
            SymbolPresentation presentation2 = provider2.getPresentation(symbol);
            if (presentation2 == null) continue;
            return presentation2;
        }
        if (symbol instanceof PresentableSymbol) {
            SymbolPresentation symbolPresentation = ((PresentableSymbol)symbol).getSymbolPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)symbolPresentation, (String)"symbol.symbolPresentation");
            return symbolPresentation;
        }
        PsiElement element2 = PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        if (element2 != null) {
            Icon icon2 = element2.getIcon(0);
            String string2 = UsageViewUtil.getType((PsiElement)element2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UsageViewUtil.getType(element)");
            String string3 = UsageViewUtil.getShortName((PsiElement)element2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"UsageViewUtil.getShortName(element)");
            return new DefaultSymbolPresentation(icon2, string2, string3, DescriptiveNameUtil.getDescriptiveName((PsiElement)element2));
        }
        TypePresentationService typePresentationService = TypePresentationService.getService();
        Icon icon3 = typePresentationService.getIcon(symbol);
        String string4 = typePresentationService.getTypeName(symbol);
        if (string4 == null) {
            string4 = TypePresentationService.getDefaultTypeName(symbol.getClass());
        }
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"typePresentationService.\u2026ypeName(symbol.javaClass)");
        String string5 = typePresentationService.getObjectName(symbol);
        if (string5 == null) {
            string5 = "<anonymous>";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"typePresentationService.\u2026(symbol) ?: \"<anonymous>\"");
        return new DefaultSymbolPresentation(icon3, string4, string5, null, 8, null);
    }

    static {
        Companion = new Companion(null);
        ourExtension = new ClassExtension("com.intellij.symbolPresentation");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/model/presentation/impl/SymbolPresentationServiceImpl$Companion;", "", "()V", "ourExtension", "Lcom/intellij/openapi/util/ClassExtension;", "Lcom/intellij/model/presentation/SymbolPresentationProvider;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

