/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.search.impl;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.model.psi.impl.Declarations;
import com.intellij.model.psi.impl.ReferencesKt;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchRequest;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.TextOccurrence;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.util.TextOccurrencesUtilBase;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.codeInsight.CommentUtilCore;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u001a0\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0002\u001a\u001e\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u001b0\u001a*\u00020\u0015H\u0002\u00a8\u0006\u001c"}, d2={"buildTextUsageQuery", "Lcom/intellij/util/Query;", "Lcom/intellij/find/usages/api/PsiUsage;", "project", "Lcom/intellij/openapi/project/Project;", "searchRequest", "Lcom/intellij/model/search/SearchRequest;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchContexts", "", "Lcom/intellij/model/search/SearchContext;", "hasDeclarationsOrReferences", "", "element", "Lcom/intellij/psi/PsiElement;", "startOffsetInElement", "", "searchStringLength", "isApplicableOccurrence", "occurrence", "Lcom/intellij/model/search/TextOccurrence;", "comments", "strings", "plainText", "walkUp", "", "Lkotlin/Pair;", "intellij.platform.lang.impl"})
public final class TextSearchKt {
    @NotNull
    public static final Query<? extends PsiUsage> buildTextUsageQuery(@NotNull Project project2, @NotNull SearchRequest searchRequest, @NotNull SearchScope searchScope2, @NotNull Set<? extends SearchContext> searchContexts) {
        Query query2;
        SearchScope searchScope3;
        int searchStringLength;
        String searchString;
        block9: {
            block8: {
                SearchScope searchScope4;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)searchRequest, (String)"searchRequest");
                Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
                Intrinsics.checkNotNullParameter(searchContexts, (String)"searchContexts");
                boolean bl2 = bl = !searchContexts.contains(SearchContext.IN_CODE);
                if (!bl) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                boolean bl3 = bl = !searchContexts.contains(SearchContext.IN_CODE_HOSTS);
                if (!bl) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                if (searchContexts.isEmpty()) {
                    Query query3 = EmptyQuery.getEmptyQuery();
                    Intrinsics.checkNotNullExpressionValue(query3, (String)"EmptyQuery.getEmptyQuery()");
                    return query3;
                }
                String string4 = searchRequest.getSearchString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"searchRequest.searchString");
                searchString = string4;
                searchStringLength = searchString.length();
                searchScope3 = searchRequest.getSearchScope();
                if (searchScope3 == null) break block8;
                SearchScope p1 = searchScope4 = searchScope3;
                boolean bl4 = false;
                searchScope3 = searchScope2.intersectWith(p1);
                if (searchScope3 != null) break block9;
            }
            searchScope3 = searchScope2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)searchScope3, (String)"searchRequest.searchScop\u2026           ?: searchScope");
        SearchScope effectiveSearchScope = searchScope3;
        boolean comments = searchContexts.contains(SearchContext.IN_COMMENTS);
        boolean strings2 = searchContexts.contains(SearchContext.IN_STRINGS);
        boolean plainText = searchContexts.contains(SearchContext.IN_PLAIN_TEXT);
        Query query4 = SearchService.getInstance().searchWord(project2, searchString).inContexts(searchContexts).inScope(effectiveSearchScope).buildLeafOccurrenceQuery();
        Intrinsics.checkNotNullExpressionValue((Object)query4, (String)"SearchService.getInstanc\u2026uildLeafOccurrenceQuery()");
        Query occurrenceQuery = query4;
        if (comments && strings2 && plainText) {
            Query query5 = occurrenceQuery.filtering(new Predicate(searchStringLength){
                final /* synthetic */ int $searchStringLength;

                public final boolean test(TextOccurrence it) {
                    TextOccurrence textOccurrence = it;
                    Intrinsics.checkNotNullExpressionValue((Object)textOccurrence, (String)"it");
                    return TextSearchKt.access$isApplicableOccurrence(textOccurrence, this.$searchStringLength);
                }
                {
                    this.$searchStringLength = n;
                }
            });
            query2 = query5;
            Intrinsics.checkNotNullExpressionValue(query5, (String)"occurrenceQuery.filterin\u2026searchStringLength)\n    }");
        } else {
            Query query6 = occurrenceQuery.filtering(new Predicate(searchStringLength, comments, strings2, plainText){
                final /* synthetic */ int $searchStringLength;
                final /* synthetic */ boolean $comments;
                final /* synthetic */ boolean $strings;
                final /* synthetic */ boolean $plainText;

                public final boolean test(TextOccurrence it) {
                    TextOccurrence textOccurrence = it;
                    Intrinsics.checkNotNullExpressionValue((Object)textOccurrence, (String)"it");
                    return TextSearchKt.access$isApplicableOccurrence(textOccurrence, this.$searchStringLength, this.$comments, this.$strings, this.$plainText);
                }
                {
                    this.$searchStringLength = n;
                    this.$comments = bl;
                    this.$strings = bl2;
                    this.$plainText = bl3;
                }
            });
            query2 = query6;
            Intrinsics.checkNotNullExpressionValue(query6, (String)"occurrenceQuery.filterin\u2026strings, plainText)\n    }");
        }
        Query filteredOccurrenceQuery2 = query2;
        Query query7 = filteredOccurrenceQuery2.mapping(new Function(searchStringLength){
            final /* synthetic */ int $searchStringLength;

            public final PsiUsage apply(@NotNull TextOccurrence occurrence) {
                Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
                PsiElement psiElement = occurrence.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"occurrence.element");
                TextRange textRange = TextRange.from(occurrence.getOffsetInElement(), this.$searchStringLength);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.from(occurrenc\u2026ment, searchStringLength)");
                return PsiUsage.Companion.textUsage(psiElement, textRange);
            }
            {
                this.$searchStringLength = n;
            }
        });
        Intrinsics.checkNotNullExpressionValue(query7, (String)"filteredOccurrenceQuery.\u2026 searchStringLength))\n  }");
        return query7;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isApplicableOccurrence(TextOccurrence occurrence, int searchStringLength) {
        Object object = TextSearchKt.walkUp(occurrence);
        Iterator<Pair<PsiElement, Integer>> iterator = object;
        while (iterator.hasNext()) {
            void element2;
            Pair<PsiElement, Integer> pair = iterator.next();
            object = (PsiElement)pair.component1();
            int offsetInElement = ((Number)pair.component2()).intValue();
            if (!TextSearchKt.hasDeclarationsOrReferences((PsiElement)element2, offsetInElement, searchStringLength)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isApplicableOccurrence(TextOccurrence occurrence, int searchStringLength, boolean comments, boolean strings2, boolean plainText) {
        boolean isComment = false;
        boolean isString = false;
        Object object = TextSearchKt.walkUp(occurrence);
        Iterator<Pair<PsiElement, Integer>> iterator = object;
        while (iterator.hasNext()) {
            void element2;
            Pair<PsiElement, Integer> pair = iterator.next();
            object = (PsiElement)pair.component1();
            int offsetInElement = ((Number)pair.component2()).intValue();
            if (TextSearchKt.hasDeclarationsOrReferences((PsiElement)element2, offsetInElement, searchStringLength)) {
                return false;
            }
            isComment = isComment || CommentUtilCore.isCommentTextElement((PsiElement)element2);
            isString = isString || TextOccurrencesUtilBase.isStringLiteralElement((PsiElement)element2);
        }
        return comments && isComment || strings2 && isString || plainText && !isComment && !isString;
    }

    private static final Iterator<Pair<PsiElement, Integer>> walkUp(TextOccurrence $this$walkUp) {
        PsiElement psiElement = $this$walkUp.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        return PsiTreeUtilKt.walkUp(psiElement, $this$walkUp.getOffsetInElement());
    }

    private static final boolean hasDeclarationsOrReferences(PsiElement element2, int startOffsetInElement, int searchStringLength) {
        int endOffsetInElement = startOffsetInElement + searchStringLength;
        return Declarations.hasDeclarationsInElement(element2, startOffsetInElement, endOffsetInElement) || ReferencesKt.hasReferencesInElement(element2, startOffsetInElement, endOffsetInElement);
    }

    public static final /* synthetic */ boolean access$isApplicableOccurrence(TextOccurrence occurrence, int searchStringLength) {
        return TextSearchKt.isApplicableOccurrence(occurrence, searchStringLength);
    }

    public static final /* synthetic */ boolean access$isApplicableOccurrence(TextOccurrence occurrence, int searchStringLength, boolean comments, boolean strings2, boolean plainText) {
        return TextSearchKt.isApplicableOccurrence(occurrence, searchStringLength, comments, strings2, plainText);
    }
}

