/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class SegmentArrayWithData
extends SegmentArray {
    private DataStorage myStorage;

    public SegmentArrayWithData(@NotNull DataStorage storage) {
        if (storage == null) {
            SegmentArrayWithData.$$$reportNull$$$0(0);
        }
        this.myStorage = storage;
    }

    @NotNull
    public DataStorage createStorage() {
        DataStorage dataStorage = this.myStorage.createStorage();
        if (dataStorage == null) {
            SegmentArrayWithData.$$$reportNull$$$0(1);
        }
        return dataStorage;
    }

    public void setElementAt(int i, int startOffset, int endOffset, int data2) {
        this.setElementAt(i, startOffset, endOffset);
        this.myStorage.setData(i, data2);
    }

    @Override
    public void remove(int startIndex, int endIndex) {
        this.myStorage.remove(startIndex, endIndex, this.mySegmentCount);
        super.remove(startIndex, endIndex);
    }

    public void replace(int startIndex, int endIndex, @NotNull SegmentArrayWithData newData) {
        if (newData == null) {
            SegmentArrayWithData.$$$reportNull$$$0(2);
        }
        int oldLen = endIndex - startIndex;
        int newLen = newData.getSegmentCount();
        int delta = newLen - oldLen;
        if (delta < 0) {
            this.remove(endIndex + delta, endIndex);
        } else if (delta > 0) {
            SegmentArrayWithData deltaData = new SegmentArrayWithData(this.myStorage.createStorage());
            for (int i = oldLen; i < newLen; ++i) {
                deltaData.setElementAt(i - oldLen, newData.getSegmentStart(i), newData.getSegmentEnd(i), newData.getSegmentData(i));
            }
            this.insert(deltaData, startIndex + oldLen);
        }
        int common = Math.min(newLen, oldLen);
        this.replace(startIndex, newData, common);
    }

    protected void replace(int startOffset, @NotNull SegmentArrayWithData data2, int len) {
        if (data2 == null) {
            SegmentArrayWithData.$$$reportNull$$$0(3);
        }
        this.myStorage.replace(data2.myStorage, startOffset, len);
        super.replace(startOffset, data2, len);
    }

    public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
        if (segmentArray == null) {
            SegmentArrayWithData.$$$reportNull$$$0(4);
        }
        this.myStorage.insert(segmentArray.myStorage, startIndex, segmentArray.getSegmentCount(), this.mySegmentCount);
        super.insert(segmentArray, startIndex);
    }

    public int getSegmentData(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        return this.myStorage.getData(index);
    }

    static int @NotNull [] reallocateArray(int @NotNull [] array, int index) {
        if (array == null) {
            SegmentArrayWithData.$$$reportNull$$$0(5);
        }
        if (index < array.length) {
            if (array == null) {
                SegmentArrayWithData.$$$reportNull$$$0(6);
            }
            return array;
        }
        int[] nArray = ArrayUtil.realloc(array, SegmentArrayWithData.calcCapacity(array.length, index));
        if (nArray == null) {
            SegmentArrayWithData.$$$reportNull$$$0(7);
        }
        return nArray;
    }

    @NotNull
    public SegmentArrayWithData copy() {
        SegmentArrayWithData sa = new SegmentArrayWithData(this.createStorage());
        sa.mySegmentCount = this.mySegmentCount;
        sa.myStarts = (int[])this.myStarts.clone();
        sa.myEnds = (int[])this.myEnds.clone();
        sa.myStorage = this.myStorage.copy();
        SegmentArrayWithData segmentArrayWithData = sa;
        if (segmentArrayWithData == null) {
            SegmentArrayWithData.$$$reportNull$$$0(8);
        }
        return segmentArrayWithData;
    }

    public int unpackStateFromData(int data2) {
        return this.myStorage.unpackStateFromData(data2);
    }

    @NotNull
    public IElementType unpackTokenFromData(int data2) {
        IElementType iElementType = this.myStorage.unpackTokenFromData(data2);
        if (iElementType == null) {
            SegmentArrayWithData.$$$reportNull$$$0(9);
        }
        return iElementType;
    }

    public int packData(@NotNull IElementType tokenType, int state, boolean isRestartableState) {
        if (tokenType == null) {
            SegmentArrayWithData.$$$reportNull$$$0(10);
        }
        return this.myStorage.packData(tokenType, state, isRestartableState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/SegmentArrayWithData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentArray";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/SegmentArrayWithData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackTokenFromData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "packData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

