/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.richcopy.SyntaxInfoBuilder;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.editor.richcopy.view.HtmlTransferableData;
import com.intellij.openapi.editor.richcopy.view.RawTextWithMarkup;
import com.intellij.openapi.editor.richcopy.view.RtfTransferableData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextWithMarkupProcessor
extends CopyPastePostProcessor<RawTextWithMarkup> {
    private static final Logger LOG = Logger.getInstance(TextWithMarkupProcessor.class);
    private List<RawTextWithMarkup> myResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<RawTextWithMarkup> collectTransferableData(@NotNull PsiFile file2, @NotNull Editor editor2, int @NotNull [] startOffsets, int @NotNull [] endOffsets) {
        block24: {
            List<RawTextWithMarkup> list2;
            if (file2 == null) {
                TextWithMarkupProcessor.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                TextWithMarkupProcessor.$$$reportNull$$$0(1);
            }
            if (startOffsets == null) {
                TextWithMarkupProcessor.$$$reportNull$$$0(2);
            }
            if (endOffsets == null) {
                TextWithMarkupProcessor.$$$reportNull$$$0(3);
            }
            if (!RichCopySettings.getInstance().isEnabled()) {
                List<RawTextWithMarkup> list3 = Collections.emptyList();
                if (list3 == null) {
                    TextWithMarkupProcessor.$$$reportNull$$$0(4);
                }
                return list3;
            }
            EditorHighlighter highlighter = null;
            EditorColorsScheme editorColorsScheme = editor2.getColorsScheme();
            EditorColorsScheme schemeToUse = RichCopySettings.getInstance().getColorsScheme(editorColorsScheme);
            try {
                int indentSymbolsToStrip;
                int firstLineStartOffset;
                List carets = editor2.getCaretModel().getAllCarets();
                Caret firstCaret = (Caret)carets.get(0);
                if (Registry.is("editor.richcopy.strip.indents") && carets.size() == 1) {
                    Pair<Integer, Integer> p = TextWithMarkupProcessor.calcIndentSymbolsToStrip(editor2.getDocument(), firstCaret.getSelectionStart(), firstCaret.getSelectionEnd());
                    firstLineStartOffset = (Integer)p.first;
                    indentSymbolsToStrip = (Integer)p.second;
                } else {
                    firstLineStartOffset = firstCaret.getSelectionStart();
                    indentSymbolsToStrip = 0;
                }
                TextWithMarkupProcessor.logInitial(editor2, startOffsets, endOffsets, indentSymbolsToStrip, firstLineStartOffset);
                CharSequence text2 = editor2.getDocument().getCharsSequence();
                highlighter = editor2.getHighlighter();
                if (editorColorsScheme != schemeToUse) {
                    highlighter.setColorScheme(schemeToUse);
                }
                MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)file2.getProject(), (boolean)false);
                SyntaxInfoBuilder.Context context2 = new SyntaxInfoBuilder.Context(text2, schemeToUse, indentSymbolsToStrip);
                int endOffset = 0;
                Caret prevCaret = null;
                for (Caret caret : carets) {
                    int startOffsetToUse;
                    int caretSelectionStart = caret.getSelectionStart();
                    int caretSelectionEnd = caret.getSelectionEnd();
                    int additionalShift = 0;
                    if (caret == firstCaret) {
                        startOffsetToUse = firstLineStartOffset;
                    } else {
                        startOffsetToUse = caretSelectionStart;
                        assert (prevCaret != null);
                        String prevCaretSelectedText = prevCaret.getSelectedText();
                        int fillStringLength = prevCaretSelectedText == null ? 0 : prevCaretSelectedText.length() - (prevCaret.getSelectionEnd() - prevCaret.getSelectionStart());
                        context2.addCharacter(endOffset + fillStringLength);
                        additionalShift = fillStringLength + 1;
                    }
                    context2.reset(endOffset - caretSelectionStart + additionalShift);
                    endOffset = caretSelectionEnd;
                    prevCaret = caret;
                    if (endOffset <= startOffsetToUse) continue;
                    SyntaxInfoBuilder.MyMarkupIterator markupIterator = SyntaxInfoBuilder.createMarkupIterator(highlighter, text2, schemeToUse, markupModel, startOffsetToUse, endOffset);
                    try {
                        context2.iterate(markupIterator, endOffset);
                    }
                    finally {
                        markupIterator.dispose();
                    }
                }
                SyntaxInfo syntaxInfo = context2.finish();
                TextWithMarkupProcessor.logSyntaxInfo(syntaxInfo);
                this.createResult(syntaxInfo, editor2);
                List<RawTextWithMarkup> list4 = ObjectUtils.notNull(this.myResult, Collections.emptyList());
                list2 = list4;
            }
            catch (Throwable t) {
                LOG.error("Error generating text with markup", t, new Attachment("highlighter.txt", String.valueOf(highlighter)));
                break block24;
            }
            finally {
                if (highlighter != null && editorColorsScheme != schemeToUse) {
                    highlighter.setColorScheme(editorColorsScheme);
                }
            }
            if (list2 == null) {
                TextWithMarkupProcessor.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List<RawTextWithMarkup> list5 = Collections.emptyList();
        if (list5 == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(6);
        }
        return list5;
    }

    void createResult(SyntaxInfo syntaxInfo, Editor editor2) {
        this.myResult = new ArrayList<RawTextWithMarkup>(2);
        this.myResult.add(new HtmlTransferableData(syntaxInfo, EditorUtil.getTabSize((Editor)editor2)));
        this.myResult.add(new RtfTransferableData(syntaxInfo));
    }

    private void setRawText(String rawText) {
        if (this.myResult == null) {
            return;
        }
        for (RawTextWithMarkup data2 : this.myResult) {
            data2.setRawText(rawText);
        }
        this.myResult = null;
    }

    private static void logInitial(@NotNull Editor editor2, int @NotNull [] startOffsets, int @NotNull [] endOffsets, int indentSymbolsToStrip, int firstLineStartOffset) {
        if (editor2 == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(7);
        }
        if (startOffsets == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(8);
        }
        if (endOffsets == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(9);
        }
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        Document document = editor2.getDocument();
        CharSequence text2 = document.getCharsSequence();
        for (int i = 0; i < startOffsets.length; ++i) {
            int start2 = startOffsets[i];
            int lineStart = document.getLineStartOffset(document.getLineNumber(start2));
            int end = endOffsets[i];
            int lineEnd = document.getLineEndOffset(document.getLineNumber(end));
            buffer.append("    region #").append(i).append(": ").append(start2).append('-').append(end).append(", text at range ").append(lineStart).append('-').append(lineEnd).append(": \n'").append(text2.subSequence(lineStart, lineEnd)).append("'\n");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        LOG.debug(String.format("Preparing syntax-aware text. Given: %s selection, indent symbols to strip=%d, first line start offset=%d, selected text:%n%s", startOffsets.length > 1 ? "block" : "regular", indentSymbolsToStrip, firstLineStartOffset, buffer));
    }

    private static void logSyntaxInfo(@NotNull SyntaxInfo info) {
        if (info == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(10);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructed syntax info: " + info);
        }
    }

    private static Pair<Integer, Integer> calcIndentSymbolsToStrip(@NotNull Document document, int startOffset, int endOffset) {
        if (document == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(11);
        }
        int startLine = document.getLineNumber(startOffset);
        int endLine = document.getLineNumber(endOffset);
        CharSequence text2 = document.getCharsSequence();
        int maximumCommonIndent = Integer.MAX_VALUE;
        int firstLineStart = startOffset;
        int firstLineEnd = startOffset;
        for (int line = startLine; line <= endLine; ++line) {
            int indent;
            int lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            if (line == startLine) {
                firstLineStart = lineStartOffset;
                firstLineEnd = lineEndOffset;
            }
            int nonWsOffset = lineEndOffset;
            for (int i = lineStartOffset; i < lineEndOffset && i - lineStartOffset < maximumCommonIndent && i < endOffset; ++i) {
                char c = text2.charAt(i);
                if (c == ' ' || c == '\t') continue;
                nonWsOffset = i;
                break;
            }
            if (nonWsOffset < lineEndOffset && (maximumCommonIndent = Math.min(maximumCommonIndent, indent = nonWsOffset - lineStartOffset)) == 0) break;
        }
        int startOffsetToUse = Math.min(firstLineEnd, Math.max(startOffset, firstLineStart + maximumCommonIndent));
        return Pair.create(startOffsetToUse, maximumCommonIndent);
    }

    @Override
    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(13);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startOffsets";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endOffsets";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTransferableData";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logInitial";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logSyntaxInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcIndentSymbolsToStrip";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RawTextSetter
    implements CopyPastePreProcessor {
        private final TextWithMarkupProcessor myProcessor = CopyPastePostProcessor.EP_NAME.findExtensionOrFail(TextWithMarkupProcessor.class);

        RawTextSetter() {
        }

        @Override
        @Nullable
        public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text2) {
            this.myProcessor.setRawText(text2);
            return null;
        }

        @Override
        @NotNull
        public String preprocessOnPaste(Project project2, PsiFile file2, Editor editor2, String text2, RawText rawText) {
            String string2 = text2;
            if (string2 == null) {
                RawTextSetter.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor2, @NotNull Project project2) {
            if (editor2 == null) {
                RawTextSetter.$$$reportNull$$$0(1);
            }
            if (project2 == null) {
                RawTextSetter.$$$reportNull$$$0(2);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor$RawTextSetter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "preprocessOnPaste";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor$RawTextSetter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "requiresAllDocumentsToBeCommitted";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

