/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.fileEditor.FileNavigator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenFileDescriptor
implements FileEditorNavigatable,
Comparable<OpenFileDescriptor> {
    public static final DataKey<Editor> NAVIGATE_IN_EDITOR = DataKey.create((String)"NAVIGATE_IN_EDITOR");
    private final Project myProject;
    private final VirtualFile myFile;
    private final int myLogicalLine;
    private final int myLogicalColumn;
    private final int myOffset;
    private final RangeMarker myRangeMarker;
    private boolean myUseCurrentWindow;
    private boolean myUsePreviewTab;
    private ScrollType myScrollType;

    public OpenFileDescriptor(@NotNull Project project2, @NotNull VirtualFile file2, int offset) {
        if (project2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(1);
        }
        this(project2, file2, -1, -1, offset, false);
    }

    public OpenFileDescriptor(@NotNull Project project2, @NotNull VirtualFile file2, int logicalLine, int logicalColumn) {
        if (project2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(3);
        }
        this(project2, file2, logicalLine, logicalColumn, -1, false);
    }

    public OpenFileDescriptor(@NotNull Project project2, @NotNull VirtualFile file2, int logicalLine, int logicalColumn, boolean persistent) {
        if (project2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(5);
        }
        this(project2, file2, logicalLine, logicalColumn, -1, persistent);
    }

    public OpenFileDescriptor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(7);
        }
        this(project2, file2, -1, -1, -1, false);
    }

    private OpenFileDescriptor(@NotNull Project project2, @NotNull VirtualFile file2, int logicalLine, int logicalColumn, int offset, boolean persistent) {
        if (project2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(9);
        }
        this.myScrollType = ScrollType.CENTER;
        this.myProject = project2;
        this.myFile = file2;
        this.myLogicalLine = logicalLine;
        this.myLogicalColumn = logicalColumn;
        this.myOffset = offset;
        this.myRangeMarker = offset >= 0 ? LazyRangeMarkerFactory.getInstance(project2).createRangeMarker(file2, offset) : (logicalLine >= 0 ? LazyRangeMarkerFactory.getInstance(project2).createRangeMarker(file2, logicalLine, Math.max(0, logicalColumn), persistent) : null);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(10);
        }
        return virtualFile2;
    }

    public RangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }

    public int getOffset() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid() ? this.myRangeMarker.getStartOffset() : this.myOffset;
    }

    public int getLine() {
        return this.myLogicalLine;
    }

    public int getColumn() {
        return this.myLogicalColumn;
    }

    public void navigate(boolean requestFocus) {
        FileNavigator.getInstance().navigate(this, requestFocus);
    }

    public boolean navigateInEditor(@NotNull Project project2, boolean requestFocus) {
        if (project2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(11);
        }
        return FileNavigator.getInstance().navigateInEditor(this, requestFocus);
    }

    public void navigateIn(@NotNull Editor e) {
        if (e == null) {
            OpenFileDescriptor.$$$reportNull$$$0(12);
        }
        OpenFileDescriptor.navigateInEditor(this, e);
    }

    protected static void navigateInEditor(@NotNull OpenFileDescriptor descriptor, @NotNull Editor e) {
        if (descriptor == null) {
            OpenFileDescriptor.$$$reportNull$$$0(13);
        }
        if (e == null) {
            OpenFileDescriptor.$$$reportNull$$$0(14);
        }
        int offset = descriptor.getOffset();
        CaretModel caretModel = e.getCaretModel();
        boolean caretMoved = false;
        if (descriptor.getLine() >= 0) {
            LogicalPosition pos = new LogicalPosition(descriptor.getLine(), Math.max(descriptor.getColumn(), 0));
            if (offset < 0 || offset == e.logicalPositionToOffset(pos)) {
                caretModel.removeSecondaryCarets();
                caretModel.moveToLogicalPosition(pos);
                caretMoved = true;
            }
        }
        if (!caretMoved && offset >= 0) {
            caretModel.removeSecondaryCarets();
            caretModel.moveToOffset(Math.min(offset, e.getDocument().getTextLength()));
            caretMoved = true;
        }
        if (caretMoved) {
            e.getSelectionModel().removeSelection();
            FileEditorManager.getInstance(descriptor.getProject()).runWhenLoaded(e, () -> {
                descriptor.scrollToCaret(e);
                OpenFileDescriptor.unfoldCurrentLine(e);
            });
        }
    }

    protected static void unfoldCurrentLine(@NotNull Editor editor2) {
        if (editor2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(15);
        }
        FoldRegion[] allRegions = editor2.getFoldingModel().getAllFoldRegions();
        TextRange range = OpenFileDescriptor.getRangeToUnfoldOnNavigation(editor2);
        editor2.getFoldingModel().runBatchFoldingOperation(() -> {
            for (FoldRegion region : allRegions) {
                if (region.isExpanded() || !range.intersects(TextRange.create((Segment)region))) continue;
                region.setExpanded(true);
            }
        });
    }

    @NotNull
    public static TextRange getRangeToUnfoldOnNavigation(@NotNull Editor editor2) {
        if (editor2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(16);
        }
        int offset = editor2.getCaretModel().getOffset();
        int line = editor2.getDocument().getLineNumber(offset);
        int start2 = editor2.getDocument().getLineStartOffset(line);
        int end = editor2.getDocument().getLineEndOffset(line);
        return new TextRange(start2, end);
    }

    private void scrollToCaret(@NotNull Editor e) {
        if (e == null) {
            OpenFileDescriptor.$$$reportNull$$$0(17);
        }
        e.getScrollingModel().scrollToCaret(this.myScrollType);
    }

    public boolean canNavigate() {
        return FileNavigator.getInstance().canNavigate(this);
    }

    public boolean canNavigateToSource() {
        return FileNavigator.getInstance().canNavigateToSource(this);
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            OpenFileDescriptor.$$$reportNull$$$0(18);
        }
        return project2;
    }

    @NotNull
    public OpenFileDescriptor setUseCurrentWindow(boolean search2) {
        this.myUseCurrentWindow = search2;
        OpenFileDescriptor openFileDescriptor = this;
        if (openFileDescriptor == null) {
            OpenFileDescriptor.$$$reportNull$$$0(19);
        }
        return openFileDescriptor;
    }

    public boolean isUseCurrentWindow() {
        return this.myUseCurrentWindow;
    }

    @NotNull
    public OpenFileDescriptor setUsePreviewTab(boolean usePreviewTab) {
        this.myUsePreviewTab = usePreviewTab;
        OpenFileDescriptor openFileDescriptor = this;
        if (openFileDescriptor == null) {
            OpenFileDescriptor.$$$reportNull$$$0(20);
        }
        return openFileDescriptor;
    }

    public boolean isUsePreviewTab() {
        return this.myUsePreviewTab;
    }

    public void setScrollType(@NotNull ScrollType scrollType) {
        if (scrollType == null) {
            OpenFileDescriptor.$$$reportNull$$$0(21);
        }
        this.myScrollType = scrollType;
    }

    public void dispose() {
        if (this.myRangeMarker != null) {
            this.myRangeMarker.dispose();
        }
    }

    @Override
    public int compareTo(@NotNull OpenFileDescriptor o) {
        int i;
        if (o == null) {
            OpenFileDescriptor.$$$reportNull$$$0(22);
        }
        if ((i = this.myProject.getName().compareTo(o.myProject.getName())) != 0) {
            return i;
        }
        i = this.myFile.getName().compareTo(o.myFile.getName());
        if (i != 0) {
            return i;
        }
        if (this.myRangeMarker != null) {
            if (o.myRangeMarker == null) {
                return 1;
            }
            i = this.myRangeMarker.getStartOffset() - o.myRangeMarker.getStartOffset();
            if (i != 0) {
                return i;
            }
            return this.myRangeMarker.getEndOffset() - o.myRangeMarker.getEndOffset();
        }
        return o.myRangeMarker == null ? 0 : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 18: 
            case 19: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/OpenFileDescriptor";
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/OpenFileDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setUseCurrentWindow";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "setUsePreviewTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "navigateInEditor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "navigateIn";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unfoldCurrentLine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToUnfoldOnNavigation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCaret";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setScrollType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

