/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@State(name="OSFileAssociationPreferences", storages={@Storage(value="osFileIdePreferences.xml", roamingType=RoamingType.DISABLED)})
public final class OSFileAssociationPreferences
implements PersistentStateComponent<OSFileAssociationPreferences> {
    private static final Logger LOG = Logger.getInstance(OSFileAssociationPreferences.class);
    public List<String> fileTypeNames = new ArrayList<String>();
    public String ideLocationHash;

    public static OSFileAssociationPreferences getInstance() {
        return ApplicationManager.getApplication().getService(OSFileAssociationPreferences.class);
    }

    @Override
    @NotNull
    public OSFileAssociationPreferences getState() {
        OSFileAssociationPreferences oSFileAssociationPreferences = this;
        if (oSFileAssociationPreferences == null) {
            OSFileAssociationPreferences.$$$reportNull$$$0(0);
        }
        return oSFileAssociationPreferences;
    }

    @Override
    public void loadState(@NotNull OSFileAssociationPreferences state) {
        if (state == null) {
            OSFileAssociationPreferences.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean(state, this);
    }

    public void updateFileTypes(List<? extends FileType> fileTypes) {
        this.fileTypeNames.clear();
        this.fileTypeNames.addAll(ContainerUtil.map(fileTypes, fileType -> fileType.getName()));
        this.updateIdeLocationHash();
    }

    boolean ideLocationChanged() {
        return !Objects.equals(this.ideLocationHash, OSFileAssociationPreferences.getIdeLocationHash());
    }

    void updateIdeLocationHash() {
        this.ideLocationHash = OSFileAssociationPreferences.getIdeLocationHash();
    }

    @Nullable
    private static String getIdeLocationHash() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(PathManager.getHomePath().getBytes(StandardCharsets.UTF_8));
            StringBuilder result2 = new StringBuilder();
            for (byte b : messageDigest.digest()) {
                result2.append(String.format("%02X", b));
            }
            return result2.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e);
            return null;
        }
    }

    public boolean contains(@NotNull FileType fileType) {
        if (fileType == null) {
            OSFileAssociationPreferences.$$$reportNull$$$0(2);
        }
        return this.fileTypeNames.stream().anyMatch(name2 -> name2.equals(fileType.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/associate/OSFileAssociationPreferences";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/OSFileAssociationPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

