/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsTestScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.IntObjectMap;
import org.jetbrains.annotations.NotNull;

public class ModuleScopeProviderImpl
implements ModuleScopeProvider {
    private final Module myModule;
    private final IntObjectMap<GlobalSearchScope> myScopeCache;
    private ModuleWithDependentsTestScope myModuleTestsWithDependentsScope;

    public ModuleScopeProviderImpl(@NotNull Module module) {
        if (module == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(0);
        }
        this.myScopeCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.myModule = module;
    }

    @NotNull
    private GlobalSearchScope getCachedScope(@ModuleWithDependenciesScope.ScopeConstant int options) {
        GlobalSearchScope scope = this.myScopeCache.get(options);
        if (scope == null) {
            scope = new ModuleWithDependenciesScope(this.myModule, options);
            this.myScopeCache.put(options, scope);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope() {
        return this.getCachedScope(9);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        return this.getCachedScope(1 | (includeTests ? 8 : 0));
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        return this.getCachedScope(11);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        return this.getCachedScope(13);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        return this.getCachedScope(32);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        return this.getCachedScope(36);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        return this.getCachedScope(7 | (includeTests ? 8 : 0));
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.getModuleTestsWithDependentsScope().getDelegate();
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public ModuleWithDependentsTestScope getModuleTestsWithDependentsScope() {
        ModuleWithDependentsTestScope scope = this.myModuleTestsWithDependentsScope;
        if (scope == null) {
            this.myModuleTestsWithDependentsScope = scope = new ModuleWithDependentsTestScope(this.myModule);
        }
        ModuleWithDependentsTestScope moduleWithDependentsTestScope = scope;
        if (moduleWithDependentsTestScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(3);
        }
        return moduleWithDependentsTestScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        return this.getCachedScope(6 | (includeTests ? 8 : 0));
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleProductionSourceScope() {
        return this.getCachedScope(0);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleTestSourceScope() {
        return this.getCachedScope(8);
    }

    @Override
    public void clearCache() {
        this.myScopeCache.clear();
        this.myModuleTestsWithDependentsScope = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependentsScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTestsWithDependentsScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

