/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.colors.pages;

import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.colors.AbstractKeyDescriptor;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

final class ColorSettingsPagesImpl
extends ColorSettingsPages
implements Disposable {
    private final Map<Object, Pair<ColorAndFontDescriptorsProvider, ? extends AbstractKeyDescriptor<?>>> myCache = ConcurrentFactoryMap.createMap(this::getDescriptorImpl);

    ColorSettingsPagesImpl() {
        ColorAndFontDescriptorsProvider.EP_NAME.addChangeListener(this.myCache::clear, this);
        ColorSettingsPage.EP_NAME.addChangeListener(this.myCache::clear, this);
    }

    public void registerPage(ColorSettingsPage page2) {
        ColorSettingsPage.EP_NAME.getPoint().registerExtension(page2);
    }

    public ColorSettingsPage[] getRegisteredPages() {
        return (ColorSettingsPage[])ColorSettingsPage.EP_NAME.getExtensions();
    }

    @Nullable
    public Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor> getAttributeDescriptor(TextAttributesKey key) {
        return this.myCache.get(key);
    }

    @Nullable
    public Pair<ColorAndFontDescriptorsProvider, ColorDescriptor> getColorDescriptor(ColorKey key) {
        return this.myCache.get(key);
    }

    @Nullable
    private Pair<ColorAndFontDescriptorsProvider, ? extends AbstractKeyDescriptor<?>> getDescriptorImpl(Object key) {
        JBIterable<ColorSettingsPage[]> providers2 = JBIterable.empty();
        for (ColorAndFontDescriptorsProvider colorAndFontDescriptorsProvider : providers2.append(this.getRegisteredPages()).append((ColorSettingsPage[])ColorAndFontDescriptorsProvider.EP_NAME.getExtensionList())) {
            Iterable<Object> descriptors = key instanceof TextAttributesKey ? ColorSettingsUtil.getAllAttributeDescriptors((ColorAndFontDescriptorsProvider)colorAndFontDescriptorsProvider) : (key instanceof ColorKey ? JBIterable.of(colorAndFontDescriptorsProvider.getColorDescriptors()) : Collections.emptyList());
            for (AbstractKeyDescriptor descriptor : descriptors) {
                if (descriptor.getKey() != key) continue;
                return new Pair<ColorAndFontDescriptorsProvider, AbstractKeyDescriptor>(colorAndFontDescriptorsProvider, descriptor);
            }
        }
        return null;
    }

    @Override
    public void dispose() {
    }
}

