/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.hash.Hashing;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderLogger;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerWSL;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListParser;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.LocallyFoundJdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.PendingJdkRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.WSLDistributionForJdkInstaller;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H&J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0004J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u0018\u001a\u00020\rH\u0014J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0011J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&J$\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\u0012\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0016\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0011J\u0016\u0010,\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0011J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0011H\u0002J#\u0010.\u001a\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u000b\u0012\t\u0018\u00010\u001f\u00a2\u0006\u0002\b00/2\u0006\u00101\u001a\u00020\u001fJ\u0010\u00102\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00142\u0006\u00104\u001a\u00020\u0011H\u0014R\u001f\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerBase;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$annotations", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "myLock", "Ljava/util/concurrent/locks/ReentrantLock;", "myPendingDownloads", "Ljava/util/HashMap;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/PendingJdkRequest;", "Lkotlin/collections/HashMap;", "defaultInstallDir", "Ljava/nio/file/Path;", "newVersion", "wslDistribution", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/WSLDistributionForJdkInstaller;", "installDir", "findAlreadyInstalledJdk", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "feedItem", "distribution", "findHistoryRoots", "", "findJdkItemForInstalledJdk", "jdkPath", "jdkHome", "", "installJdk", "", "request", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "installJdkImpl", "markerFile", "prepareJdkInstallation", "jdkItem", "targetPath", "prepareJdkInstallationDirect", "prepareJdkInstallationImpl", "validateInstallDir", "Lkotlin/Pair;", "Lorg/jetbrains/annotations/Nls;", "selectedPath", "writeMarkerFile", "wslDistributionFromPath", "targetDir", "intellij.platform.lang.impl"})
public abstract class JdkInstallerBase {
    @NotNull
    private final Logger LOG;
    private final ReentrantLock myLock;
    private final HashMap<JdkItem, PendingJdkRequest> myPendingDownloads;

    protected static /* synthetic */ void getLOG$annotations() {
    }

    @NotNull
    protected final Logger getLOG() {
        return this.LOG;
    }

    @NotNull
    public abstract Path defaultInstallDir();

    @NotNull
    public Path defaultInstallDir(@Nullable WSLDistributionForJdkInstaller wslDistribution) {
        return this.defaultInstallDir();
    }

    @NotNull
    public final Path defaultInstallDir(@NotNull JdkItem newVersion) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        return this.defaultInstallDir(this.defaultInstallDir(), newVersion);
    }

    @NotNull
    protected final Path defaultInstallDir(@NotNull Path installDir, @NotNull JdkItem newVersion) {
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        Path targetDir = installDir.resolve(newVersion.getInstallFolderName());
        int count2 = 1;
        Path uniqueDir = targetDir;
        while (true) {
            Path path2 = uniqueDir;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"uniqueDir");
            if (!PathKt.exists(path2)) break;
            Path path3 = targetDir;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"targetDir");
            uniqueDir = path3.getParent().resolve(targetDir.getFileName() + "-" + count2++);
        }
        Path path4 = uniqueDir.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"uniqueDir.toAbsolutePath()");
        return path4;
    }

    @NotNull
    public final Pair<Path, String> validateInstallDir(@NotNull String selectedPath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)selectedPath, (String)"selectedPath");
        if (StringsKt.isBlank((CharSequence)selectedPath)) {
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.empty", (Object[])new Object[0]));
        }
        File[] fileArray = this;
        try {
            JdkInstallerBase $this$runCatching = fileArray;
            boolean bl = false;
            object = Result.constructor-impl((Object)Paths.get(FileUtil.expandUserHome(selectedPath), new String[0]));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        fileArray = object;
        object = Result.exceptionOrNull-impl((Object)fileArray);
        if (object != null) {
            Object t = object;
            boolean bl = false;
            this.LOG.warn("Failed to resolve user path: " + selectedPath + ". " + ((Throwable)t).getMessage(), (Throwable)t);
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.resolving.path", (Object[])new Object[0]));
        }
        Path targetDir = (Path)fileArray;
        if (Files.isRegularFile(targetDir, new LinkOption[0])) {
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.exists.file", (Object[])new Object[0]));
        }
        if (Files.isDirectory(targetDir, new LinkOption[0])) {
            File[] fileArray2 = targetDir.toFile().listFiles();
            if (fileArray2 != null) {
                fileArray = fileArray2;
                if (!(fileArray.length == 0)) {
                    return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.exists.nonEmpty.dir", (Object[])new Object[0]));
                }
            }
        }
        return TuplesKt.to((Object)targetDir, null);
    }

    public final void installJdk(@NotNull JdkInstallRequest request2, @Nullable ProgressIndicator indicator, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (request2 instanceof LocallyFoundJdk) {
            return;
        }
        if (request2 instanceof PendingJdkRequest) {
            ((PendingJdkRequest)request2).tryStartInstallOrWait(indicator, (Function0<Unit>)((Function0)new Function0<Unit>(this, request2, indicator, project2){
                final /* synthetic */ JdkInstallerBase this$0;
                final /* synthetic */ JdkInstallRequest $request;
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ Project $project;

                public final void invoke() {
                    this.this$0.installJdkImpl(this.$request, this.$indicator, this.$project);
                }
                {
                    this.this$0 = jdkInstallerBase;
                    this.$request = jdkInstallRequest;
                    this.$indicator = progressIndicator;
                    this.$project = project2;
                    super(0);
                }
            }));
            return;
        }
        this.LOG.error("Unexpected JdkInstallRequest: " + request2 + " of type " + request2.getClass().getName());
        this.installJdkImpl(request2, indicator, project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void installJdkImpl(@NotNull JdkInstallRequest request2, @Nullable ProgressIndicator indicator, @Nullable Project project2) {
        Object sizeDiff;
        Object object;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        JdkItem item = request2.getItem();
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(ProjectBundle.message((String)"progress.text.installing.jdk.1", (Object[])new Object[]{item.getFullPresentationText()}));
        }
        Path targetDir = request2.getInstallDir();
        Url url = Urls.parse((String)item.getUrl(), (boolean)false);
        if (url == null) {
            String string2 = "Cannot parse download URL: " + item.getUrl();
            throw new IllegalStateException(string2.toString());
        }
        Url url2 = url;
        if (!StringsKt.equals((String)url2.getScheme(), (String)"https", (boolean)true)) {
            String string3 = "URL must use https:// protocol, but was: " + url2;
            throw new IllegalStateException(string3.toString());
        }
        WSLDistributionForJdkInstaller wslDistribution = this.wslDistributionFromPath(targetDir);
        if (wslDistribution != null && Intrinsics.areEqual((Object)item.getOs(), (Object)"linux") ^ true) {
            String string4 = "Cannot install non-linux JDK into WSL environment to " + targetDir + " from " + item;
            throw new IllegalStateException(string4.toString());
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText2(ProjectBundle.message((String)"progress.text2.downloading.jdk", (Object[])new Object[0]));
        }
        Path downloadFile = Paths.get(PathManager.getTempPath(), FileUtil.sanitizeFileName("jdk-" + System.nanoTime() + "-" + item.getArchiveFileName()));
        try {
            Object $this$runCatching;
            Object $this$runCatching2;
            try {
                HttpRequests.request((String)item.getUrl()).productNameAsUserAgent().saveToFile(downloadFile.toFile(), indicator);
                Path path2 = downloadFile;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"downloadFile");
                if (!PathKt.isFile(path2)) {
                    throw (Throwable)new RuntimeException("Downloaded file does not exist: " + downloadFile);
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ControlFlowException)) throw (Throwable)new RuntimeException("Failed to download " + item.getFullPresentationText() + " from " + url2 + ". " + t.getMessage(), t);
                throw t;
            }
            object = this;
            try {
                $this$runCatching2 = object;
                boolean bl2 = false;
                $this$runCatching2 = Result.constructor-impl((Object)(Files.size(downloadFile) - item.getArchiveSize()));
            }
            catch (Throwable bl2) {
                $this$runCatching2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = $this$runCatching2;
            sizeDiff = (Long)(Result.isFailure-impl((Object)object) ? null : object);
            Long l = sizeDiff;
            if (l == null || l != 0L) {
                Object object2;
                String string2 = item.getFullPresentationText();
                Long l2 = sizeDiff;
                if (l2 != null) {
                    long l3 = l2;
                    object2 = Math.abs(l3);
                    throw (Throwable)new RuntimeException("The downloaded " + string2 + " has incorrect file size,\nthe difference is " + object2 + " bytes.\nCheck your internet connection and try again later");
                }
                object2 = "unknown";
                throw (Throwable)new RuntimeException("The downloaded " + string2 + " has incorrect file size,\nthe difference is " + object2 + " bytes.\nCheck your internet connection and try again later");
            }
            $this$runCatching2 = this;
            try {
                $this$runCatching = (JdkInstallerBase)$this$runCatching2;
                boolean bl3 = false;
                $this$runCatching = Result.constructor-impl((Object)com.google.common.io.Files.asByteSource((File)downloadFile.toFile()).hash(Hashing.sha256()).toString());
            }
            catch (Throwable bl3) {
                $this$runCatching = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            $this$runCatching2 = $this$runCatching;
            String actualHashCode = (String)(Result.isFailure-impl((Object)$this$runCatching2) ? null : $this$runCatching2);
            if (!StringsKt.equals((String)actualHashCode, (String)item.getSha256(), (boolean)true)) {
                String string3 = item.getFullPresentationText();
                String string4 = actualHashCode;
                if (string4 != null) {
                    throw (Throwable)new RuntimeException("Failed to verify SHA-256 checksum for " + string3 + "\n\nThe actual value is " + string4 + ",\nbut expected " + item.getSha256() + " was expected\nCheck your internet connection and try again later");
                }
                string4 = "unknown";
                throw (Throwable)new RuntimeException("Failed to verify SHA-256 checksum for " + string3 + "\n\nThe actual value is " + string4 + ",\nbut expected " + item.getSha256() + " was expected\nCheck your internet connection and try again later");
            }
            ProgressIndicator progressIndicator3 = indicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setIndeterminate(true);
            }
            ProgressIndicator progressIndicator4 = indicator;
            if (progressIndicator4 != null) {
                progressIndicator4.setText2(ProjectBundle.message((String)"progress.text2.unpacking.jdk", (Object[])new Object[0]));
            }
            try {
                boolean bl;
                if (wslDistribution != null) {
                    JdkInstallerWSL.INSTANCE.unpackJdkOnWsl(wslDistribution, item.getPackageType(), downloadFile, targetDir, item.getPackageRootPrefix());
                } else {
                    Object it = $this$runCatching2 = item.getPackageType().openDecompressor(downloadFile).entryFilter(new Predicate(indicator){
                        final /* synthetic */ ProgressIndicator $indicator;

                        public final boolean test(Decompressor.Entry it) {
                            block0: {
                                ProgressIndicator progressIndicator = this.$indicator;
                                if (progressIndicator == null) break block0;
                                progressIndicator.checkCanceled();
                            }
                            return true;
                        }
                        {
                            this.$indicator = progressIndicator;
                        }
                    });
                    bl = false;
                    String fullMatchPath = StringsKt.trim((String)item.getPackageRootPrefix(), (char[])new char[]{'/'});
                    ((Decompressor)(StringsKt.isBlank((CharSequence)fullMatchPath) ? it : ((Decompressor)it).removePrefixPath(fullMatchPath))).extract(targetDir);
                }
                $this$runCatching2 = this;
                try {
                    $this$runCatching = (JdkInstallerBase)$this$runCatching2;
                    bl = false;
                    super.writeMarkerFile(request2);
                    $this$runCatching = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    $this$runCatching = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                JdkDownloaderLogger.INSTANCE.logDownload(true);
            }
            catch (Throwable t) {
                if (!(t instanceof ControlFlowException)) throw (Throwable)new RuntimeException("Failed to extract " + item.getFullPresentationText() + ". " + t.getMessage(), t);
                throw t;
            }
            sizeDiff = this;
        }
        catch (Throwable t) {
            try {
                JdkDownloaderLogger.INSTANCE.logDownload(false);
                PathKt.delete$default(targetDir, false, 1, null);
                Path path3 = this.markerFile(targetDir);
                if (path3 == null) throw t;
                PathKt.delete$default(path3, false, 1, null);
                throw t;
            }
            catch (Throwable throwable) {
                JdkInstallerBase jdkInstallerBase = this;
                try {
                    JdkInstallerBase $this$runCatching4 = jdkInstallerBase;
                    boolean bl5 = false;
                    FileUtil.delete(downloadFile);
                    Object object3 = Result.constructor-impl((Object)Unit.INSTANCE);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                throw throwable;
            }
        }
        try {
            JdkInstallerBase $this$runCatching3 = (JdkInstallerBase)sizeDiff;
            boolean bl4 = false;
            FileUtil.delete(downloadFile);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
            return;
        }
        catch (Throwable bl4) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JdkInstallRequest prepareJdkInstallation(@NotNull JdkItem jdkItem, @NotNull Path targetPath) {
        WSLDistributionForJdkInstaller distribution;
        JdkInstallRequest existingRequest;
        Intrinsics.checkNotNullParameter((Object)jdkItem, (String)"jdkItem");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        if (Registry.is("jdk.downloader.reuse.installed") && (existingRequest = this.findAlreadyInstalledJdk(jdkItem, distribution = this.wslDistributionFromPath(targetPath))) != null) {
            return existingRequest;
        }
        if (Registry.is("jdk.downloader.reuse.downloading")) {
            PendingJdkRequest pendingJdkRequest;
            Lock lock = this.myLock;
            lock.lock();
            try {
                boolean bl = false;
                PendingJdkRequest pendingJdkRequest2 = this.myPendingDownloads.computeIfAbsent(jdkItem, new Function(this, jdkItem, targetPath){
                    final /* synthetic */ JdkInstallerBase this$0;
                    final /* synthetic */ JdkItem $jdkItem$inlined;
                    final /* synthetic */ Path $targetPath$inlined;
                    {
                        this.this$0 = jdkInstallerBase;
                        this.$jdkItem$inlined = jdkItem;
                        this.$targetPath$inlined = path2;
                    }

                    @NotNull
                    public final PendingJdkRequest apply(@NotNull JdkItem it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return JdkInstallerBase.access$prepareJdkInstallationImpl(this.this$0, this.$jdkItem$inlined, this.$targetPath$inlined);
                    }
                });
                pendingJdkRequest = pendingJdkRequest2;
            }
            finally {
                lock.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)pendingJdkRequest, (String)"myLock.withLock {\n      \u2026em, targetPath) }\n      }");
            return pendingJdkRequest;
        }
        return this.prepareJdkInstallationDirect(jdkItem, targetPath);
    }

    @NotNull
    public final JdkInstallRequest prepareJdkInstallationDirect(@NotNull JdkItem jdkItem, @NotNull Path targetPath) {
        Intrinsics.checkNotNullParameter((Object)jdkItem, (String)"jdkItem");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        return this.prepareJdkInstallationImpl(jdkItem, targetPath);
    }

    /*
     * WARNING - void declaration
     */
    private final PendingJdkRequest prepareJdkInstallationImpl(JdkItem jdkItem, Path targetPath) {
        void home2;
        Pair<Path, String> pair = this.validateInstallDir(((Object)targetPath).toString());
        Path path2 = (Path)pair.component1();
        String error = (String)pair.component2();
        if (home2 == null || error != null) {
            String string2 = error;
            if (string2 == null) {
                string2 = "Invalid Target Directory";
            }
            throw (Throwable)new RuntimeException(string2);
        }
        Path javaHome = jdkItem.resolveJavaHome(targetPath);
        Files.createDirectories(javaHome, new FileAttribute[0]);
        PendingJdkRequest request2 = new PendingJdkRequest(jdkItem, targetPath, javaHome);
        this.writeMarkerFile(request2);
        return request2;
    }

    private final Path markerFile(Path installDir) {
        Path path2 = installDir.getParent();
        return path2 != null ? path2.resolve("." + installDir.getFileName() + ".intellij") : null;
    }

    private final void writeMarkerFile(JdkInstallRequest request2) {
        Path installDir = request2.getInstallDir();
        Path path2 = this.markerFile(installDir);
        if (path2 == null) {
            return;
        }
        Path markerFile2 = path2;
        try {
            request2.getItem().writeMarkerFile(markerFile2);
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            this.LOG.warn("Failed to write marker file to " + markerFile2 + ". " + t.getMessage(), t);
        }
    }

    @Nullable
    public final JdkItem findJdkItemForInstalledJdk(@Nullable String jdkHome) {
        try {
            if (jdkHome == null) {
                return null;
            }
            Path jdkPath = Paths.get(jdkHome, new String[0]);
            return this.findJdkItemForInstalledJdk(jdkPath);
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JdkItem findJdkItemForInstalledJdk(@Nullable Path jdkPath) {
        try {
            Object v0;
            JdkPredicate predicate;
            block6: {
                void $this$firstOrNull$iv;
                if (jdkPath == null) {
                    return null;
                }
                if (!PathKt.isDirectory(jdkPath)) {
                    return null;
                }
                predicate = WslPath.Companion.isWslUncPath(((Object)jdkPath).toString()) ? JdkPredicate.Companion.forWSL() : JdkPredicate.Companion.default();
                Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.take((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)jdkPath, (Function1)findJdkItemForInstalledJdk.markerFile.1.INSTANCE), (Function1)findJdkItemForInstalledJdk.markerFile.2.INSTANCE), (int)5), (Function1)((Function1)new Function1<Path, Path>(this){
                    final /* synthetic */ JdkInstallerBase this$0;

                    @Nullable
                    public final Path invoke(@NotNull Path it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return JdkInstallerBase.access$markerFile(this.this$0, it);
                    }
                    {
                        this.this$0 = jdkInstallerBase;
                        super(1);
                    }
                }));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    if (!PathKt.isFile(it)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            Path path2 = v0;
            if (path2 == null) {
                return null;
            }
            Path markerFile2 = path2;
            ObjectNode json = JdkListParser.INSTANCE.readTree(PathKt.readBytes(markerFile2));
            return (JdkItem)CollectionsKt.firstOrNull(JdkListParser.INSTANCE.parseJdkItem(json, predicate));
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JdkInstallRequest findAlreadyInstalledJdk(JdkItem feedItem, WSLDistributionForJdkInstaller distribution) {
        try {
            List list2;
            JdkInstallerBase jdkInstallerBase;
            JdkInstallerBase $this$run = jdkInstallerBase = this;
            boolean bl = false;
            Path defaultInstallDir = $this$run.defaultInstallDir(distribution);
            if (!PathKt.isDirectory(defaultInstallDir)) {
                list2 = CollectionsKt.emptyList();
            } else {
                AutoCloseable autoCloseable = Files.list(defaultInstallDir);
                Throwable throwable = null;
                try {
                    Stream it = (Stream)autoCloseable;
                    boolean bl2 = false;
                    Stream stream = it;
                    Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"it");
                    List list3 = StreamsKt.toList((Stream)stream);
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            List localRoots = list2;
            List<Path> historyRoots = this.findHistoryRoots(feedItem);
            Iterator iterator = CollectionsKt.plus((Collection)localRoots, (Iterable)historyRoots).iterator();
            while (iterator.hasNext()) {
                Path jdkHome;
                JdkItem item;
                Path installDir;
                Path path2 = installDir = (Path)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"installDir");
                if (!PathKt.isDirectory(path2)) continue;
                if (this.findJdkItemForInstalledJdk(installDir) == null) {
                    continue;
                }
                if (Intrinsics.areEqual((Object)item, (Object)feedItem) ^ true || !PathKt.isDirectory(jdkHome = item.resolveJavaHome(installDir)) || !JdkUtil.checkForJdk((Path)jdkHome) || !Intrinsics.areEqual((Object)this.wslDistributionFromPath(jdkHome), (Object)distribution)) continue;
                return new LocallyFoundJdk(feedItem, installDir, jdkHome);
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    @NotNull
    protected List<Path> findHistoryRoots(@NotNull JdkItem feedItem) {
        Intrinsics.checkNotNullParameter((Object)feedItem, (String)"feedItem");
        return CollectionsKt.emptyList();
    }

    @Nullable
    protected WSLDistributionForJdkInstaller wslDistributionFromPath(@NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        return null;
    }

    public JdkInstallerBase() {
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG = logger;
        this.myLock = new ReentrantLock();
        this.myPendingDownloads = new HashMap();
    }

    public static final /* synthetic */ PendingJdkRequest access$prepareJdkInstallationImpl(JdkInstallerBase $this, JdkItem jdkItem, Path targetPath) {
        return $this.prepareJdkInstallationImpl(jdkItem, targetPath);
    }

    public static final /* synthetic */ Path access$markerFile(JdkInstallerBase $this, Path installDir) {
        return $this.markerFile(installDir);
    }
}

