/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.ide.actions.SettingsEntryPointAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdateNotification;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdateNotification$performUpdateAction$2$run$;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdateNotificationKt;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u000234B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u001bH\u0002J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0000H\u0002J\u0006\u0010*\u001a\u00020\fJ\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010.\u001a\u00020\tJ\u0010\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\u0005H\u0002J\u0012\u00101\u001a\u00020\f2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0000J\f\u00102\u001a\u00020\t*\u00020\u001bH\u0002R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u001f\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0015\u0010\"\u001a\u00060#R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification;", "", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "oldItem", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "newItem", "whenComplete", "Lkotlin/Function1;", "", "(Lcom/intellij/openapi/projectRoots/Sdk;Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;Lkotlin/jvm/functions/Function1;)V", "isUpdateActionVisible", "", "()Z", "getJdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "jdkHome", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/Nullable;", "jdkVersion", "Lcom/intellij/openapi/util/NlsSafe;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "myIsTerminated", "myIsUpdateRunning", "myRetryNotification", "Lcom/intellij/notification/Notification;", "getNewItem", "()Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "getOldItem", "persistentId", "getPersistentId", "()Ljava/lang/String;", "updateAction", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification$JdkUpdateSuggestionAction;", "getUpdateAction", "()Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification$JdkUpdateSuggestionAction;", "bindNextNotification", "notification", "isSameNotification", "other", "isTerminated", "performUpdateAction", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "reachTerminalState", "showUpdateErrorNotification", "feedItem", "tryReplaceWithNewerNotification", "bindNextNotificationAndShow", "InstallUpdateNotification", "JdkUpdateSuggestionAction", "intellij.platform.lang.impl"})
public final class JdkUpdateNotification {
    private final ReentrantLock lock;
    private final String jdkVersion;
    private final String jdkHome;
    private boolean myIsTerminated;
    private boolean myIsUpdateRunning;
    private Notification myRetryNotification;
    @NotNull
    private final String persistentId;
    @NotNull
    private final JdkUpdateSuggestionAction updateAction;
    @NotNull
    private final Sdk jdk;
    @NotNull
    private final JdkItem oldItem;
    @NotNull
    private final JdkItem newItem;
    private final Function1<JdkUpdateNotification, Unit> whenComplete;

    @NotNull
    public final String getPersistentId() {
        return this.persistentId;
    }

    private final void bindNextNotificationAndShow(Notification $this$bindNextNotificationAndShow) {
        this.bindNextNotification($this$bindNextNotificationAndShow);
        $this$bindNextNotificationAndShow.notify(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void bindNextNotification(Notification notification) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Notification notification2 = this.myRetryNotification;
            if (notification2 != null) {
                notification2.expire();
            }
            notification.whenExpired(new Runnable(this, notification){
                final /* synthetic */ JdkUpdateNotification this$0;
                final /* synthetic */ Notification $notification$inlined;
                {
                    this.this$0 = jdkUpdateNotification;
                    this.$notification$inlined = notification;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    Lock lock = JdkUpdateNotification.access$getLock$p(this.this$0);
                    lock.lock();
                    try {
                        boolean bl = false;
                        if (JdkUpdateNotification.access$getMyRetryNotification$p(this.this$0) == this.$notification$inlined) {
                            JdkUpdateNotification.access$setMyRetryNotification$p(this.this$0, null);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            });
            this.myRetryNotification = notification;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryReplaceWithNewerNotification(@Nullable JdkUpdateNotification other) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.myIsUpdateRunning) {
                boolean bl2 = false;
                return bl2;
            }
            if (other != null && this.isSameNotification(other)) {
                boolean bl3 = false;
                return bl3;
            }
            Notification notification = this.myRetryNotification;
            if (notification != null) {
                notification.expire();
            }
            this.myRetryNotification = null;
            this.reachTerminalState();
            boolean bl4 = true;
            return bl4;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ boolean tryReplaceWithNewerNotification$default(JdkUpdateNotification jdkUpdateNotification, JdkUpdateNotification jdkUpdateNotification2, int n, Object object) {
        if ((n & 1) != 0) {
            jdkUpdateNotification2 = null;
        }
        return jdkUpdateNotification.tryReplaceWithNewerNotification(jdkUpdateNotification2);
    }

    private final boolean isSameNotification(JdkUpdateNotification other) {
        if (Intrinsics.areEqual((Object)this.jdkVersion, (Object)other.jdkVersion) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.jdkHome, (Object)other.jdkHome) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.newItem, (Object)other.newItem) ^ true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reachTerminalState() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.myIsTerminated) {
                return;
            }
            this.myIsTerminated = true;
            this.whenComplete.invoke((Object)this);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isTerminated() {
        boolean bl;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl2 = false;
            bl = this.myIsTerminated;
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    @NotNull
    public final JdkUpdateSuggestionAction getUpdateAction() {
        return this.updateAction;
    }

    public final boolean isUpdateActionVisible() {
        return !this.myIsUpdateRunning && !this.myIsTerminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void showUpdateErrorNotification(JdkItem feedItem) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("JDK Update Error");
            String string2 = ProjectBundle.message((String)"progress.title.updating.jdk.0.to.1", (Object[])new Object[]{this.jdk.getName(), feedItem.getFullPresentationText()});
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ProjectBundle.message(\"p\u2026tem.fullPresentationText)");
            String string3 = ProjectBundle.message((String)"progress.title.updating.jdk.failed", (Object[])new Object[]{feedItem.getFullPresentationText()});
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ProjectBundle.message(\"p\u2026tem.fullPresentationText)");
            Notification notification = notificationGroup.createNotification(string2, string3, NotificationType.ERROR).addAction((AnAction)new InstallUpdateNotification());
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"NotificationGroupManager\u2026tallUpdateNotification())");
            this.bindNextNotificationAndShow(notification);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performUpdateAction(AnActionEvent e) {
        Notification notification = this.myRetryNotification;
        if (notification != null) {
            notification.expire();
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.myIsUpdateRunning) {
                return;
            }
            this.myIsUpdateRunning = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        String string2 = ProjectBundle.message((String)"progress.title.updating.jdk.0.to.1", (Object[])new Object[]{this.jdk.getName(), this.newItem.getFullPresentationText()});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ProjectBundle.message(\"p\u2026tem.fullPresentationText)");
        String title = string2;
        ProgressManager.getInstance().run(new Task.Backgroundable(this, e, title, null, title, true, Task.Backgroundable.ALWAYS_BACKGROUND){
            final /* synthetic */ JdkUpdateNotification this$0;
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ String $title;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Object installer;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    installer = JdkInstaller.Companion.getInstance();
                    JdkInstallRequest request2 = ((JdkInstallerBase)installer).prepareJdkInstallation(this.this$0.getNewItem(), ((JdkInstallerBase)installer).defaultInstallDir(this.this$0.getNewItem()));
                    ((JdkInstallerBase)installer).installJdk(request2, indicator, this.$e.getProject());
                    indicator.setText(ProjectBundle.message((String)"progress.text.updating.jdk.setting.up", (Object[])new Object[0]));
                    VfsUtil.markDirtyAndRefresh(false, true, true, request2.getInstallDir().toFile());
                    installer = request2.getJavaHome();
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        this.this$0.reachTerminalState();
                        throw t;
                    }
                    JdkUpdateNotificationKt.access$getLOG$p().warn("Failed to update " + this.this$0.getJdk() + " to " + this.this$0.getNewItem() + ". " + t.getMessage(), t);
                    JdkUpdateNotification.access$showUpdateErrorNotification(this.this$0, this.this$0.getNewItem());
                    Lock lock = JdkUpdateNotification.access$getLock$p(this.this$0);
                    lock.lock();
                    try {
                        boolean bl = false;
                        JdkUpdateNotification.access$setMyIsUpdateRunning$p(this.this$0, false);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                    return;
                }
                Object newJdkHome = installer;
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this, (Path)newJdkHome){
                    final /* synthetic */ performUpdateAction.2 this$0;
                    final /* synthetic */ Path $newJdkHome$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$newJdkHome$inlined = path2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        boolean bl = false;
                        try {
                            boolean $i$f$runWriteAction = false;
                            ApplicationManager.getApplication().runWriteAction(new Computable(this){
                                final /* synthetic */ performUpdateAction$2$run$$inlined$invokeLater$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final T compute() {
                                    SdkModificator sdkModificator;
                                    boolean bl = false;
                                    SdkModificator $this$apply = sdkModificator = this.this$0.this$0.this$0.getJdk().getSdkModificator();
                                    boolean bl2 = false;
                                    $this$apply.removeAllRoots();
                                    $this$apply.setHomePath(PathKt.getSystemIndependentPath(this.this$0.$newJdkHome$inlined));
                                    $this$apply.setVersionString(this.this$0.this$0.this$0.getNewItem().getVersionString());
                                    sdkModificator.commitChanges();
                                    SdkTypeId sdkTypeId = this.this$0.this$0.this$0.getJdk().getSdkType();
                                    if (!(sdkTypeId instanceof SdkType)) {
                                        sdkTypeId = null;
                                    }
                                    SdkType sdkType = (SdkType)sdkTypeId;
                                    if (sdkType != null) {
                                        sdkType.setupSdkPaths(this.this$0.this$0.this$0.getJdk());
                                    }
                                    this.this$0.this$0.this$0.reachTerminalState();
                                    return (T)Unit.INSTANCE;
                                }
                            });
                        }
                        catch (Throwable t) {
                            if (t instanceof ControlFlowException) {
                                this.this$0.this$0.reachTerminalState();
                                throw t;
                            }
                            JdkUpdateNotificationKt.access$getLOG$p().warn("Failed to apply downloaded JDK update for " + this.this$0.this$0.getJdk() + " from " + this.this$0.this$0.getNewItem() + " at " + this.$newJdkHome$inlined + ". " + t.getMessage(), t);
                            JdkUpdateNotification.access$showUpdateErrorNotification(this.this$0.this$0, this.this$0.this$0.getNewItem());
                            Lock lock = JdkUpdateNotification.access$getLock$p(this.this$0.this$0);
                            lock.lock();
                            try {
                                boolean bl2 = false;
                                JdkUpdateNotification.access$setMyIsUpdateRunning$p(this.this$0.this$0, false);
                                Unit unit = Unit.INSTANCE;
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable, modalityState);
            }
            {
                this.this$0 = this$0;
                this.$e = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        });
    }

    @NotNull
    public final Sdk getJdk() {
        return this.jdk;
    }

    @NotNull
    public final JdkItem getOldItem() {
        return this.oldItem;
    }

    @NotNull
    public final JdkItem getNewItem() {
        return this.newItem;
    }

    public JdkUpdateNotification(@NotNull Sdk jdk, @NotNull JdkItem oldItem, @NotNull JdkItem newItem, @NotNull Function1<? super JdkUpdateNotification, Unit> whenComplete) {
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        Intrinsics.checkNotNullParameter(whenComplete, (String)"whenComplete");
        this.jdk = jdk;
        this.oldItem = oldItem;
        this.newItem = newItem;
        this.whenComplete = whenComplete;
        this.lock = new ReentrantLock();
        this.jdkVersion = this.jdk.getVersionString();
        this.jdkHome = this.jdk.getHomePath();
        this.persistentId = this.jdk.getName() + "-" + this.oldItem.getFullPresentationText() + "-" + this.newItem.getFullPresentationText() + "-" + this.jdk.getHomePath();
        this.updateAction = new JdkUpdateSuggestionAction();
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(JdkUpdateNotification $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Notification access$getMyRetryNotification$p(JdkUpdateNotification $this) {
        return $this.myRetryNotification;
    }

    public static final /* synthetic */ void access$setMyRetryNotification$p(JdkUpdateNotification $this, Notification notification) {
        $this.myRetryNotification = notification;
    }

    public static final /* synthetic */ void access$showUpdateErrorNotification(JdkUpdateNotification $this, JdkItem feedItem) {
        $this.showUpdateErrorNotification(feedItem);
    }

    public static final /* synthetic */ boolean access$getMyIsUpdateRunning$p(JdkUpdateNotification $this) {
        return $this.myIsUpdateRunning;
    }

    public static final /* synthetic */ void access$setMyIsUpdateRunning$p(JdkUpdateNotification $this, boolean bl) {
        $this.myIsUpdateRunning = bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification$InstallUpdateNotification;", "Lcom/intellij/notification/NotificationAction;", "(Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notification", "Lcom/intellij/notification/Notification;", "intellij.platform.lang.impl"})
    public final class InstallUpdateNotification
    extends NotificationAction {
        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            JdkUpdateNotification.this.performUpdateAction(e);
            notification.expire();
        }

        public InstallUpdateNotification() {
            super(ProjectBundle.message((String)"notification.link.jdk.update.retry", (Object[])new Object[0]));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification$JdkUpdateSuggestionAction;", "Lcom/intellij/ide/actions/SettingsEntryPointAction$UpdateAction;", "(Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification;)V", "jdkUpdateNotification", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification;", "getJdkUpdateNotification", "()Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.lang.impl"})
    public final class JdkUpdateSuggestionAction
    extends SettingsEntryPointAction.UpdateAction {
        @NotNull
        private final JdkUpdateNotification jdkUpdateNotification;

        @NotNull
        public final JdkUpdateNotification getJdkUpdateNotification() {
            return this.jdkUpdateNotification;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabledAndVisible(JdkUpdateNotification.this.isUpdateActionVisible());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            JdkUpdateNotification.this.performUpdateAction(e);
        }

        public JdkUpdateSuggestionAction() {
            this.jdkUpdateNotification = JdkUpdateNotification.this;
            Presentation presentation2 = this.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
            presentation2.setText(ProjectBundle.message((String)"action.title.jdk.update.found", (Object[])new Object[]{JdkUpdateNotification.this.getJdk().getName(), JdkUpdateNotification.this.getNewItem().getFullPresentationText(), JdkUpdateNotification.this.getOldItem().getVersionPresentationText()}));
            Presentation presentation3 = this.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"templatePresentation");
            presentation3.setDescription(ProjectBundle.message((String)"action.description.jdk.update.found", (Object[])new Object[]{JdkUpdateNotification.this.getJdk().getName(), JdkUpdateNotification.this.getNewItem().getFullPresentationText(), JdkUpdateNotification.this.getOldItem().getVersionPresentationText()}));
        }
    }
}

