/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WslPath;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreValidatorCallback;
import com.intellij.openapi.roots.ui.configuration.SdkPopupBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.JavaVersion;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0082\bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0012J7\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\t2\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018\u00a2\u0006\u0002\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidator;", "", "()V", "minJdkFeatureVersion", "", "getMinJdkFeatureVersion$annotations", "getMinJdkFeatureVersion", "()I", "isSupportedSdkItem", "", "versionString", "Lkotlin/Function0;", "", "homePath", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "item", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/roots/ui/configuration/SdkPopupBuilder$SuggestedSdk;", "testNewJdkUnderProgress", "R", "allowRunProcesses", "computeHomePath", "callback", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidatorCallback;", "(ZLkotlin/jvm/functions/Function0;Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidatorCallback;)Ljava/lang/Object;", "intellij.platform.lang.impl"})
public final class RuntimeChooserJreValidator {
    @NotNull
    public static final RuntimeChooserJreValidator INSTANCE;

    private static /* synthetic */ void getMinJdkFeatureVersion$annotations() {
    }

    private final int getMinJdkFeatureVersion() {
        return 11;
    }

    public final boolean isSupportedSdkItem(@NotNull JdkItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (SystemInfo.isMac && !StringsKt.endsWith$default((String)item.getPackageToBinJavaPrefix(), (String)"Contents/Home", (boolean)false, (int)2, null)) {
            return false;
        }
        return item.getJdkMajorVersion() >= this.getMinJdkFeatureVersion() && Intrinsics.areEqual((Object)item.getOs(), (Object)JdkPredicate.Companion.getCurrentOS()) && Intrinsics.areEqual((Object)item.getArch(), (Object)JdkPredicate.Companion.getCurrentArch());
    }

    public final boolean isSupportedSdkItem(@NotNull Sdk sdk2) {
        boolean bl;
        block6: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            RuntimeChooserJreValidator this_$iv = this;
            boolean $i$f$isSupportedSdkItem = false;
            Object object2 = this_$iv;
            try {
                RuntimeChooserJreValidator $this$runCatching$iv = object2;
                boolean bl2 = false;
                boolean bl3 = false;
                String string2 = sdk2.getVersionString();
                if (string2 == null) {
                    bl = false;
                    break block6;
                }
                String version$iv = string2;
                boolean bl4 = false;
                String string3 = sdk2.getHomePath();
                if (string3 == null) {
                    bl = false;
                    break block6;
                }
                String home$iv = string3;
                if (SystemInfo.isMac && !StringsKt.endsWith$default((String)home$iv, (String)"/Contents/Home", (boolean)false, (int)2, null)) {
                    bl = false;
                    break block6;
                }
                JavaVersion javaVersion = JavaVersion.tryParse(version$iv);
                if (javaVersion == null) {
                    bl = false;
                    break block6;
                }
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return false");
                JavaVersion javaVersion$iv = javaVersion;
                object = Result.constructor-impl((Object)(javaVersion$iv.feature >= $this$runCatching$iv.getMinJdkFeatureVersion() && !WslPath.Companion.isWslUncPath(home$iv) ? 1 : 0));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            object = false;
            bl = (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
        }
        return bl;
    }

    public final boolean isSupportedSdkItem(@NotNull SdkPopupBuilder.SuggestedSdk sdk2) {
        boolean bl;
        block6: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            RuntimeChooserJreValidator this_$iv = this;
            boolean $i$f$isSupportedSdkItem = false;
            Object object2 = this_$iv;
            try {
                RuntimeChooserJreValidator $this$runCatching$iv = object2;
                boolean bl2 = false;
                boolean bl3 = false;
                String string2 = sdk2.getVersionString();
                if (string2 == null) {
                    bl = false;
                    break block6;
                }
                String version$iv = string2;
                boolean bl4 = false;
                String string3 = sdk2.getHomePath();
                if (string3 == null) {
                    bl = false;
                    break block6;
                }
                String home$iv = string3;
                if (SystemInfo.isMac && !StringsKt.endsWith$default((String)home$iv, (String)"/Contents/Home", (boolean)false, (int)2, null)) {
                    bl = false;
                    break block6;
                }
                JavaVersion javaVersion = JavaVersion.tryParse(version$iv);
                if (javaVersion == null) {
                    bl = false;
                    break block6;
                }
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return false");
                JavaVersion javaVersion$iv = javaVersion;
                object = Result.constructor-impl((Object)(javaVersion$iv.feature >= $this$runCatching$iv.getMinJdkFeatureVersion() && !WslPath.Companion.isWslUncPath(home$iv) ? 1 : 0));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            object = false;
            bl = (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
        }
        return bl;
    }

    private final boolean isSupportedSdkItem(Function0<String> versionString, Function0<String> homePath) {
        Object object;
        int $i$f$isSupportedSdkItem = 0;
        Object object2 = this;
        try {
            RuntimeChooserJreValidator $this$runCatching = object2;
            boolean bl = false;
            String string2 = (String)versionString.invoke();
            if (string2 == null) {
                return false;
            }
            String version = string2;
            String string3 = (String)homePath.invoke();
            if (string3 == null) {
                return false;
            }
            String home2 = string3;
            if (SystemInfo.isMac && !StringsKt.endsWith$default((String)home2, (String)"/Contents/Home", (boolean)false, (int)2, null)) {
                return false;
            }
            JavaVersion javaVersion = JavaVersion.tryParse(version);
            if (javaVersion == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return false");
            JavaVersion javaVersion2 = javaVersion;
            object = Result.constructor-impl((Object)(javaVersion2.feature >= $this$runCatching.getMinJdkFeatureVersion() && !WslPath.Companion.isWslUncPath(home2) ? 1 : 0));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    public final <R> R testNewJdkUnderProgress(boolean allowRunProcesses, @NotNull Function0<String> computeHomePath, @NotNull RuntimeChooserJreValidatorCallback<R> callback) {
        Object $this$runCatching;
        Path path2;
        Object object3;
        Object $this$runCatching2;
        Intrinsics.checkNotNullParameter(computeHomePath, (String)"computeHomePath");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Object object2 = this;
        try {
            $this$runCatching2 = object2;
            boolean object3 = false;
            $this$runCatching2 = Result.constructor-impl((Object)Path.of((String)computeHomePath.invoke(), new String[0]).toAbsolutePath());
        }
        catch (Throwable object3) {
            $this$runCatching2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)object3));
        }
        object2 = $this$runCatching2;
        Path path3 = (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (path3 == null) {
            String string2 = LangBundle.message("dialog.message.choose.ide.runtime.set.unknown.error", LangBundle.message("dialog.message.choose.ide.runtime.no.file.part", new Object[0]));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LangBundle.message(\"dial\u2026e.runtime.no.file.part\"))");
            return callback.onError(string2);
        }
        Path homeDir = path3;
        if (SystemInfo.isMac && StringsKt.endsWith$default((String)((Object)homeDir).toString(), (String)"/Contents/Home", (boolean)false, (int)2, null)) {
            return this.testNewJdkUnderProgress(allowRunProcesses, (Function0<String>)((Function0)new Function0<String>(homeDir){
                final /* synthetic */ Path $homeDir;

                @Nullable
                public final String invoke() {
                    Path path2 = this.$homeDir.getParent();
                    return path2 != null && (path2 = path2.getParent()) != null ? ((Object)path2).toString() : null;
                }
                {
                    this.$homeDir = path2;
                    super(0);
                }
            }), callback);
        }
        if (SystemInfo.isMac && Intrinsics.areEqual((Object)((Object)homeDir.getFileName()).toString(), (Object)"Contents")) {
            object2 = homeDir;
            $this$runCatching2 = "Home";
            Path path4 = object2.resolve((String)$this$runCatching2);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.resolve(other)");
            if (PathKt.isDirectory(path4)) {
                return this.testNewJdkUnderProgress(allowRunProcesses, (Function0<String>)((Function0)new Function0<String>(homeDir){
                    final /* synthetic */ Path $homeDir;

                    @Nullable
                    public final String invoke() {
                        Path path2 = this.$homeDir.getParent();
                        return path2 != null ? ((Object)path2).toString() : null;
                    }
                    {
                        this.$homeDir = path2;
                        super(0);
                    }
                }), callback);
            }
        }
        if (SystemInfo.isMac) {
            object2 = homeDir;
            $this$runCatching2 = "Contents";
            Path path5 = object2.resolve((String)$this$runCatching2);
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"this.resolve(other)");
            object2 = path5;
            $this$runCatching2 = "Home";
            Path path6 = object2.resolve((String)$this$runCatching2);
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"this.resolve(other)");
            if (!PathKt.isDirectory(path6)) {
                RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". macOS Bundle layout is expected");
                String string3 = LangBundle.message("dialog.message.choose.ide.runtime.set.error.mac.bundle", homeDir);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"LangBundle.message(\"dial\u2026ror.mac.bundle\", homeDir)");
                return callback.onError(string3);
            }
        }
        if (SystemInfo.isWindows && WslPath.Companion.isWslUncPath(((Object)homeDir).toString())) {
            RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". macOS Bundle layout is expected");
            String string4 = LangBundle.message("dialog.message.choose.ide.runtime.set.version.error.wsl", homeDir);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"LangBundle.message(\"dial\u2026sion.error.wsl\", homeDir)");
            callback.onError(string4);
        }
        if (SystemInfo.isWindows) {
            $this$runCatching2 = homeDir;
            object3 = "bin";
            Path path7 = $this$runCatching2.resolve((String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"this.resolve(other)");
            $this$runCatching2 = path7;
            object3 = "java.exe";
            Path path8 = $this$runCatching2.resolve((String)object3);
            path2 = path8;
            Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"this.resolve(other)");
        } else if (SystemInfo.isMac) {
            $this$runCatching2 = homeDir;
            object3 = "Contents";
            Path path9 = $this$runCatching2.resolve((String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"this.resolve(other)");
            $this$runCatching2 = path9;
            object3 = "Home";
            Path path10 = $this$runCatching2.resolve((String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"this.resolve(other)");
            $this$runCatching2 = path10;
            object3 = "bin";
            Path path11 = $this$runCatching2.resolve((String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"this.resolve(other)");
            $this$runCatching2 = path11;
            object3 = "java";
            Path path12 = $this$runCatching2.resolve((String)object3);
            path2 = path12;
            Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"this.resolve(other)");
        } else {
            $this$runCatching2 = homeDir;
            object3 = "bin";
            Path path13 = $this$runCatching2.resolve((String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"this.resolve(other)");
            $this$runCatching2 = path13;
            object3 = "java";
            Path path14 = $this$runCatching2.resolve((String)object3);
            path2 = path14;
            Intrinsics.checkNotNullExpressionValue((Object)path14, (String)"this.resolve(other)");
        }
        Path binJava = path2;
        if (!PathKt.isFile(binJava) || SystemInfo.isUnix && !Files.isExecutable((Path)($this$runCatching2 = binJava))) {
            RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". Failed to find bin/java executable at " + binJava);
            String string5 = LangBundle.message("dialog.message.choose.ide.runtime.set.cannot.start.error", homeDir);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"LangBundle.message(\"dial\u2026ot.start.error\", homeDir)");
            return callback.onError(string5);
        }
        object3 = this;
        try {
            JdkVersionDetector.JdkVersionInfo jdkVersionInfo;
            $this$runCatching = (RuntimeChooserJreValidator)object3;
            boolean bl = false;
            Object object4 = binJava.getParent();
            if (object4 == null || (object4 = object4.getParent()) == null || (object4 = object4.toString()) == null) {
                jdkVersionInfo = null;
            } else {
                Object inferredHome = object4;
                jdkVersionInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo((String)inferredHome);
            }
            $this$runCatching = Result.constructor-impl(jdkVersionInfo);
        }
        catch (Throwable bl) {
            $this$runCatching = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = $this$runCatching;
        JdkVersionDetector.JdkVersionInfo jdkVersionInfo = (JdkVersionDetector.JdkVersionInfo)(Result.isFailure-impl((Object)object3) ? null : object3);
        if (jdkVersionInfo == null) {
            String string6 = LangBundle.message("dialog.message.choose.ide.runtime.set.unknown.error", homeDir);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"LangBundle.message(\"dial\u2026.unknown.error\", homeDir)");
            return callback.onError(string6);
        }
        Intrinsics.checkNotNullExpressionValue((Object)jdkVersionInfo, (String)"runCatching {\n      //we\u2026unknown.error\", homeDir))");
        JdkVersionDetector.JdkVersionInfo info = jdkVersionInfo;
        if (info.version == null || info.version.feature < this.getMinJdkFeatureVersion()) {
            RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". The version " + info + " is less than " + this.getMinJdkFeatureVersion());
            String string7 = LangBundle.message("dialog.message.choose.ide.runtime.set.version.error", homeDir, "11", info.version.toString());
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"LangBundle.message(\"dial\u2026 info.version.toString())");
            return callback.onError(string7);
        }
        String string8 = RuntimeChooserJreKt.access$tryComputeAdvancedFullVersion(binJava);
        if (string8 == null) {
            JavaVersion javaVersion = info.version;
            string8 = javaVersion != null ? javaVersion.toString() : null;
        }
        if (string8 == null) {
            String string9 = LangBundle.message("dialog.message.choose.ide.runtime.set.unknown.error", homeDir);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"LangBundle.message(\"dial\u2026.unknown.error\", homeDir)");
            return callback.onError(string9);
        }
        String jdkVersion = string8;
        if (allowRunProcesses) {
            try {
                GeneralCommandLine cmd = new GeneralCommandLine(new String[]{((Object)binJava).toString(), "-version"});
                ProcessOutput processOutput = new CapturingProcessHandler(cmd).runProcess(30000);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(cmd).runProcess(30_000)");
                int exitCode = processOutput.getExitCode();
                if (exitCode != 0) {
                    RuntimeChooserJreKt.access$getLOG$p().warn("Failed to run JDK for boot runtime: " + homeDir + ". Exit code is " + exitCode + " for " + binJava + ".");
                    String string10 = LangBundle.message("dialog.message.choose.ide.runtime.set.cannot.start.error", homeDir);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"LangBundle.message(\"dial\u2026ot.start.error\", homeDir)");
                    return callback.onError(string10);
                }
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                RuntimeChooserJreKt.access$getLOG$p().warn("Failed to run JDK for boot runtime: " + homeDir + ". " + t.getMessage(), t);
                String string11 = LangBundle.message("dialog.message.choose.ide.runtime.set.cannot.start.error", homeDir);
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"LangBundle.message(\"dial\u2026ot.start.error\", homeDir)");
                return callback.onError(string11);
            }
        }
        return callback.onSdkResolved(info.variant.displayName, jdkVersion, homeDir);
    }

    private RuntimeChooserJreValidator() {
    }

    static {
        RuntimeChooserJreValidator runtimeChooserJreValidator;
        INSTANCE = runtimeChooserJreValidator = new RuntimeChooserJreValidator();
    }
}

