/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryIndexImpl;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.ProjectKt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.EntityIndexingService;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootsChangeListener;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class ProjectRootManagerComponent
extends ProjectRootManagerImpl
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectRootManagerComponent.class);
    private static final boolean LOG_CACHES_UPDATE = ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode();
    private static final ExtensionPointName<WatchedRootsProvider> WATCHED_ROOTS_PROVIDER_EP_NAME = new ExtensionPointName("com.intellij.roots.watchedRootsProvider");
    private final ExecutorService myExecutor;
    @NotNull
    private Future<?> myCollectWatchRootsFuture;
    private boolean myPointerChangesDetected;
    private int myInsideWriteAction;
    @NotNull
    private Set<LocalFileSystem.WatchRequest> myRootsToWatch;
    private Disposable myRootPointersDisposable;
    private final VirtualFilePointerListener myRootsChangedListener;

    public ProjectRootManagerComponent(@NotNull Project project2) {
        if (project2 == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myExecutor = ApplicationManager.getApplication().isUnitTestMode() ? ConcurrencyUtil.newSameThreadExecutorService() : AppExecutorUtil.createBoundedApplicationPoolExecutor("Project Root Manager", 1);
        this.myCollectWatchRootsFuture = CompletableFuture.completedFuture(null);
        this.myRootsToWatch = CollectionFactory.createSmallMemoryFootprintSet();
        this.myRootPointersDisposable = Disposer.newDisposable();
        this.myRootsChangedListener = new VirtualFilePointerListener(){

            @NotNull
            private RootsChangeRescanningInfo getPointersChanges(VirtualFilePointer @NotNull [] pointers2) {
                if (pointers2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                RootsChangeRescanningInfo result2 = null;
                for (VirtualFilePointer pointer : pointers2) {
                    if (pointer.isValid()) {
                        RootsChangeRescanningInfo rootsChangeRescanningInfo = RootsChangeRescanningInfo.TOTAL_RESCAN;
                        if (rootsChangeRescanningInfo == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        return rootsChangeRescanningInfo;
                    }
                    if (result2 != null) continue;
                    result2 = RootsChangeRescanningInfo.NO_RESCAN_NEEDED;
                }
                RootsChangeRescanningInfo rootsChangeRescanningInfo = ObjectUtils.notNull(result2, RootsChangeRescanningInfo.TOTAL_RESCAN);
                if (rootsChangeRescanningInfo == null) {
                    4.$$$reportNull$$$0(2);
                }
                return rootsChangeRescanningInfo;
            }

            @Override
            public void beforeValidityChanged(VirtualFilePointer @NotNull [] pointers2) {
                if (pointers2 == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (ProjectRootManagerComponent.this.myProject.isDisposed()) {
                    return;
                }
                if (!this.isInsideWriteAction() && !ProjectRootManagerComponent.this.myPointerChangesDetected) {
                    ProjectRootManagerComponent.this.myPointerChangesDetected = true;
                    ProjectRootManagerComponent.this.myRootsChanged.levelUp();
                }
                ProjectRootManagerComponent.this.myRootsChanged.beforeRootsChanged();
                if (LOG_CACHES_UPDATE || LOG.isTraceEnabled()) {
                    LOG.trace(new Throwable(pointers2.length > 0 ? pointers2[0].getPresentableUrl() : ""));
                }
            }

            @Override
            public void validityChanged(VirtualFilePointer @NotNull [] pointers2) {
                if (pointers2 == null) {
                    4.$$$reportNull$$$0(4);
                }
                RootsChangeRescanningInfo changeInfo = this.getPointersChanges(pointers2);
                if (ProjectRootManagerComponent.this.myProject.isDisposed()) {
                    return;
                }
                if (this.isInsideWriteAction()) {
                    ProjectRootManagerComponent.this.myRootsChanged.rootsChanged(changeInfo);
                } else {
                    ProjectRootManagerComponent.this.clearScopesCaches();
                }
            }

            private boolean isInsideWriteAction() {
                return ProjectRootManagerComponent.this.myInsideWriteAction == 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pointers";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$4";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPointersChanges";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getPointersChanges";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "beforeValidityChanged";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "validityChanged";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (!this.myProject.isDefault()) {
            this.registerListeners();
        }
    }

    @NotNull
    Set<LocalFileSystem.WatchRequest> getRootsToWatch() {
        Set<LocalFileSystem.WatchRequest> set2 = this.myRootsToWatch;
        if (set2 == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(1);
        }
        return set2;
    }

    private void registerListeners() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect(this);
        connection.subscribe(ProjectManager.TOPIC, new ProjectManagerListener(){

            @Override
            public void projectOpened(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project2 == ProjectRootManagerComponent.this.myProject) {
                    ProjectRootManagerComponent.this.addRootsToWatch();
                    ApplicationManager.getApplication().addApplicationListener(new AppListener(), ProjectRootManagerComponent.this.myProject);
                }
            }

            @Override
            public void projectClosed(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (project2 == ProjectRootManagerComponent.this.myProject) {
                    ProjectRootManagerComponent.this.projectClosed();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, new FileTypeListener(){

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProjectRootManagerComponent.this.myFileTypesChanged.beforeRootsChanged();
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                ProjectRootManagerComponent.this.myFileTypesChanged.rootsChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileTypesChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        StartupManager.getInstance(this.myProject).registerStartupActivity(() -> {
            this.myStartupActivityPerformed = true;
        });
        connection.subscribe(BatchUpdateListener.TOPIC, new BatchUpdateListener(){

            public void onBatchUpdateStarted() {
                ProjectRootManagerComponent.this.myRootsChanged.levelUp();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelUp();
            }

            public void onBatchUpdateFinished() {
                ProjectRootManagerComponent.this.myRootsChanged.levelDown();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelDown();
            }
        });
        Runnable rootsExtensionPointListener = () -> ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> this.makeRootsChange(EmptyRunnable.getInstance(), false, true)));
        AdditionalLibraryRootsProvider.EP_NAME.addChangeListener(rootsExtensionPointListener, this);
        OrderEnumerationHandler.EP_NAME.addChangeListener(rootsExtensionPointListener, this);
    }

    protected void projectClosed() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRootsToWatch);
    }

    @RequiresEdt
    private void addRootsToWatch() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        Disposable oldDisposable = this.myRootPointersDisposable;
        Disposable newDisposable = Disposer.newDisposable();
        this.myCollectWatchRootsFuture.cancel(false);
        this.myCollectWatchRootsFuture = this.myExecutor.submit(() -> {
            Pair watchRoots = ReadAction.compute(() -> this.myProject.isDisposed() ? null : this.collectWatchRoots(newDisposable));
            ModalityUiUtil.invokeLaterIfNeeded(ModalityState.any(), () -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.myRootPointersDisposable = newDisposable;
                Disposer.dispose(oldDisposable);
                this.myRootsToWatch = LocalFileSystem.getInstance().replaceWatchedRoots(this.myRootsToWatch, (Collection)watchRoots.first, (Collection)watchRoots.second);
            });
        });
    }

    @Override
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance(this.myProject);
            if (directoryIndex instanceof DirectoryIndexImpl) {
                ((DirectoryIndexImpl)directoryIndex).reset();
            }
            this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS).beforeRootsChange(new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireRootsChangedEvent(boolean fileTypes, @NotNull List<? extends RootsChangeRescanningInfo> indexingInfos) {
        if (indexingInfos == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(2);
        }
        this.isFiringEvent = true;
        try {
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance(this.myProject);
            if (directoryIndex instanceof DirectoryIndexImpl) {
                ((DirectoryIndexImpl)directoryIndex).reset();
            }
            ThreeState isFromWorkspaceOnly = ThreeState.UNSURE;
            for (RootsChangeRescanningInfo rootsChangeRescanningInfo : indexingInfos) {
                if (rootsChangeRescanningInfo instanceof ProjectRootsChangeListener.WorkspaceEventRescanningInfo && ((ProjectRootsChangeListener.WorkspaceEventRescanningInfo)rootsChangeRescanningInfo).isFromWorkspaceModelEvent()) {
                    if (isFromWorkspaceOnly != ThreeState.UNSURE) continue;
                    isFromWorkspaceOnly = ThreeState.YES;
                    continue;
                }
                isFromWorkspaceOnly = ThreeState.NO;
                break;
            }
            this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS).rootsChanged(new ModuleRootEventImpl(this.myProject, fileTypes, indexingInfos, isFromWorkspaceOnly == ThreeState.YES));
        }
        finally {
            this.isFiringEvent = false;
        }
        this.synchronizeRoots(indexingInfos);
        this.addRootsToWatch();
    }

    @NotNull
    private Pair<Set<String>, Set<String>> collectWatchRoots(@NotNull Disposable disposable) {
        Collection<VirtualFile> toWatch;
        if (disposable == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Set<String> recursivePathsToWatch = CollectionFactory.createFilePathSet();
        Set<String> flatPaths = CollectionFactory.createFilePathSet();
        IProjectStore store = ProjectKt.getStateStore(this.myProject);
        Path projectFilePath = store.getProjectFilePath();
        if (!".idea".equals(projectFilePath.getParent().getFileName().toString())) {
            flatPaths.add(FileUtil.toSystemIndependentName(projectFilePath.toString()));
            flatPaths.add(FileUtil.toSystemIndependentName(store.getWorkspacePath().toString()));
        }
        for (AdditionalLibraryRootsProvider additionalLibraryRootsProvider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            toWatch = additionalLibraryRootsProvider.getRootsToWatch(this.myProject);
            if (toWatch.isEmpty()) continue;
            for (VirtualFile virtualFile2 : toWatch) {
                recursivePathsToWatch.add(virtualFile2.getPath());
            }
        }
        for (WatchedRootsProvider watchedRootsProvider : WATCHED_ROOTS_PROVIDER_EP_NAME.getExtensionList()) {
            toWatch = watchedRootsProvider.getRootsToWatch(this.myProject);
            if (toWatch.isEmpty()) continue;
            for (String string2 : toWatch) {
                recursivePathsToWatch.add(FileUtil.toSystemIndependentName(string2));
            }
        }
        Set<String> excludedUrls = CollectionFactory.createSmallMemoryFootprintSet();
        for (DirectoryIndexExcludePolicy excludePolicy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(this.myProject)) {
            Collections.addAll(excludedUrls, excludePolicy.getExcludeUrlsForProject());
        }
        if (!excludedUrls.isEmpty()) {
            Disposer.register(this, disposable);
            VirtualFilePointerContainer virtualFilePointerContainer = VirtualFilePointerManager.getInstance().createContainer(disposable, this.getRootsValidityChangedListener());
            ((VirtualFilePointerContainerImpl)virtualFilePointerContainer).addAll(excludedUrls);
        }
        this.collectModuleWatchRoots(recursivePathsToWatch, flatPaths);
        return new Pair<Set<String>, Set<String>>(recursivePathsToWatch, flatPaths);
    }

    private void collectModuleWatchRoots(@NotNull Set<? super String> recursivePaths, @NotNull Set<? super String> flatPaths) {
        if (recursivePaths == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(4);
        }
        if (flatPaths == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(5);
        }
        Set<String> urls = CollectionFactory.createFilePathSet();
        for (Module module : ModuleManager.getInstance(this.myProject).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
            ContainerUtil.addAll(urls, rootManager.getContentRootUrls());
            rootManager.orderEntries().withoutModuleSourceEntries().withoutDepModules().forEach(entry -> {
                for (OrderRootType type : OrderRootType.getAllTypes()) {
                    ContainerUtil.addAll(urls, entry.getUrls(type));
                }
                return true;
            });
        }
        for (String url : urls) {
            String protocol = VirtualFileManager.extractProtocol(url);
            if (protocol == null || "file".equals(protocol)) {
                recursivePaths.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if ("jar".equals(protocol)) {
                flatPaths.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if (!"jrt".equals(protocol)) continue;
            recursivePaths.add(ProjectRootManagerComponent.extractLocalPath(url));
        }
    }

    private void synchronizeRoots(@NotNull List<? extends RootsChangeRescanningInfo> indexingInfos) {
        if (indexingInfos == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(6);
        }
        if (!this.myStartupActivityPerformed) {
            return;
        }
        EntityIndexingService.getInstance().indexChanges(this.myProject, indexingInfos);
    }

    @Override
    protected void clearScopesCaches() {
        super.clearScopesCaches();
        LibraryScopeCache libraryScopeCache = this.myProject.getServiceIfCreated(LibraryScopeCache.class);
        if (libraryScopeCache != null) {
            libraryScopeCache.clear();
        }
    }

    @Override
    public void clearScopesCachesForModules() {
        Module[] modules2;
        super.clearScopesCachesForModules();
        for (Module module : modules2 = ModuleManager.getInstance(this.myProject).getModules()) {
            ((ModuleEx)module).clearScopesCache();
        }
    }

    @Override
    public void markRootsForRefresh() {
        Set<String> paths2 = CollectionFactory.createFilePathSet();
        this.collectModuleWatchRoots(paths2, paths2);
        LocalFileSystem fs = LocalFileSystem.getInstance();
        for (String path2 : paths2) {
            VirtualFile root = fs.findFileByPath(path2);
            if (!(root instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)root).markDirtyRecursively();
        }
    }

    @Override
    public void dispose() {
        this.myCollectWatchRootsFuture.cancel(false);
        this.myExecutor.shutdownNow();
    }

    @Override
    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        VirtualFilePointerListener virtualFilePointerListener = this.myRootsChangedListener;
        if (virtualFilePointerListener == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(7);
        }
        return virtualFilePointerListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursivePaths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToWatch";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsValidityChangedListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fireRootsChangedEvent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectWatchRoots";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleWatchRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeRoots";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class AppListener
    implements ApplicationListener {
        private AppListener() {
        }

        @Override
        public void beforeWriteActionStart(@NotNull Object action2) {
            if (action2 == null) {
                AppListener.$$$reportNull$$$0(0);
            }
            ++ProjectRootManagerComponent.this.myInsideWriteAction;
        }

        @Override
        public void writeActionFinished(@NotNull Object action2) {
            if (action2 == null) {
                AppListener.$$$reportNull$$$0(1);
            }
            if (--ProjectRootManagerComponent.this.myInsideWriteAction == 0 && ProjectRootManagerComponent.this.myPointerChangesDetected) {
                ProjectRootManagerComponent.this.myPointerChangesDetected = false;
                ProjectRootManagerComponent.this.myRootsChanged.levelDown();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "action";
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$AppListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeWriteActionStart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeActionFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

