/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryKindRegistryImpl;
import com.intellij.openapi.roots.impl.libraries.UnknownLibraryKind;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryKindRegistry;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.util.ThrowableRunnable;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/roots/impl/libraries/LibraryKindRegistryImpl;", "Lcom/intellij/openapi/roots/libraries/LibraryKindRegistry;", "()V", "forgetKind", "", "kind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "processAllLibraries", "processor", "Lkotlin/Function1;", "rememberKind", "intellij.platform.lang.impl"})
public final class LibraryKindRegistryImpl
extends LibraryKindRegistry {
    private final void processAllLibraries(Function1<? super Library, Unit> processor) {
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTablesRegistrar, (String)"LibraryTablesRegistrar.getInstance()");
        LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTable();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"LibraryTablesRegistrar.getInstance().libraryTable");
        Library[] libraryArray = libraryTable.getLibraries();
        Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"LibraryTablesRegistrar.g\u2026().libraryTable.libraries");
        Library[] $this$forEach$iv = libraryArray;
        boolean $i$f$forEach = false;
        for (Library element$iv : $this$forEach$iv) {
            processor.invoke((Object)element$iv);
        }
        LibraryTablesRegistrar libraryTablesRegistrar2 = LibraryTablesRegistrar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTablesRegistrar2, (String)"LibraryTablesRegistrar.getInstance()");
        Iterator<LibraryTable> iterator = libraryTablesRegistrar2.getCustomLibraryTables().iterator();
        while (iterator.hasNext()) {
            Library[] $this$forEach$iv2;
            LibraryTable table;
            LibraryTable libraryTable2 = table = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)libraryTable2, (String)"table");
            Intrinsics.checkNotNullExpressionValue((Object)libraryTable2.getLibraries(), (String)"table.libraries");
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int element$iv = 0; element$iv < n; ++element$iv) {
                Library element$iv2 = $this$forEach$iv2[element$iv];
                processor.invoke((Object)element$iv2);
            }
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        for (Project project2 : projectManager.getOpenProjects()) {
            Library[] $this$forEach$iv3;
            LibraryTable libraryTable3 = LibraryTablesRegistrar.getInstance().getLibraryTable(project2);
            Intrinsics.checkNotNullExpressionValue((Object)libraryTable3, (String)"LibraryTablesRegistrar.g\u2026.getLibraryTable(project)");
            Intrinsics.checkNotNullExpressionValue((Object)libraryTable3.getLibraries(), (String)"LibraryTablesRegistrar.g\u2026yTable(project).libraries");
            boolean $i$f$forEach3 = false;
            for (Library element$iv : $this$forEach$iv3) {
                processor.invoke((Object)element$iv);
            }
            ModuleManager moduleManager = ModuleManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            for (Module module : moduleManager.getModules()) {
                Iterator<Library> iterator2 = OrderEntryUtil.getModuleLibraries(ModuleRootManager.getInstance(module)).iterator();
                while (iterator2.hasNext()) {
                    Library library2;
                    Library library3 = library2 = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)library3, (String)"library");
                    processor.invoke((Object)library3);
                }
            }
        }
    }

    private final void forgetKind(PersistentLibraryKind<?> kind, Library library2) {
        Library library3 = library2;
        if (library3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        }
        if (Intrinsics.areEqual(kind, ((LibraryEx)library3).getKind())) {
            LibraryEx.ModifiableModelEx modifiableModelEx = ((LibraryEx)library2).getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableModelEx, (String)"library.modifiableModel");
            LibraryEx.ModifiableModelEx model2 = modifiableModelEx;
            model2.forgetKind();
            model2.commit();
        }
    }

    private final void rememberKind(PersistentLibraryKind<?> kind, Library library2) {
        Library library3 = library2;
        if (library3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        }
        PersistentLibraryKind<?> persistentLibraryKind = ((LibraryEx)library3).getKind();
        if (!(persistentLibraryKind instanceof UnknownLibraryKind)) {
            persistentLibraryKind = null;
        }
        UnknownLibraryKind unknownLibraryKind = (UnknownLibraryKind)persistentLibraryKind;
        if (Intrinsics.areEqual((Object)(unknownLibraryKind != null ? unknownLibraryKind.getKindId() : null), (Object)kind.getKindId())) {
            LibraryEx.ModifiableModelEx modifiableModelEx = ((LibraryEx)library2).getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableModelEx, (String)"library.modifiableModel");
            LibraryEx.ModifiableModelEx model2 = modifiableModelEx;
            model2.restoreKind();
            model2.commit();
        }
    }

    private LibraryKindRegistryImpl() {
        ExtensionPointName<LibraryType<?>> extensionPointName = LibraryType.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"LibraryType.EP_NAME");
        extensionPointName.getExtensionList();
        LibraryType.EP_NAME.addExtensionPointListener(new ExtensionPointListener<LibraryType<?>>(){

            @Override
            public void extensionAdded(@NotNull LibraryType<?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                WriteAction.run(new ThrowableRunnable(this, extension2){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ LibraryType $extension;

                    public final void run() {
                        LibraryKind.registerKind(this.$extension.getKind());
                        LibraryKindRegistryImpl.access$processAllLibraries(this.this$0.this, (Function1)new Function1<Library, Unit>(this){
                            final /* synthetic */ extensionAdded.1 this$0;

                            public final void invoke(@NotNull Library it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                LibraryKindRegistryImpl libraryKindRegistryImpl = this.this$0.this$0.this;
                                LibraryKind libraryKind = this.this$0.$extension.getKind();
                                Intrinsics.checkNotNullExpressionValue((Object)libraryKind, (String)"extension.kind");
                                LibraryKindRegistryImpl.access$rememberKind(libraryKindRegistryImpl, (PersistentLibraryKind)libraryKind, it);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$extension = libraryType;
                    }
                });
            }

            @Override
            public void extensionRemoved(@NotNull LibraryType<?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                LibraryKind.unregisterKind(extension2.getKind());
                this.processAllLibraries((Function1<? super Library, Unit>)((Function1)new Function1<Library, Unit>(this, extension2){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ LibraryType $extension;

                    public final void invoke(@NotNull Library it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        LibraryKindRegistryImpl libraryKindRegistryImpl = this.this$0.this;
                        LibraryKind libraryKind = this.$extension.getKind();
                        Intrinsics.checkNotNullExpressionValue((Object)libraryKind, (String)"extension.kind");
                        LibraryKindRegistryImpl.access$forgetKind(libraryKindRegistryImpl, (PersistentLibraryKind)libraryKind, it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$extension = libraryType;
                        super(1);
                    }
                }));
            }
        }, null);
    }

    public static final /* synthetic */ void access$rememberKind(LibraryKindRegistryImpl $this, PersistentLibraryKind kind, Library library2) {
        $this.rememberKind(kind, library2);
    }

    public static final /* synthetic */ void access$forgetKind(LibraryKindRegistryImpl $this, PersistentLibraryKind kind, Library library2) {
        $this.forgetKind(kind, library2);
    }
}

