/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean isClassAvailableInLibrary(@NotNull Library library2, @NotNull String fqn) {
        if (library2 == null) {
            LibraryUtil.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            LibraryUtil.$$$reportNull$$$0(1);
        }
        return LibraryUtil.isClassAvailableInLibrary(library2.getFiles(OrderRootType.CLASSES), fqn);
    }

    public static boolean isClassAvailableInLibrary(VirtualFile @NotNull [] files2, @NotNull String fqn) {
        if (fqn == null) {
            LibraryUtil.$$$reportNull$$$0(2);
        }
        if (files2 == null) {
            LibraryUtil.$$$reportNull$$$0(3);
        }
        return LibraryUtil.isClassAvailableInLibrary(Arrays.asList(files2), fqn);
    }

    public static boolean isClassAvailableInLibrary(@NotNull List<? extends VirtualFile> files2, @NotNull String fqn) {
        if (files2 == null) {
            LibraryUtil.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            LibraryUtil.$$$reportNull$$$0(5);
        }
        for (VirtualFile virtualFile2 : files2) {
            if (!LibraryUtil.findInFile(virtualFile2, new StringTokenizer(fqn, "."))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Library findLibraryByClass(@NotNull String fqn, @Nullable Project project2) {
        LibraryTable projectTable;
        Library library2;
        if (fqn == null) {
            LibraryUtil.$$$reportNull$$$0(6);
        }
        if (project2 != null && (library2 = LibraryUtil.findInTable(projectTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project2), fqn)) != null) {
            return library2;
        }
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable();
        return LibraryUtil.findInTable(table, fqn);
    }

    private static boolean findInFile(@NotNull VirtualFile file2, @NotNull StringTokenizer tokenizer) {
        VirtualFile child;
        if (file2 == null) {
            LibraryUtil.$$$reportNull$$$0(7);
        }
        if (tokenizer == null) {
            LibraryUtil.$$$reportNull$$$0(8);
        }
        if (!tokenizer.hasMoreTokens()) {
            return true;
        }
        @NonNls StringBuilder name2 = new StringBuilder(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            name2.append(".class");
        }
        return (child = file2.findChild(name2.toString())) != null && LibraryUtil.findInFile(child, tokenizer);
    }

    @Nullable
    private static Library findInTable(@NotNull LibraryTable table, @NotNull String fqn) {
        if (table == null) {
            LibraryUtil.$$$reportNull$$$0(9);
        }
        if (fqn == null) {
            LibraryUtil.$$$reportNull$$$0(10);
        }
        for (Library library2 : table.getLibraries()) {
            if (!LibraryUtil.isClassAvailableInLibrary(library2, fqn)) continue;
            return library2;
        }
        return null;
    }

    @NotNull
    public static Library createLibrary(@NotNull LibraryTable libraryTable, @NonNls @NotNull String baseName) {
        if (libraryTable == null) {
            LibraryUtil.$$$reportNull$$$0(11);
        }
        if (baseName == null) {
            LibraryUtil.$$$reportNull$$$0(12);
        }
        Object name2 = baseName;
        int count2 = 2;
        while (libraryTable.getLibraryByName((String)name2) != null) {
            name2 = baseName + " (" + count2++ + ")";
        }
        Library library2 = libraryTable.createLibrary((String)name2);
        if (library2 == null) {
            LibraryUtil.$$$reportNull$$$0(13);
        }
        return library2;
    }

    public static VirtualFile @NotNull [] getLibraryRoots(@NotNull Project project2) {
        if (project2 == null) {
            LibraryUtil.$$$reportNull$$$0(14);
        }
        return LibraryUtil.getLibraryRoots(project2, true, true);
    }

    public static VirtualFile @NotNull [] getLibraryRoots(@NotNull Project project2, boolean includeSourceFiles, boolean includeJdk) {
        if (project2 == null) {
            LibraryUtil.$$$reportNull$$$0(15);
        }
        return LibraryUtil.getLibraryRoots(ModuleManager.getInstance(project2).getModules(), includeSourceFiles, includeJdk);
    }

    public static VirtualFile @NotNull [] getLibraryRoots(Module @NotNull [] modules2, boolean includeSourceFiles, boolean includeJdk) {
        if (modules2 == null) {
            LibraryUtil.$$$reportNull$$$0(16);
        }
        HashSet roots2 = new HashSet();
        for (Module module : modules2) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry entry : orderEntries = moduleRootManager.getOrderEntries()) {
                VirtualFile[] files2;
                if (entry instanceof LibraryOrderEntry) {
                    Library library2 = ((LibraryOrderEntry)entry).getLibrary();
                    if (library2 == null) continue;
                    VirtualFile[] virtualFileArray = files2 = includeSourceFiles ? library2.getFiles(OrderRootType.SOURCES) : null;
                    if (files2 == null || files2.length == 0) {
                        files2 = library2.getFiles(OrderRootType.CLASSES);
                    }
                    ContainerUtil.addAll(roots2, files2);
                    continue;
                }
                if (!includeJdk || !(entry instanceof JdkOrderEntry)) continue;
                JdkOrderEntry jdkEntry = (JdkOrderEntry)entry;
                VirtualFile[] virtualFileArray = files2 = includeSourceFiles ? jdkEntry.getRootFiles(OrderRootType.SOURCES) : null;
                if (files2 == null || files2.length == 0) {
                    files2 = jdkEntry.getRootFiles(OrderRootType.CLASSES);
                }
                ContainerUtil.addAll(roots2, files2);
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots2);
        if (virtualFileArray == null) {
            LibraryUtil.$$$reportNull$$$0(17);
        }
        return virtualFileArray;
    }

    @Nullable
    public static Library findLibrary(@NotNull Module module, @NotNull String name2) {
        if (module == null) {
            LibraryUtil.$$$reportNull$$$0(18);
        }
        if (name2 == null) {
            LibraryUtil.$$$reportNull$$$0(19);
        }
        Ref<Object> result2 = Ref.create(null);
        OrderEnumerator.orderEntries(module).forEachLibrary(library2 -> {
            if (name2.equals(library2.getName())) {
                result2.set(library2);
                return false;
            }
            return true;
        });
        return result2.get();
    }

    @Nullable
    public static OrderEntry findLibraryEntry(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            LibraryUtil.$$$reportNull$$$0(20);
        }
        if (project2 == null) {
            LibraryUtil.$$$reportNull$$$0(21);
        }
        List<OrderEntry> entries2 = ProjectRootManager.getInstance(project2).getFileIndex().getOrderEntriesForFile(file2);
        for (OrderEntry entry : entries2) {
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry)) continue;
            return entry;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public static String getPresentableName(@NotNull Library library2) {
        if (library2 == null) {
            LibraryUtil.$$$reportNull$$$0(22);
        }
        String string2 = library2.getPresentableName();
        if (string2 == null) {
            LibraryUtil.$$$reportNull$$$0(23);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 17: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 17: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 13: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/libraries/LibraryUtil";
                break;
            }
            case 14: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/libraries/LibraryUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClassAvailableInLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryByClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findInFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findInTable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
            case 13: 
            case 17: 
            case 23: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryEntry";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 13: 
            case 17: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

